/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.window;

import com.vaadin.server.LegacyApplication;
import com.vaadin.server.VaadinSession;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.ui.LegacyWindow;
import com.vaadin.ui.Window;
import org.junit.Assert;
import org.junit.Test;

public class AddRemoveSubWindowTest {
    @Test
    public void addSubWindow() {
        VaadinSession.setCurrent((VaadinSession)new AlwaysLockedVaadinSession(null));
        TestApp app = new TestApp();
        app.init();
        Window subWindow = new Window("Sub window");
        LegacyWindow mainWindow = app.getMainWindow();
        mainWindow.addWindow(subWindow);
        Assert.assertEquals((Object)subWindow.getParent(), (Object)mainWindow);
        try {
            mainWindow.addWindow(subWindow);
            Assert.assertTrue((String)"Window.addWindow did not throw the expected exception", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            LegacyWindow w = new LegacyWindow();
            w.addWindow(subWindow);
            Assert.assertTrue((String)"Window.addWindow did not throw the expected exception", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void removeSubWindow() {
        TestApp app = new TestApp();
        app.init();
        Window subWindow = new Window("Sub window");
        LegacyWindow mainWindow = app.getMainWindow();
        mainWindow.addWindow(subWindow);
        Assert.assertEquals((Object)subWindow.getParent(), (Object)mainWindow);
        Assert.assertEquals((Object)subWindow.getParent(), (Object)mainWindow);
        boolean removed = mainWindow.removeWindow(subWindow);
        Assert.assertTrue((String)"Window was not removed correctly", (boolean)removed);
        Assert.assertNull((Object)subWindow.getParent());
    }

    public class TestApp
    extends LegacyApplication {
        public void init() {
            LegacyWindow w = new LegacyWindow("Main window");
            this.setMainWindow(w);
        }
    }
}

