/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.ui;

import com.vaadin.server.DefaultDeploymentConfiguration;
import com.vaadin.server.DefaultUIProvider;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.UIClassSelectionEvent;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinSession;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.ui.UI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class CustomUIClassLoaderTest {
    @Test
    public void testWithDefaultClassLoader() throws Exception {
        VaadinSession application = this.createStubApplication();
        application.setConfiguration(CustomUIClassLoaderTest.createConfigurationMock());
        DefaultUIProvider uiProvider = new DefaultUIProvider();
        Class uiClass = uiProvider.getUIClass(new UIClassSelectionEvent(CustomUIClassLoaderTest.createRequestMock(this.getClass().getClassLoader())));
        Assert.assertEquals(MyUI.class, (Object)uiClass);
    }

    private static DeploymentConfiguration createConfigurationMock() {
        Properties properties = new Properties();
        properties.put("UI", MyUI.class.getName());
        return new DefaultDeploymentConfiguration(CustomUIClassLoaderTest.class, properties);
    }

    private static VaadinRequest createRequestMock(ClassLoader classloader) {
        VaadinService configurationMock = (VaadinService)EasyMock.createMock(VaadinService.class);
        EasyMock.expect((Object)configurationMock.getDeploymentConfiguration()).andReturn((Object)CustomUIClassLoaderTest.createConfigurationMock());
        EasyMock.expect((Object)configurationMock.getClassLoader()).andReturn((Object)classloader);
        VaadinRequest requestMock = (VaadinRequest)EasyMock.createMock(VaadinRequest.class);
        EasyMock.expect((Object)requestMock.getService()).andReturn((Object)configurationMock);
        EasyMock.expect((Object)requestMock.getService()).andReturn((Object)configurationMock);
        EasyMock.expect((Object)requestMock.getService()).andReturn((Object)configurationMock);
        EasyMock.replay((Object[])new Object[]{configurationMock, requestMock});
        return requestMock;
    }

    @Test
    public void testWithClassLoader() throws Exception {
        LoggingClassLoader loggingClassLoader = new LoggingClassLoader();
        DefaultUIProvider uiProvider = new DefaultUIProvider();
        Class uiClass = uiProvider.getUIClass(new UIClassSelectionEvent(CustomUIClassLoaderTest.createRequestMock(loggingClassLoader)));
        Assert.assertEquals(MyUI.class, (Object)uiClass);
        Assert.assertEquals((long)1L, (long)loggingClassLoader.requestedClasses.size());
        Assert.assertEquals((Object)MyUI.class.getName(), loggingClassLoader.requestedClasses.get(0));
    }

    private VaadinSession createStubApplication() {
        return new AlwaysLockedVaadinSession(null){

            public DeploymentConfiguration getConfiguration() {
                return CustomUIClassLoaderTest.createConfigurationMock();
            }
        };
    }

    public class LoggingClassLoader
    extends ClassLoader {
        private final List<String> requestedClasses = new ArrayList<String>();

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            this.requestedClasses.add(name);
            return super.loadClass(name, resolve);
        }
    }

    public static class MyUI
    extends UI {
        protected void init(VaadinRequest request) {
        }
    }
}

