/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.slider;

import com.vaadin.shared.ui.slider.SliderOrientation;
import com.vaadin.tests.design.DeclarativeTestBase;
import com.vaadin.ui.Slider;
import org.junit.Test;

public class SliderDeclarativeTest
extends DeclarativeTestBase<Slider> {
    @Test
    public void testDefault() {
        String design = "<vaadin-slider>";
        Slider expected = new Slider();
        this.testRead(design, expected);
        this.testWrite(design, expected);
    }

    @Test
    public void testHorizontal() {
        String design = "<vaadin-slider min=10 max=20 resolution=1 value=12.3>";
        Slider expected = new Slider();
        expected.setMin(10.0);
        expected.setMax(20.0);
        expected.setResolution(1);
        expected.setValue(Double.valueOf(12.3));
        this.testRead(design, expected);
        this.testWrite(design, expected);
    }

    @Test
    public void testVertical() {
        String design = "<vaadin-slider vertical>";
        Slider expected = new Slider();
        expected.setOrientation(SliderOrientation.VERTICAL);
        this.testRead(design, expected);
        this.testWrite(design, expected);
    }

    @Test
    public void testReadOnlyValue() {
        String design = "<vaadin-slider readonly min=10 max=20 resolution=1 value=12.3>";
        Slider expected = new Slider();
        expected.setMin(10.0);
        expected.setMax(20.0);
        expected.setResolution(1);
        expected.setValue(Double.valueOf(12.3));
        expected.setReadOnly(true);
        this.testRead(design, expected);
        this.testWrite(design, expected);
    }
}

