/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.grid;

import com.vaadin.data.HasValue;
import com.vaadin.data.SelectionModel;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.Query;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.shared.ui.grid.HeightMode;
import com.vaadin.tests.data.bean.Address;
import com.vaadin.tests.data.bean.Country;
import com.vaadin.tests.data.bean.Person;
import com.vaadin.tests.data.bean.Sex;
import com.vaadin.tests.server.component.abstractlisting.AbstractListingDeclarativeTest;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextField;
import com.vaadin.ui.components.grid.FooterCell;
import com.vaadin.ui.components.grid.FooterRow;
import com.vaadin.ui.components.grid.HeaderCell;
import com.vaadin.ui.components.grid.HeaderRow;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.ui.declarative.DesignException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;
import org.jsoup.select.Selector;
import org.junit.Assert;
import org.junit.Test;

public class GridDeclarativeTest
extends AbstractListingDeclarativeTest<Grid> {
    @Test
    public void gridAttributes() {
        Grid grid = new Grid();
        int frozenColumns = 1;
        HeightMode heightMode = HeightMode.ROW;
        double heightByRows = 13.7;
        grid.addColumn(Person::getFirstName).setCaption("First Name");
        grid.addColumn(Person::getLastName).setId("id").setCaption("Id");
        grid.setFrozenColumnCount(frozenColumns);
        grid.setSelectionMode(Grid.SelectionMode.MULTI);
        grid.setHeightMode(heightMode);
        grid.setHeightByRows(heightByRows);
        String design = String.format("<%s height-mode='%s' frozen-columns='%d' rows='%s' selection-mode='%s'><table><colgroup><col column-id='column0' sortable><col column-id='id' sortable></colgroup><thead><tr default><th plain-text column-ids='column0'>First Name</th><th plain-text column-ids='id'>Id</th></tr></thead></table></%s>", this.getComponentTag(), heightMode.toString().toLowerCase(Locale.ROOT), frozenColumns, heightByRows, Grid.SelectionMode.MULTI.toString().toLowerCase(Locale.ROOT), this.getComponentTag());
        this.testRead(design, grid);
        this.testWrite(design, grid);
    }

    @Test
    public void mergedHeaderCells() {
        Grid grid = new Grid();
        Grid.Column column1 = grid.addColumn(Person::getFirstName).setCaption("First Name");
        Grid.Column column2 = grid.addColumn(Person::getLastName).setId("id").setCaption("Id");
        Grid.Column column3 = grid.addColumn(Person::getEmail).setId("mail").setCaption("Mail");
        HeaderRow header = grid.addHeaderRowAt(1);
        String headerRowText1 = "foo";
        header.getCell(column1).setText(headerRowText1);
        HeaderCell cell2 = header.getCell(column2);
        HeaderCell join = header.join(new HeaderCell[]{cell2, header.getCell(column3)});
        String headerRowText3 = "foobar";
        join.setText(headerRowText3);
        String design = String.format("<%s><table><colgroup><col column-id='column0' sortable><col column-id='id' sortable><col column-id='mail' sortable></colgroup><thead><tr default><th plain-text column-ids='column0'>First Name</th><th plain-text column-ids='id'>Id</th><th plain-text column-ids='mail'>Mail</th></tr><tr><th plain-text column-ids='column0'>%s</th><th colspan='2' plain-text column-ids='id,mail'>foobar</th></tr></thead></table></%s>", this.getComponentTag(), headerRowText1, headerRowText3, this.getComponentTag());
        this.testRead(design, grid);
        this.testWrite(design, grid);
    }

    @Test
    public void mergedFooterCells() {
        Grid grid = new Grid();
        Grid.Column column1 = grid.addColumn(Person::getFirstName).setCaption("First Name");
        Grid.Column column2 = grid.addColumn(Person::getLastName).setId("id").setCaption("Id");
        Grid.Column column3 = grid.addColumn(Person::getEmail).setId("mail").setCaption("Mail");
        FooterRow footer = grid.addFooterRowAt(0);
        FooterCell cell1 = footer.getCell(column1);
        String footerRowText1 = "foo";
        cell1.setText(footerRowText1);
        FooterCell cell2 = footer.getCell(column2);
        FooterCell cell3 = footer.getCell(column3);
        String footerRowText2 = "foobar";
        footer.join(new FooterCell[]{cell2, cell3}).setHtml(footerRowText2);
        String design = String.format("<%s><table><colgroup><col column-id='column0' sortable><col column-id='id' sortable><col column-id='mail' sortable></colgroup><thead><tr default><th plain-text column-ids='column0'>First Name</th><th plain-text column-ids='id'>Id</th><th plain-text column-ids='mail'>Mail</th></tr></thead><tfoot><tr><td plain-text column-ids='column0'>%s</td><td colspan='2' column-ids='id,mail'>%s</td></tr></tfoot></table></%s>", this.getComponentTag(), footerRowText1, footerRowText2, this.getComponentTag());
        this.testRead(design, grid);
        this.testWrite(design, grid);
    }

    @Test
    public void columnAttributes() {
        Grid grid = new Grid();
        String secondColumnId = "sortableColumn";
        Grid.Column notSortableColumn = grid.addColumn(Person::getFirstName).setCaption("First Name");
        Grid.Column column2 = grid.addColumn(Person::getLastName).setId(secondColumnId).setCaption("Id");
        String caption = "not-sortable-column";
        notSortableColumn.setCaption(caption);
        boolean sortable = false;
        notSortableColumn.setSortable(sortable);
        boolean editable = true;
        notSortableColumn.setEditorComponent((HasValue)new TextField(), Person::setLastName);
        notSortableColumn.setEditable(editable);
        boolean resizable = false;
        notSortableColumn.setResizable(resizable);
        boolean hidable = true;
        notSortableColumn.setHidable(hidable);
        boolean hidden = true;
        notSortableColumn.setHidden(hidden);
        String hidingToggleCaption = "sortable-toggle-caption";
        column2.setHidingToggleCaption(hidingToggleCaption);
        double width = 17.3;
        column2.setWidth(width);
        double minWidth = 37.3;
        column2.setMinimumWidth(minWidth);
        double maxWidth = 63.4;
        column2.setMaximumWidth(maxWidth);
        int expandRatio = 83;
        column2.setExpandRatio(expandRatio);
        String design = String.format("<%s><table><colgroup><col column-id='column0' sortable='%s' editable resizable='%s' hidable hidden><col column-id='sortableColumn' sortable hiding-toggle-caption='%s' width='%s' min-width='%s' max-width='%s' expand='%s'></colgroup><thead><tr default><th plain-text column-ids='column0'>%s</th><th plain-text column-ids='sortableColumn'>%s</th></tr></thead></table></%s>", this.getComponentTag(), sortable, resizable, hidingToggleCaption, width, minWidth, maxWidth, expandRatio, caption, "Id", this.getComponentTag());
        this.testRead(design, grid, true);
        this.testWrite(design, grid);
    }

    @Test
    public void headerFooterSerialization() {
        Grid grid = new Grid();
        Grid.Column column1 = grid.addColumn(Person::getFirstName).setCaption("First Name");
        Grid.Column column2 = grid.addColumn(Person::getLastName).setId("id").setCaption("Id");
        FooterRow footerRow = grid.addFooterRowAt(0);
        footerRow.getCell(column1).setText("x");
        footerRow.getCell(column2).setHtml("y");
        String design = String.format("<%s><table><colgroup><col column-id='column0' sortable><col column-id='id' sortable></colgroup><thead><tr default><th plain-text column-ids='column0'>First Name</th><th plain-text column-ids='id'>Id</th></tr></thead><tbody></tbody><tfoot><tr><td plain-text column-ids='column0'>x</td><td column-ids='id'>y</td></tr></tfoot></table></%s>", this.getComponentTag(), this.getComponentTag());
        this.testRead(design, grid);
        this.testWrite(design, grid, true);
    }

    @Override
    public void dataSerialization() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Grid grid = new Grid();
        Person person1 = this.createPerson("foo", "bar");
        Person person2 = this.createPerson("name", "last-name");
        grid.setItems((Object[])new Person[]{person1, person2});
        grid.addColumn(Person::getFirstName).setCaption("First Name");
        grid.addColumn(Person::getLastName).setId("id").setCaption("Id");
        String design = String.format("<%s><table><colgroup><col column-id='column0' sortable><col column-id='id' sortable></colgroup><thead><tr default><th plain-text column-ids='column0'>First Name</th><th plain-text column-ids='id'>Id</th></tr></thead><tbody><tr item='%s'><td>%s</td><td>%s</td></tr><tr item='%s'><td>%s</td><td>%s</td></tr></tbody></table></%s>", this.getComponentTag(), person1.toString(), person1.getFirstName(), person1.getLastName(), person2.toString(), person2.getFirstName(), person2.getLastName(), this.getComponentTag());
        Grid<?> readGrid = this.testRead(design, grid, true, true);
        Assert.assertEquals((long)2L, (long)readGrid.getDataProvider().size(new Query()));
        this.testWrite(design, grid, true);
    }

    @Override
    @Test
    public void valueSerialization() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        this.valueSingleSelectSerialization();
    }

    @Test
    public void valueMultiSelectSerialization() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Grid grid = new Grid();
        Person person1 = this.createPerson("foo", "bar");
        Person person2 = this.createPerson("name", "last-name");
        Person person3 = this.createPerson("foo", "last-name");
        grid.setItems((Object[])new Person[]{person1, person2, person3});
        grid.addColumn(Person::getFirstName).setCaption("First Name");
        grid.addColumn(Person::getLastName).setId("id").setCaption("Id");
        SelectionModel.Multi model = (SelectionModel.Multi)grid.setSelectionMode(Grid.SelectionMode.MULTI);
        model.selectItems((Object[])new Person[]{person1, person3});
        String design = String.format("<%s selection-mode='multi'><table><colgroup><col column-id='column0' sortable><col column-id='id' sortable></colgroup><thead><tr default><th plain-text column-ids='column0'>First Name</th><th plain-text column-ids='id'>Id</th></tr></thead><tbody><tr item='%s' selected><td>%s</td><td>%s</td></tr><tr item='%s'><td>%s</td><td>%s</td></tr><tr item='%s' selected><td>%s</td><td>%s</td></tr></tbody></table></%s>", this.getComponentTag(), person1.toString(), person1.getFirstName(), person1.getLastName(), person2.toString(), person2.getFirstName(), person2.getLastName(), person3.toString(), person3.getFirstName(), person3.getLastName(), this.getComponentTag());
        Grid<?> readGrid = this.testRead(design, grid, true, true);
        Assert.assertEquals((long)3L, (long)readGrid.getDataProvider().size(new Query()));
        this.testWrite(design, grid, true);
    }

    private void valueSingleSelectSerialization() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Grid grid = new Grid();
        Person person1 = this.createPerson("foo", "bar");
        Person person2 = this.createPerson("name", "last-name");
        grid.setItems((Object[])new Person[]{person1, person2});
        grid.addColumn(Person::getFirstName).setCaption("First Name");
        grid.addColumn(Person::getLastName).setId("id").setCaption("Id");
        SelectionModel.Single model = (SelectionModel.Single)grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        model.select((Object)person2);
        String design = String.format("<%s><table><colgroup><col column-id='column0' sortable><col column-id='id' sortable></colgroup><thead><tr default><th plain-text column-ids='column0'>First Name</th><th plain-text column-ids='id'>Id</th></tr></thead><tbody><tr item='%s'><td>%s</td><td>%s</td></tr><tr item='%s' selected><td>%s</td><td>%s</td></tr></tbody></table></%s>", this.getComponentTag(), person1.toString(), person1.getFirstName(), person1.getLastName(), person2.toString(), person2.getFirstName(), person2.getLastName(), this.getComponentTag());
        Grid<?> readGrid = this.testRead(design, grid, true, true);
        Assert.assertEquals((long)2L, (long)readGrid.getDataProvider().size(new Query()));
        this.testWrite(design, grid, true);
    }

    @Override
    public void readOnlySelection() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Grid grid = new Grid();
        Person person1 = this.createPerson("foo", "bar");
        Person person2 = this.createPerson("name", "last-name");
        grid.setItems((Object[])new Person[]{person1, person2});
        grid.addColumn(Person::getFirstName).setCaption("First Name");
        grid.addColumn(Person::getLastName).setId("id").setCaption("Id");
        grid.setSelectionMode(Grid.SelectionMode.MULTI);
        grid.asMultiSelect().setReadOnly(true);
        String formatString = "<%s %s readonly><table><colgroup><col column-id='column0' sortable><col column-id='id' sortable></colgroup><thead><tr default><th plain-text column-ids='column0'>First Name</th><th plain-text column-ids='id'>Id</th></tr></thead><tbody><tr item='%s'><td>%s</td><td>%s</td></tr><tr item='%s'><td>%s</td><td>%s</td></tr></tbody></table></%s>";
        String design = String.format(formatString, this.getComponentTag(), "selection-mode='multi'", person1.toString(), person1.getFirstName(), person1.getLastName(), person2.toString(), person2.getFirstName(), person2.getLastName(), this.getComponentTag());
        Grid<?> readGrid = this.testRead(design, grid, true, true);
        Assert.assertEquals((long)2L, (long)readGrid.getDataProvider().size(new Query()));
        this.testWrite(design, grid, true);
        grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        grid.asSingleSelect().setReadOnly(true);
        design = String.format(formatString, this.getComponentTag(), "", person1.toString(), person1.getFirstName(), person1.getLastName(), person2.toString(), person2.getFirstName(), person2.getLastName(), this.getComponentTag());
        readGrid = this.testRead(design, grid, true, true);
        Assert.assertEquals((long)2L, (long)readGrid.getDataProvider().size(new Query()));
        this.testWrite(design, grid, true);
    }

    @Test
    public void testComponentInGridHeader() {
        Grid grid = new Grid();
        Grid.Column column = grid.addColumn(Person::getFirstName).setCaption("First Name");
        String html = "<b>Foo</b>";
        Label component = new Label(html);
        component.setContentMode(ContentMode.HTML);
        String design = String.format("<%s><table><colgroup>   <col sortable column-id='column0'></colgroup><thead><tr default><th column-ids='column0'><vaadin-label>%s</vaadin-label></th></tr></thead></table></%s>", this.getComponentTag(), html, this.getComponentTag());
        grid.getDefaultHeaderRow().getCell(column).setComponent((Component)component);
        this.testRead(design, grid, true);
        this.testWrite(design, grid);
    }

    @Test
    public void testComponentInGridFooter() {
        Grid grid = new Grid();
        Grid.Column column = grid.addColumn(Person::getFirstName).setCaption("First Name");
        String html = "<b>Foo</b>";
        Label component = new Label(html);
        component.setContentMode(ContentMode.HTML);
        grid.prependFooterRow().getCell(column).setComponent((Component)component);
        grid.removeHeaderRow(grid.getDefaultHeaderRow());
        String design = String.format("<%s><table><colgroup>   <col sortable column-id='column0'></colgroup><thead><tfoot><tr><td column-ids='column0'><vaadin-label>%s</vaadin-label></td></tr></tfoot></table></%s>", this.getComponentTag(), html, this.getComponentTag());
        this.testRead(design, grid, true);
        this.testWrite(design, grid);
    }

    @Test
    public void testNoHeaderRows() {
        String design = "<vaadin-grid><table><colgroup>   <col sortable column-id='column0'></colgroup><thead /></table></vaadin-grid>";
        Grid grid = new Grid();
        grid.addColumn(Person::getFirstName).setCaption("First Name");
        grid.removeHeaderRow(grid.getDefaultHeaderRow());
        this.testWrite(design, grid);
        this.testRead(design, grid, true);
    }

    @Test
    public void testReadEmptyGrid() {
        String design = "<vaadin-grid />";
        this.testRead(design, new Grid(), false);
    }

    @Test
    public void testEmptyGrid() {
        String design = "<vaadin-grid></vaadin-grid>";
        Grid expected = new Grid();
        this.testWrite(design, expected);
        this.testRead(design, expected, true);
    }

    @Test(expected=DesignException.class)
    public void testMalformedGrid() {
        String design = "<vaadin-grid><vaadin-label /></vaadin-grid>";
        this.testRead(design, new Grid());
    }

    @Test(expected=DesignException.class)
    public void testGridWithNoColGroup() {
        String design = "<vaadin-grid><table><thead><tr><th>Foo</tr></thead></table></vaadin-grid>";
        this.testRead(design, new Grid());
    }

    @Test
    public void testHtmlEntitiesinGridHeaderFooter() {
        String id = "> id";
        String plainText = "plain-text";
        String design = String.format("<%s><table><colgroup>  <col sortable column-id='%s'></colgroup><thead>   <tr default><th %s column-ids='%s'>&gt; Test</th></thead><tfoot><tr><td %s column-ids='%s'>&gt; Test</td></tr></tfoot><tbody /></table></%s>", this.getComponentTag(), id, plainText, id, plainText, id, this.getComponentTag());
        Grid grid = (Grid)this.read(design);
        String actualHeader = grid.getHeaderRow(0).getCell(id).getText();
        String actualFooter = grid.getFooterRow(0).getCell(id).getText();
        String expected = "> Test";
        Assert.assertEquals((Object)expected, (Object)actualHeader);
        Assert.assertEquals((Object)expected, (Object)actualFooter);
        design = design.replace(plainText, "");
        grid = (Grid)this.read(design);
        actualHeader = grid.getHeaderRow(0).getCell(id).getHtml();
        actualFooter = grid.getFooterRow(0).getCell(id).getHtml();
        expected = "&gt; Test";
        Assert.assertEquals((Object)expected, (Object)actualHeader);
        Assert.assertEquals((Object)expected, (Object)actualFooter);
        grid = new Grid();
        Grid.Column column = grid.addColumn(Person::getFirstName).setId(id);
        HeaderRow header = grid.addHeaderRowAt(0);
        FooterRow footer = grid.addFooterRowAt(0);
        grid.removeHeaderRow(grid.getDefaultHeaderRow());
        header.getCell(column).setText("&amp; Test");
        footer.getCell(column).setText("&amp; Test");
        Element root = new Element(Tag.valueOf((String)this.getComponentTag()), "");
        grid.writeDesign(root, new DesignContext());
        Assert.assertEquals((Object)"&amp;amp; Test", (Object)((Element)root.getElementsByTag("th").get(0)).html());
        Assert.assertEquals((Object)"&amp;amp; Test", (Object)((Element)root.getElementsByTag("td").get(0)).html());
        header = grid.addHeaderRowAt(0);
        footer = grid.addFooterRowAt(0);
        header.getCell(id).setHtml("&amp; Test");
        footer.getCell(id).setHtml("&amp; Test");
        root = new Element(Tag.valueOf((String)this.getComponentTag()), "");
        grid.writeDesign(root, new DesignContext());
        Assert.assertEquals((Object)"&amp; Test", (Object)((Element)root.getElementsByTag("th").get(0)).html());
        Assert.assertEquals((Object)"&amp; Test", (Object)((Element)root.getElementsByTag("td").get(0)).html());
    }

    @Override
    public Grid<?> testRead(String design, Grid expected) {
        return this.testRead(design, expected, false);
    }

    @Override
    public Grid<?> testRead(String design, Grid expected, boolean retestWrite) {
        return this.testRead(design, expected, retestWrite, false);
    }

    public Grid<?> testRead(String design, Grid expected, boolean retestWrite, boolean writeData) {
        Grid actual = super.testRead(design, expected);
        this.compareGridColumns(expected, actual);
        this.compareHeaders(expected, actual);
        this.compareFooters(expected, actual);
        if (retestWrite) {
            this.testWrite(design, actual, writeData);
        }
        return actual;
    }

    private void compareHeaders(Grid<?> expected, Grid<?> actual) {
        Assert.assertEquals((String)"Different header row count", (long)expected.getHeaderRowCount(), (long)actual.getHeaderRowCount());
        for (int i = 0; i < expected.getHeaderRowCount(); ++i) {
            HeaderRow expectedRow = expected.getHeaderRow(i);
            HeaderRow actualRow = actual.getHeaderRow(i);
            if (expectedRow.equals(expected.getDefaultHeaderRow())) {
                Assert.assertEquals((String)"Different index for default header row", (Object)actual.getDefaultHeaderRow(), (Object)actualRow);
            }
            for (Grid.Column column : expected.getColumns()) {
                String baseError = "Difference when comparing cell for " + column.toString() + " on header row " + i + ": ";
                HeaderCell expectedCell = expectedRow.getCell(column);
                HeaderCell actualCell = actualRow.getCell(column);
                switch (expectedCell.getCellType()) {
                    case TEXT: {
                        Assert.assertEquals((String)(baseError + "Text content"), (Object)expectedCell.getText(), (Object)actualCell.getText());
                        break;
                    }
                    case HTML: {
                        Assert.assertEquals((String)(baseError + "HTML content"), (Object)expectedCell.getHtml(), (Object)actualCell.getHtml());
                        break;
                    }
                    case WIDGET: {
                        this.assertEqualsCustom(baseError + "Component content", expectedCell.getComponent(), actualCell.getComponent());
                    }
                }
            }
        }
    }

    private void compareFooters(Grid<?> expected, Grid<?> actual) {
        Assert.assertEquals((String)"Different footer row count", (long)expected.getFooterRowCount(), (long)actual.getFooterRowCount());
        for (int i = 0; i < expected.getFooterRowCount(); ++i) {
            FooterRow expectedRow = expected.getFooterRow(i);
            FooterRow actualRow = actual.getFooterRow(i);
            for (Grid.Column column : expected.getColumns()) {
                String baseError = "Difference when comparing cell for " + column.toString() + " on footer row " + i + ": ";
                FooterCell expectedCell = expectedRow.getCell(column);
                FooterCell actualCell = actualRow.getCell(column);
                switch (expectedCell.getCellType()) {
                    case TEXT: {
                        Assert.assertEquals((String)(baseError + "Text content"), (Object)expectedCell.getText(), (Object)actualCell.getText());
                        break;
                    }
                    case HTML: {
                        Assert.assertEquals((String)(baseError + "HTML content"), (Object)expectedCell.getHtml(), (Object)actualCell.getHtml());
                        break;
                    }
                    case WIDGET: {
                        this.assertEqualsCustom(baseError + "Component content", expectedCell.getComponent(), actualCell.getComponent());
                    }
                }
            }
        }
    }

    private void compareGridColumns(Grid<?> expected, Grid<?> actual) {
        List columns = expected.getColumns();
        List actualColumns = actual.getColumns();
        Assert.assertEquals((String)"Different amount of columns", (long)columns.size(), (long)actualColumns.size());
        for (int i = 0; i < columns.size(); ++i) {
            Grid.Column col1 = (Grid.Column)columns.get(i);
            Grid.Column col2 = (Grid.Column)actualColumns.get(i);
            String baseError = "Error when comparing columns for property " + col1.getId() + ": ";
            Assert.assertEquals((String)(baseError + "Width"), (double)col1.getWidth(), (double)col2.getWidth(), (double)0.0);
            Assert.assertEquals((String)(baseError + "Maximum width"), (double)col1.getMaximumWidth(), (double)col2.getMaximumWidth(), (double)0.0);
            Assert.assertEquals((String)(baseError + "Minimum width"), (double)col1.getMinimumWidth(), (double)col2.getMinimumWidth(), (double)0.0);
            Assert.assertEquals((String)(baseError + "Expand ratio"), (long)col1.getExpandRatio(), (long)col2.getExpandRatio());
            String id1 = col1.getId();
            String id2 = col2.getId();
            if (id1 != null && id2 != null || id1 == null && id2 == null) {
                Assert.assertEquals((String)(baseError + "Sortable"), (Object)col1.isSortable(), (Object)col2.isSortable());
            }
            Assert.assertEquals((String)(baseError + "Editable"), (Object)col1.isEditable(), (Object)col2.isEditable());
            Assert.assertEquals((String)(baseError + "Hidable"), (Object)col1.isHidable(), (Object)col2.isHidable());
            Assert.assertEquals((String)(baseError + "Hidden"), (Object)col1.isHidden(), (Object)col2.isHidden());
            Assert.assertEquals((String)(baseError + "HidingToggleCaption"), (Object)col1.getHidingToggleCaption(), (Object)col2.getHidingToggleCaption());
        }
    }

    @Override
    protected String getComponentTag() {
        return "vaadin-grid";
    }

    @Override
    protected Class<? extends Grid> getComponentClass() {
        return Grid.class;
    }

    @Override
    protected boolean acceptProperty(Class<?> clazz, Method readMethod, Method writeMethod) {
        Class<?> returnType;
        if (readMethod != null && (HeaderRow.class.equals(returnType = readMethod.getReturnType()) || DataProvider.class.equals(returnType))) {
            return false;
        }
        return super.acceptProperty(clazz, readMethod, writeMethod);
    }

    private Person createPerson(String name, String lastName) {
        Person person = new Person(){

            @Override
            public String toString() {
                return this.getFirstName() + " " + this.getLastName();
            }
        };
        person.setFirstName(name);
        person.setLastName(lastName);
        return person;
    }

    @Test
    public void beanItemType() throws Exception {
        Class<Person> beanClass = Person.class;
        String beanClassName = beanClass.getName();
        String design = String.format("<%s data-item-type=\"%s\"></%s>", this.getComponentTag(), beanClassName, this.getComponentTag());
        Grid grid = (Grid)this.read(design);
        Assert.assertEquals(beanClass, (Object)grid.getBeanType());
        this.testWrite(design, grid);
    }

    @Test
    public void beanGridDefaultColumns() {
        Grid grid = new Grid(Person.class);
        String design = this.write(grid, false);
        this.assertDeclarativeColumnCount(12, design);
        Person testPerson = new Person("the first", "the last", "The email", 64, Sex.MALE, new Address("the street", 12313, "The city", Country.SOUTH_AFRICA));
        Grid readGrid = (Grid)this.read(design);
        this.assertColumns(12, grid.getColumns(), readGrid.getColumns(), testPerson);
    }

    private void assertDeclarativeColumnCount(int i, String design) {
        Document html = Jsoup.parse((String)design);
        Elements cols = Selector.select((String)"vaadin-grid", (Element)html).select("colgroup > col");
        Assert.assertEquals((String)"Number of columns in the design file", (long)i, (long)cols.size());
    }

    private void assertColumns(int expectedCount, List<Grid.Column<Person, ?>> expectedColumns, List<Grid.Column<Person, ?>> columns, Person testPerson) {
        Assert.assertEquals((long)expectedCount, (long)expectedColumns.size());
        Assert.assertEquals((long)expectedCount, (long)columns.size());
        for (int i = 0; i < expectedColumns.size(); ++i) {
            Grid.Column<Person, ?> expectedColumn = expectedColumns.get(i);
            Grid.Column<Person, ?> column = columns.get(i);
            Assert.assertEquals((Object)expectedColumn.getId(), (Object)column.getId());
            Assert.assertEquals((Object)expectedColumn.getCaption(), (Object)column.getCaption());
            if (column.getId() == null || column.getId().equals("column" + i)) continue;
            Assert.assertEquals((Object)expectedColumn.getValueProvider().apply((Object)testPerson), (Object)column.getValueProvider().apply((Object)testPerson));
        }
    }

    @Test
    public void beanGridNoColumns() {
        Grid grid = new Grid(Person.class);
        grid.setColumns(new String[0]);
        String design = this.write(grid, false);
        this.assertDeclarativeColumnCount(0, design);
        Person testPerson = new Person("the first", "the last", "The email", 64, Sex.MALE, new Address("the street", 12313, "The city", Country.SOUTH_AFRICA));
        Grid readGrid = (Grid)this.read(design);
        this.assertColumns(0, grid.getColumns(), readGrid.getColumns(), testPerson);
        Assert.assertEquals((Object)"The email", (Object)readGrid.addColumn("email").getValueProvider().apply((Object)testPerson));
    }

    @Test
    public void beanGridOnlyCustomColumns() {
        Grid grid = new Grid(Person.class);
        grid.setColumns(new String[0]);
        grid.addColumn(Person::getFirstName).setCaption("First Name");
        String design = this.write(grid, false);
        this.assertDeclarativeColumnCount(1, design);
        Person testPerson = new Person("the first", "the last", "The email", 64, Sex.MALE, new Address("the street", 12313, "The city", Country.SOUTH_AFRICA));
        Grid readGrid = (Grid)this.read(design);
        this.assertColumns(1, grid.getColumns(), readGrid.getColumns(), testPerson);
        Assert.assertNull((Object)((Grid.Column)readGrid.getColumns().get(0)).getValueProvider().apply((Object)testPerson));
        Assert.assertEquals((Object)"the last", (Object)readGrid.addColumn("lastName").getValueProvider().apply((Object)testPerson));
    }

    @Test
    public void beanGridOneCustomizedColumn() {
        Grid grid = new Grid(Person.class);
        grid.addColumn((ValueProvider & Serializable)person -> person.getFirstName() + " " + person.getLastName()).setCaption("First and Last");
        String design = this.write(grid, false);
        this.assertDeclarativeColumnCount(13, design);
        Person testPerson = new Person("the first", "the last", "The email", 64, Sex.MALE, new Address("the street", 12313, "The city", Country.SOUTH_AFRICA));
        Grid readGrid = (Grid)this.read(design);
        this.assertColumns(13, grid.getColumns(), readGrid.getColumns(), testPerson);
        Assert.assertNull((Object)((Grid.Column)readGrid.getColumns().get(12)).getValueProvider().apply((Object)testPerson));
    }
}

