/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.grid;

import com.vaadin.data.Binder;
import com.vaadin.data.PropertyDefinition;
import com.vaadin.data.PropertySet;
import com.vaadin.shared.communication.ServerRpc;
import com.vaadin.shared.ui.grid.editor.EditorServerRpc;
import com.vaadin.ui.Grid;
import com.vaadin.ui.components.grid.EditorCancelEvent;
import com.vaadin.ui.components.grid.EditorCancelListener;
import com.vaadin.ui.components.grid.EditorImpl;
import com.vaadin.ui.components.grid.EditorSaveEvent;
import com.vaadin.ui.components.grid.EditorSaveListener;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class EditorImplTest {
    private Object beanToEdit = new Object();
    private TestEditorImpl editor;
    private Binder<Object> binder;

    @Before
    public void setUp() {
        this.editor = new TestEditorImpl();
        this.editor.addSaveListener(this.editor);
        this.editor.addCancelListener(this.editor);
        this.binder = (Binder)Mockito.mock(Binder.class);
        this.editor.setBinder(this.binder);
        this.editor.setEnabled(true);
        this.editor.doEdit(this.beanToEdit);
    }

    @Test
    public void save_eventIsFired() {
        Mockito.when((Object)this.binder.writeBeanIfValid(Mockito.any())).thenReturn((Object)true);
        this.editor.save();
        Assert.assertNotNull(this.editor.saveEvent);
        Assert.assertNull(this.editor.cancelEvent);
        Assert.assertEquals((Object)((Object)this.editor), (Object)this.editor.saveEvent.getSource());
        Assert.assertEquals((Object)this.beanToEdit, (Object)this.editor.saveEvent.getBean());
    }

    @Test
    public void cancel_eventIsFired() {
        this.editor.cancel();
        Assert.assertNull(this.editor.saveEvent);
        Assert.assertNotNull(this.editor.cancelEvent);
        Assert.assertEquals((Object)((Object)this.editor), (Object)this.editor.cancelEvent.getSource());
        Assert.assertEquals((Object)this.beanToEdit, (Object)this.editor.cancelEvent.getBean());
    }

    @Test
    public void saveFromClient_eventIsFired() {
        Mockito.when((Object)this.binder.writeBeanIfValid(Mockito.any())).thenReturn((Object)true);
        this.editor.rpc.save();
        Assert.assertNotNull(this.editor.saveEvent);
        Assert.assertNull(this.editor.cancelEvent);
        Assert.assertEquals((Object)((Object)this.editor), (Object)this.editor.saveEvent.getSource());
        Assert.assertEquals((Object)this.beanToEdit, (Object)this.editor.saveEvent.getBean());
    }

    @Test
    public void cancelFromClient_eventIsFired() {
        this.editor.rpc.cancel(false);
        Assert.assertNull(this.editor.saveEvent);
        Assert.assertNotNull(this.editor.cancelEvent);
        Assert.assertEquals((Object)((Object)this.editor), (Object)this.editor.cancelEvent.getSource());
        Assert.assertEquals((Object)this.beanToEdit, (Object)this.editor.cancelEvent.getBean());
    }

    @Test
    public void cancelAfterSaveFromClient_eventIsNotFired() {
        this.editor.rpc.cancel(true);
        Assert.assertNull(this.editor.saveEvent);
        Assert.assertNull(this.editor.cancelEvent);
    }

    public static class TestEditorImpl
    extends EditorImpl<Object>
    implements EditorSaveListener<Object>,
    EditorCancelListener<Object> {
        EditorCancelEvent<Object> cancelEvent;
        EditorSaveEvent<Object> saveEvent;
        EditorServerRpc rpc;

        public void doEdit(Object bean) {
            super.doEdit(bean);
        }

        public TestEditorImpl() {
            super((PropertySet)new PropertySet<Object>(){

                public Stream<PropertyDefinition<Object, ?>> getProperties() {
                    return null;
                }

                public Optional<PropertyDefinition<Object, ?>> getProperty(String name) {
                    return null;
                }
            });
        }

        public Grid<Object> getParent() {
            return new Grid();
        }

        public boolean isBuffered() {
            return true;
        }

        protected void refresh(Object item) {
        }

        public void onEditorCancel(EditorCancelEvent<Object> event) {
            Assert.assertNull(this.cancelEvent);
            this.cancelEvent = event;
        }

        public void onEditorSave(EditorSaveEvent<Object> event) {
            Assert.assertNull(this.saveEvent);
            this.saveEvent = event;
        }

        protected <T extends ServerRpc> void registerRpc(T implementation) {
            if (implementation instanceof EditorServerRpc) {
                this.rpc = (EditorServerRpc)implementation;
            }
            super.registerRpc(implementation);
        }
    }
}

