/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.abstractmultiselect;

import com.vaadin.tests.design.DeclarativeTestBaseBase;
import com.vaadin.tests.server.component.abstractlisting.AbstractListingDeclarativeTest;
import com.vaadin.ui.AbstractMultiSelect;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.declarative.DesignContext;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractMultiSelectDeclarativeTest<T extends AbstractMultiSelect>
extends AbstractListingDeclarativeTest<T> {
    @Override
    @Test
    public void dataSerialization() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        List<String> items = Arrays.asList("foo", "bar", "foobar");
        String type = "com.vaadin.SomeType";
        String attribute = "data-type";
        String design = String.format("<%s %s='%s'>\n<option item='foo' selected>foo1</option>\n<option item='bar'>bar1</option><option item='foobar' selected>foobar1</option></%s>", this.getComponentTag(), attribute, type, this.getComponentTag());
        AbstractMultiSelect component = (AbstractMultiSelect)this.getComponentClass().newInstance();
        component.setItems(items);
        component.select(new Object[]{"foo"});
        component.select(new Object[]{"foobar"});
        component.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)item -> item + "1");
        DesignContext context = this.readComponentAndCompare(design, component, ctxt -> this.configureContext(type, attribute, (T)component, (DesignContext)ctxt));
        Assert.assertEquals((Object)type, context.getCustomAttributes(context.getRootComponent()).get(attribute));
        context = new DesignContext();
        this.configureContext(type, attribute, component, context);
        this.testWrite(component, design, context);
    }

    @Override
    @Test
    public void valueSerialization() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        List<String> items = Arrays.asList("foo", "bar", "foobar");
        String type = "com.vaadin.SomeType";
        String attribute = "data-type";
        String design = String.format("<%s %s='%s'>\n<option item='foo' selected>foo1</option>\n<option item='bar'>bar1</option><option item='foobar' selected>foobar1</option></%s>", this.getComponentTag(), attribute, type, this.getComponentTag());
        AbstractMultiSelect component = (AbstractMultiSelect)this.getComponentClass().newInstance();
        component.setItems(items);
        component.setValue(new HashSet<String>(Arrays.asList("foo", "foobar")));
        component.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)item -> item + "1");
        DesignContext context = this.readComponentAndCompare(design, component, ctxt -> this.configureContext(type, attribute, (T)component, (DesignContext)ctxt));
        Assert.assertEquals((Object)type, context.getCustomAttributes(context.getRootComponent()).get(attribute));
        context = new DesignContext();
        this.configureContext(type, attribute, component, context);
        this.testWrite(component, design, context);
    }

    @Override
    @Test
    public void readOnlySelection() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        AbstractMultiSelect component = (AbstractMultiSelect)this.getComponentClass().newInstance();
        List<String> items = Arrays.asList("foo", "bar", "foobar");
        String design = String.format("<%s readonly>\n<option item='foo'>foo</option>\n<option item='bar'>bar</option><option item='foobar'>foobar</option>", this.getComponentTag(), this.getComponentTag());
        component.setItems(items);
        component.setReadOnly(true);
        this.testRead(design, component, true);
        this.testWrite(design, component, true);
    }

    private void configureContext(String type, String attribute, T component, DesignContext context) {
        context.setCustomAttribute(component, attribute, type);
        context.setShouldWriteDataDelegate(DeclarativeTestBaseBase.ALWAYS_WRITE_DATA);
    }
}

