/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component;

import com.vaadin.tests.VaadinClasses;
import com.vaadin.ui.Component;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class FinalMethodTest {
    @Test
    public void testThatComponentsHaveNoFinalMethods() {
        HashSet tested = new HashSet();
        int count = 0;
        for (Class<? extends Component> c : VaadinClasses.getComponents()) {
            this.ensureNoFinalMethods(c, tested);
            ++count;
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    private void ensureNoFinalMethods(Class<?> clazz, HashSet<Class<?>> tested) {
        if (tested.contains(clazz)) {
            return;
        }
        tested.add(clazz);
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        System.out.println("Checking " + clazz.getName());
        for (Method m : clazz.getDeclaredMethods()) {
            if (this.isPrivate(m) || !this.isFinal(m)) continue;
            String error = "Class " + clazz.getName() + " contains a " + (this.isPublic(m) ? "public" : "non-public") + " final method: " + m.getName();
            throw new RuntimeException(error);
        }
        this.ensureNoFinalMethods(clazz.getSuperclass(), tested);
    }

    private boolean isFinal(Method m) {
        return Modifier.isFinal(m.getModifiers());
    }

    private boolean isPrivate(Method m) {
        return Modifier.isPrivate(m.getModifiers());
    }

    private boolean isPublic(Method m) {
        return Modifier.isPublic(m.getModifiers());
    }
}

