/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server;

import com.vaadin.server.DownloadStream;
import com.vaadin.server.StreamResource;
import java.net.URISyntaxException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class StreamResourceTest {
    @Test
    public void testEqualsWithNullFields() {
        StreamResource resource1 = new StreamResource(null, null);
        StreamResource resource2 = new StreamResource(null, null);
        Assert.assertEquals((Object)resource1, (Object)resource2);
    }

    @Test
    public void testNotEqualsWithNullFields() {
        StreamResource resource1 = new StreamResource(null, null);
        StreamResource resource2 = new StreamResource((StreamResource.StreamSource)EasyMock.createMock(StreamResource.StreamSource.class), "");
        Assert.assertNotEquals((Object)resource1, (Object)resource2);
    }

    @Test
    public void testHashCodeForNullFields() {
        StreamResource resource = new StreamResource(null, null);
        resource.hashCode();
    }

    @Test
    public void cacheTime() throws URISyntaxException {
        StreamResource resource = new StreamResource((StreamResource.StreamSource)EasyMock.createMock(StreamResource.StreamSource.class), ""){

            public long getCacheTime() {
                return 5L;
            }
        };
        resource.setBufferSize(100);
        resource.setCacheTime(200L);
        DownloadStream downloadStream = resource.getStream();
        Assert.assertEquals((String)"DownloadStream buffer size must be same as resource buffer size", (long)resource.getBufferSize(), (long)downloadStream.getBufferSize());
        Assert.assertEquals((String)"DownloadStream cache time must be same as resource cache time", (long)resource.getCacheTime(), (long)downloadStream.getCacheTime());
    }
}

