/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server;

import com.vaadin.server.KeyMapper;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class KeyMapperTest {
    @Test
    public void testAdd() {
        KeyMapper<Object> mapper = this.createKeyMapper();
        Object o1 = this.createObject();
        Object o2 = this.createObject();
        Object o3 = this.createObject();
        String key1 = mapper.key(o1);
        String key2 = mapper.key(o2);
        String key3 = mapper.key(o3);
        Assert.assertSame((Object)mapper.get(key1), (Object)o1);
        Assert.assertSame((Object)mapper.get(key2), (Object)o2);
        Assert.assertSame((Object)mapper.get(key3), (Object)o3);
        Assert.assertNotSame((Object)key1, (Object)key2);
        Assert.assertNotSame((Object)key1, (Object)key3);
        Assert.assertNotSame((Object)key2, (Object)key3);
        this.assertSize(mapper, 3);
        Assert.assertEquals((Object)mapper.key(o3), (Object)key3);
        this.assertSize(mapper, 3);
        mapper.remove(o1);
        String newkey1 = mapper.key(o1);
        Assert.assertNotSame((Object)key1, (Object)newkey1);
    }

    protected Object createObject() {
        return new Object();
    }

    protected KeyMapper<Object> createKeyMapper() {
        return new KeyMapper();
    }

    @Test
    public void testRemoveAll() {
        KeyMapper<Object> mapper = this.createKeyMapper();
        Object o1 = this.createObject();
        Object o2 = this.createObject();
        Object o3 = this.createObject();
        mapper.key(o1);
        mapper.key(o2);
        mapper.key(o3);
        this.assertSize(mapper, 3);
        mapper.removeAll();
        this.assertSize(mapper, 0);
    }

    @Test
    public void testRemove() {
        KeyMapper<Object> mapper = this.createKeyMapper();
        Object o1 = this.createObject();
        Object o2 = this.createObject();
        Object o3 = this.createObject();
        mapper.key(o1);
        mapper.key(o2);
        mapper.key(o3);
        this.assertSize(mapper, 3);
        mapper.remove(o1);
        this.assertSize(mapper, 2);
        mapper.key(o1);
        this.assertSize(mapper, 3);
        mapper.remove(o1);
        this.assertSize(mapper, 2);
        mapper.remove(o2);
        mapper.remove(o3);
        this.assertSize(mapper, 0);
    }

    private void assertSize(KeyMapper<?> mapper, int i) {
        try {
            Field f1 = KeyMapper.class.getDeclaredField("objectIdKeyMap");
            Field f2 = KeyMapper.class.getDeclaredField("keyObjectMap");
            f1.setAccessible(true);
            f2.setAccessible(true);
            HashMap h1 = (HashMap)f1.get(mapper);
            HashMap h2 = (HashMap)f2.get(mapper);
            Assert.assertEquals((long)i, (long)h1.size());
            Assert.assertEquals((long)i, (long)h2.size());
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail();
        }
    }
}

