/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.design;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.declarative.Design;
import com.vaadin.ui.declarative.DesignException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class InvalidTagNamesTest {
    @Test(expected=DesignException.class)
    public void tagWithoutDash() {
        this.readDesign("<vbutton>foo</vbutton>");
    }

    @Test
    public void emptyTag() {
        Component c = this.readDesign("<>foo</>");
        Assert.assertNull((Object)c);
    }

    @Test(expected=DesignException.class)
    public void onlyPrefix() {
        this.readDesign("<vaadin->foo</vaadin->");
    }

    @Test
    public void onlyClass() {
        Component c = this.readDesign("<-v>foo</-v>");
        Assert.assertNull((Object)c);
    }

    @Test(expected=DesignException.class)
    public void unknownClass() {
        this.readDesign("<vaadin-unknownbutton>foo</vaadin-unknownbutton>");
    }

    @Test(expected=DesignException.class)
    public void unknownTag() {
        this.readDesign("<x-button></x-button>");
    }

    public void tagEndsInDash() {
        Component c = this.readDesign("<vaadin-button-></vaadin-button->");
        Assert.assertTrue((c.getClass() == Button.class ? 1 : 0) != 0);
    }

    public void tagEndsInTwoDashes() {
        Component c = this.readDesign("<vaadin-button--></vaadin-button-->");
        Assert.assertTrue((c.getClass() == Button.class ? 1 : 0) != 0);
    }

    public void tagWithTwoDashes() {
        Component c = this.readDesign("<vaadin--button></vaadin--button>");
        Assert.assertTrue((c.getClass() == Button.class ? 1 : 0) != 0);
    }

    @Test(expected=DesignException.class)
    public void specialCharacters() {
        this.readDesign("<vaadin-button-&!#></vaadin-button-&!#>");
    }

    private Component readDesign(String string) {
        return Design.read((InputStream)new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)));
    }
}

