/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.design;

import com.vaadin.tests.design.DesignReadInConstructor;
import com.vaadin.ui.Component;
import com.vaadin.ui.declarative.Design;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DesignReadInConstructorTest {
    @Test
    public void useDesignReadInConstructor() {
        DesignReadInConstructor dric = new DesignReadInConstructor();
        Assert.assertEquals((long)3L, (long)dric.getComponentCount());
    }

    @Test
    @Ignore(value="Can't currently work. There is no way to write a custom component which manually reads its design in the constructor")
    public void readAndWriteDesignReadInConstructor() throws IOException {
        DesignReadInConstructor dric = new DesignReadInConstructor();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Design.write((Component)dric, (OutputStream)baos);
        Document doc = Jsoup.parse((String)baos.toString(StandardCharsets.UTF_8.name()));
        Document d = Jsoup.parse((InputStream)this.getClass().getResourceAsStream("DesignReadInConstructor.html"), (String)StandardCharsets.UTF_8.name(), (String)"");
        this.assertJsoupTreeEquals(d.body().child(0), doc.body().child(0));
    }

    private void assertJsoupTreeEquals(Element expected, Element actual) {
        Assert.assertEquals((Object)expected.tagName(), (Object)actual.tagName());
        HashSet<String> keys = new HashSet<String>();
        for (Attribute attr : expected.attributes().asList()) {
            keys.add(attr.getKey());
        }
        for (Attribute attr : actual.attributes().asList()) {
            keys.add(attr.getKey());
        }
        for (String attributeKey : keys) {
            Assert.assertEquals((Object)expected.attr(attributeKey), (Object)actual.attr(attributeKey));
        }
        Assert.assertEquals((long)expected.children().size(), (long)actual.children().size());
        for (int i = 0; i < expected.children().size(); ++i) {
            this.assertJsoupTreeEquals(expected.child(i), actual.child(i));
        }
    }
}

