/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.data.converter;

import com.vaadin.data.Result;
import com.vaadin.data.ValueContext;
import com.vaadin.data.converter.StringToIntegerConverter;
import com.vaadin.tests.data.converter.AbstractConverterTest;
import org.junit.Assert;
import org.junit.Test;

public class StringToIntegerConverterTest
extends AbstractConverterTest {
    protected StringToIntegerConverter getConverter() {
        return new StringToIntegerConverter("Failed");
    }

    @Test
    public void testEmptyStringConversion() {
        this.assertValue(null, this.getConverter().convertToModel("", new ValueContext()));
    }

    @Test
    public void testValueOutOfRange() {
        Double[] values = new Double[]{4.294967294E9, -4.294967296E9, 1.8446744073709552E19, -1.8446744073709552E19};
        boolean accepted = false;
        for (Double value : values) {
            try {
                this.getConverter().convertToModel(String.format("%.0f", value), new ValueContext());
            }
            catch (Exception e) {
                accepted = true;
            }
        }
        Assert.assertFalse((String)"Accepted value outside range of int", (boolean)accepted);
    }

    @Test
    public void testValueConversion() {
        this.assertValue(10, this.getConverter().convertToModel("10", new ValueContext()));
    }

    @Test
    public void testErrorMessage() {
        Result result = this.getConverter().convertToModel("abc", new ValueContext());
        Assert.assertTrue((boolean)result.isError());
        Assert.assertEquals((Object)"Failed", result.getMessage().get());
    }

    @Test
    public void customEmptyValue() {
        StringToIntegerConverter converter = new StringToIntegerConverter(Integer.valueOf(0), this.getErrorMessage());
        this.assertValue(0, converter.convertToModel("", new ValueContext()));
        Assert.assertEquals((Object)"0", (Object)converter.convertToPresentation((Number)0, new ValueContext()));
    }
}

