/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.data.converter;

import com.vaadin.data.ValueContext;
import com.vaadin.data.converter.StringToBooleanConverter;
import com.vaadin.tests.data.converter.AbstractStringConverterTest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class StringToBooleanConverterTest
extends AbstractStringConverterTest {
    private StringToBooleanConverter yesNoConverter = new StringToBooleanConverter(this.getErrorMessage(), "yes", "no");
    private StringToBooleanConverter emptyTrueConverter = new StringToBooleanConverter(this.getErrorMessage(), "", "ABSENT");
    private final StringToBooleanConverter localeConverter = new StringToBooleanConverter(this.getErrorMessage()){

        public String getFalseString(Locale locale) {
            Date d = new Date(3000000000000L);
            return SimpleDateFormat.getDateInstance(1, locale).format(d.getTime() + (long)((d.getTimezoneOffset() + 120) * 60) * 1000L);
        }

        public String getTrueString(Locale locale) {
            Date d = new Date(2000000000000L);
            return SimpleDateFormat.getDateInstance(1, locale).format(d.getTime() + (long)((d.getTimezoneOffset() + 120) * 60) * 1000L);
        }
    };

    protected StringToBooleanConverter getConverter() {
        return new StringToBooleanConverter(this.getErrorMessage());
    }

    @Test
    public void testValueConversion() {
        this.assertValue(true, this.getConverter().convertToModel("true", new ValueContext()));
        this.assertValue(false, this.getConverter().convertToModel("false", new ValueContext()));
    }

    @Test
    public void testYesNoValueConversion() {
        this.assertValue(true, this.yesNoConverter.convertToModel("yes", new ValueContext()));
        this.assertValue(false, this.yesNoConverter.convertToModel("no", new ValueContext()));
        Assert.assertEquals((Object)"yes", (Object)this.yesNoConverter.convertToPresentation(Boolean.valueOf(true), new ValueContext()));
        Assert.assertEquals((Object)"no", (Object)this.yesNoConverter.convertToPresentation(Boolean.valueOf(false), new ValueContext()));
    }

    @Test
    public void testEmptyTrueValueConversion() {
        this.assertValue(true, this.emptyTrueConverter.convertToModel("", new ValueContext()));
        this.assertValue(false, this.emptyTrueConverter.convertToModel("ABSENT", new ValueContext()));
        Assert.assertEquals((Object)"", (Object)this.emptyTrueConverter.convertToPresentation(Boolean.valueOf(true), new ValueContext()));
        Assert.assertEquals((Object)"ABSENT", (Object)this.emptyTrueConverter.convertToPresentation(Boolean.valueOf(false), new ValueContext()));
    }

    @Test
    public void testLocale() {
        Assert.assertEquals((Object)"May 18, 2033", (Object)this.localeConverter.convertToPresentation(Boolean.valueOf(true), new ValueContext(Locale.US)));
        Assert.assertEquals((Object)"January 24, 2065", (Object)this.localeConverter.convertToPresentation(Boolean.valueOf(false), new ValueContext(Locale.US)));
        Assert.assertEquals((Object)"18. Mai 2033", (Object)this.localeConverter.convertToPresentation(Boolean.valueOf(true), new ValueContext(Locale.GERMANY)));
        Assert.assertEquals((Object)"24. Januar 2065", (Object)this.localeConverter.convertToPresentation(Boolean.valueOf(false), new ValueContext(Locale.GERMANY)));
    }
}

