/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.data.converter;

import com.vaadin.data.Result;
import com.vaadin.data.ValueContext;
import com.vaadin.data.converter.StringToBigDecimalConverter;
import com.vaadin.tests.data.converter.AbstractStringConverterTest;
import java.math.BigDecimal;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class StringToBigDecimalConverterTest
extends AbstractStringConverterTest {
    protected StringToBigDecimalConverter getConverter() {
        return new StringToBigDecimalConverter(this.getErrorMessage());
    }

    @Test
    public void testValueParsing() {
        Result converted = this.getConverter().convertToModel("10", new ValueContext());
        BigDecimal expected = new BigDecimal(10);
        this.assertValue(expected, converted);
    }

    @Test
    public void testValueFormatting() {
        BigDecimal bd = new BigDecimal(12.5);
        String expected = "12,5";
        String converted = this.getConverter().convertToPresentation((Number)bd, new ValueContext(Locale.GERMAN));
        Assert.assertEquals((Object)expected, (Object)converted);
    }

    @Test
    public void customEmptyValue() {
        StringToBigDecimalConverter converter = new StringToBigDecimalConverter(BigDecimal.ZERO, this.getErrorMessage());
        this.assertValue(BigDecimal.ZERO, converter.convertToModel("", new ValueContext()));
        Assert.assertEquals((Object)"0", (Object)converter.convertToPresentation((Number)BigDecimal.ZERO, new ValueContext()));
    }
}

