/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.data.converter;

import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValidationException;
import com.vaadin.data.ValueContext;
import com.vaadin.data.converter.LocalDateToDateConverter;
import com.vaadin.tests.data.converter.AbstractConverterTest;
import com.vaadin.ui.DateField;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class LocalDateToDateConverterTest
extends AbstractConverterTest {
    private static final String TIME_ZONE = "UTC";
    private static final LocalDate LOCAL_DATE = LocalDate.of(2017, 1, 1);
    private static final Date DATE = LocalDateToDateConverterTest.createDate();

    protected LocalDateToDateConverter getConverter() {
        return new LocalDateToDateConverter(ZoneId.of(TIME_ZONE));
    }

    @Test
    public void testToModel() {
        this.assertValue(DATE, this.getConverter().convertToModel(LOCAL_DATE, new ValueContext()));
    }

    @Test
    public void testToModelFromSqlDate() {
        this.assertValue(new java.sql.Date(DATE.getTime()), this.getConverter().convertToModel(LOCAL_DATE, new ValueContext()));
    }

    @Test
    public void testToPresentation() {
        Assert.assertEquals((Object)LOCAL_DATE, (Object)this.getConverter().convertToPresentation(DATE, new ValueContext()));
    }

    @Test
    public void useWithBinder() throws ValidationException {
        Binder binder = new Binder();
        DateField dateField = new DateField();
        binder.forField((HasValue)dateField).withConverter((Converter)this.getConverter()).bind(BeanWithDate::getDate, BeanWithDate::setDate);
        dateField.setValue((Temporal)LOCAL_DATE);
        BeanWithDate bean = new BeanWithDate();
        binder.writeBean((Object)bean);
        Assert.assertEquals((Object)DATE, (Object)bean.getDate());
    }

    private static Date createDate() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(TIME_ZONE));
        calendar.clear();
        calendar.set(2017, 0, 1);
        return calendar.getTime();
    }

    public static class BeanWithDate {
        private Date date;

        public void setDate(Date date) {
            this.date = date;
        }

        public Date getDate() {
            return this.date;
        }
    }
}

