/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.data.converter;

import com.vaadin.data.Converter;
import com.vaadin.data.Result;
import com.vaadin.data.ValueContext;
import com.vaadin.server.SerializableFunction;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractConverterTest {
    @Test
    public void testNullConversion() {
        this.assertValue(null, this.getConverter().convertToModel(null, new ValueContext()));
    }

    protected abstract Converter<?, ?> getConverter();

    protected <T> void assertValue(T expectedValue, Result<?> result) {
        this.assertValue(null, expectedValue, result);
    }

    protected <T> void assertValue(String assertMessage, T expectedValue, Result<?> result) {
        Assert.assertNotNull((String)"Result should never be null", result);
        Assert.assertFalse((String)"Result is not ok", (boolean)result.isError());
        Assert.assertEquals(expectedValue, (Object)result.getOrThrow((SerializableFunction & Serializable)message -> new AssertionError((Object)(assertMessage != null ? assertMessage : message))));
    }

    protected void assertError(String expectedResultMessage, Result<?> result) {
        Assert.assertNotNull((String)"Result should never be null", result);
        Assert.assertTrue((String)"Result should be an error", (boolean)result.isError());
        Assert.assertEquals((Object)expectedResultMessage, result.getMessage().get());
    }

    protected String getErrorMessage() {
        return "conversion failed";
    }
}

