/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.components.grid;

import com.vaadin.data.provider.CallbackDataProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.bov.Person;
import com.vaadin.event.selection.MultiSelectionEvent;
import com.vaadin.event.selection.MultiSelectionListener;
import com.vaadin.server.MockVaadinSession;
import com.vaadin.server.ServiceException;
import com.vaadin.shared.Registration;
import com.vaadin.tests.util.MockUI;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.components.grid.GridSelectionModel;
import com.vaadin.ui.components.grid.MultiSelectionModel;
import com.vaadin.ui.components.grid.MultiSelectionModelImpl;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import org.easymock.Capture;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class GridMultiSelectionModelTest {
    public static final Person PERSON_C = new Person("c", 3);
    public static final Person PERSON_B = new Person("b", 2);
    public static final Person PERSON_A = new Person("a", 1);
    private Grid<Person> grid;
    private MultiSelectionModelImpl<Person> selectionModel;
    private Capture<Set<Person>> currentSelectionCapture;
    private Capture<Set<Person>> oldSelectionCapture;
    private AtomicInteger events;

    @Before
    public void setUp() {
        this.grid = new Grid();
        this.selectionModel = (MultiSelectionModelImpl)this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.grid.setItems((Object[])new Person[]{PERSON_A, PERSON_B, PERSON_C});
        this.currentSelectionCapture = new Capture();
        this.oldSelectionCapture = new Capture();
        this.events = new AtomicInteger();
        this.selectionModel.addMultiSelectionListener((MultiSelectionListener & Serializable)event -> {
            this.currentSelectionCapture.setValue(new HashSet(event.getNewSelection()));
            this.oldSelectionCapture.setValue(new HashSet(event.getOldSelection()));
            this.events.incrementAndGet();
        });
    }

    @Test(expected=IllegalStateException.class)
    public void throwExcpetionWhenSelectionIsDisallowed() {
        TestMultiSelectionModel model = new TestMultiSelectionModel();
        model.updateSelection(Collections.emptySet(), Collections.emptySet(), true);
    }

    @Test(expected=IllegalStateException.class)
    public void selectionModelChanged_usingPreviousSelectionModel_throws() {
        this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.selectionModel.select((Object)PERSON_A);
    }

    @Test
    public void changingSelectionModel_firesSelectionEvent() {
        Grid customGrid = new Grid();
        customGrid.setSelectionMode(Grid.SelectionMode.MULTI);
        customGrid.setItems((Object[])new String[]{"Foo", "Bar", "Baz"});
        HashSet selectionChanges = new HashSet();
        Capture oldSelectionCapture = new Capture();
        ((MultiSelectionModelImpl)customGrid.getSelectionModel()).addMultiSelectionListener((MultiSelectionListener & Serializable)event -> {
            selectionChanges.addAll((Collection)event.getValue());
            oldSelectionCapture.setValue((Object)event.getOldSelection());
        });
        customGrid.getSelectionModel().select((Object)"Foo");
        Assert.assertEquals(this.asSet("Foo"), selectionChanges);
        selectionChanges.clear();
        customGrid.getSelectionModel().select((Object)"Bar");
        Assert.assertEquals((Object)"Foo", customGrid.getSelectionModel().getFirstSelectedItem().get());
        Assert.assertEquals(this.asSet("Foo", "Bar"), selectionChanges);
        selectionChanges.clear();
        customGrid.setSelectionMode(Grid.SelectionMode.SINGLE);
        Assert.assertFalse((boolean)customGrid.getSelectionModel().getFirstSelectedItem().isPresent());
        Assert.assertEquals(this.asSet(new Object[0]), selectionChanges);
        Assert.assertEquals(this.asSet("Foo", "Bar"), (Object)oldSelectionCapture.getValue());
    }

    @Test
    public void serverSideSelection_GridChangingSelectionModel_sendsUpdatedRowsToClient() {
        CustomSelectionModelGrid customGrid = new CustomSelectionModelGrid();
        CustomMultiSelectionModel customModel = (CustomMultiSelectionModel)customGrid.getSelectionModel();
        customGrid.setItems(new String[]{"Foo", "Bar", "Baz"});
        customGrid.getDataCommunicator().beforeClientResponse(true);
        Assert.assertFalse((String)"Item should have been updated as selected", (boolean)customModel.generatedData.get("Foo"));
        Assert.assertFalse((String)"Item should have been updated as NOT selected", (boolean)customModel.generatedData.get("Bar"));
        Assert.assertFalse((String)"Item should have been updated as NOT selected", (boolean)customModel.generatedData.get("Baz"));
        customModel.generatedData.clear();
        customGrid.getSelectionModel().select((Object)"Foo");
        customGrid.getDataCommunicator().beforeClientResponse(false);
        Assert.assertTrue((String)"Item should have been updated as selected", (boolean)customModel.generatedData.get("Foo"));
        Assert.assertFalse((String)"Item should have NOT been updated", (boolean)customModel.generatedData.containsKey("Bar"));
        Assert.assertFalse((String)"Item should have NOT been updated", (boolean)customModel.generatedData.containsKey("Baz"));
        customModel.generatedData.clear();
        customModel.updateSelection(this.asSet("Bar"), this.asSet("Foo"));
        customGrid.getDataCommunicator().beforeClientResponse(false);
        Assert.assertFalse((String)"Item should have been updated as NOT selected", (boolean)customModel.generatedData.get("Foo"));
        Assert.assertTrue((String)"Item should have been updated as selected", (boolean)customModel.generatedData.get("Bar"));
        Assert.assertFalse((String)"Item should have NOT been updated", (boolean)customModel.generatedData.containsKey("Baz"));
        customModel.generatedData.clear();
        customGrid.setSelectionMode(Grid.SelectionMode.SINGLE);
        customGrid.getDataCommunicator().beforeClientResponse(false);
        Assert.assertTrue((boolean)customModel.generatedData.isEmpty());
    }

    @Test
    public void select_gridWithStrings() {
        Grid gridWithStrings = new Grid();
        gridWithStrings.setSelectionMode(Grid.SelectionMode.MULTI);
        gridWithStrings.setItems((Object[])new String[]{"Foo", "Bar", "Baz"});
        GridSelectionModel model = gridWithStrings.getSelectionModel();
        Assert.assertFalse((boolean)model.isSelected((Object)"Foo"));
        model.select((Object)"Foo");
        Assert.assertTrue((boolean)model.isSelected((Object)"Foo"));
        Assert.assertEquals(Optional.of("Foo"), (Object)model.getFirstSelectedItem());
        model.select((Object)"Bar");
        Assert.assertTrue((boolean)model.isSelected((Object)"Foo"));
        Assert.assertTrue((boolean)model.isSelected((Object)"Bar"));
        Assert.assertEquals(this.asSet("Foo", "Bar"), (Object)model.getSelectedItems());
        model.deselect((Object)"Bar");
        Assert.assertFalse((boolean)model.isSelected((Object)"Bar"));
        Assert.assertTrue((boolean)model.getFirstSelectedItem().isPresent());
        Assert.assertEquals(this.asSet("Foo"), (Object)model.getSelectedItems());
    }

    @Test
    public void select() {
        this.selectionModel.select((Object)PERSON_B);
        Assert.assertEquals((Object)PERSON_B, this.selectionModel.getFirstSelectedItem().orElse(null));
        Assert.assertEquals(Optional.of(PERSON_B), (Object)this.selectionModel.getFirstSelectedItem());
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(this.asSet(PERSON_B), (Object)this.currentSelectionCapture.getValue());
        this.selectionModel.select((Object)PERSON_A);
        Assert.assertEquals((Object)PERSON_B, this.selectionModel.getFirstSelectedItem().orElse(null));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(this.asSet(PERSON_B, PERSON_A), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals((long)2L, (long)this.events.get());
    }

    @Test
    public void deselect() {
        this.selectionModel.select((Object)PERSON_B);
        this.selectionModel.deselect((Object)PERSON_B);
        Assert.assertFalse((boolean)this.selectionModel.getFirstSelectedItem().isPresent());
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(Collections.emptySet(), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals((long)2L, (long)this.events.get());
    }

    @Test
    public void selectItems() {
        this.selectionModel.selectItems((Object[])new Person[]{PERSON_C, PERSON_B});
        Assert.assertEquals((Object)PERSON_C, this.selectionModel.getFirstSelectedItem().orElse(null));
        Assert.assertEquals(Optional.of(PERSON_C), (Object)this.selectionModel.getFirstSelectedItem());
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(this.asSet(PERSON_C, PERSON_B), (Object)this.currentSelectionCapture.getValue());
        this.selectionModel.selectItems((Object[])new Person[]{PERSON_A, PERSON_C});
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(this.asSet(PERSON_C, PERSON_B, PERSON_A), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals((long)2L, (long)this.events.get());
    }

    @Test
    public void deselectItems() {
        this.selectionModel.selectItems((Object[])new Person[]{PERSON_C, PERSON_A, PERSON_B});
        this.selectionModel.deselectItems((Object[])new Person[]{PERSON_A});
        Assert.assertEquals((Object)PERSON_C, this.selectionModel.getFirstSelectedItem().orElse(null));
        Assert.assertEquals(Optional.of(PERSON_C), (Object)this.selectionModel.getFirstSelectedItem());
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(this.asSet(PERSON_C, PERSON_B), (Object)this.currentSelectionCapture.getValue());
        this.selectionModel.deselectItems((Object[])new Person[]{PERSON_A, PERSON_B, PERSON_C});
        Assert.assertNull(this.selectionModel.getFirstSelectedItem().orElse(null));
        Assert.assertEquals(Optional.empty(), (Object)this.selectionModel.getFirstSelectedItem());
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(Collections.emptySet(), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals((long)3L, (long)this.events.get());
    }

    @Test
    public void selectionEvent_newSelection_oldSelection() {
        this.selectionModel.selectItems((Object[])new Person[]{PERSON_C, PERSON_A, PERSON_B});
        Assert.assertEquals(this.asSet(PERSON_C, PERSON_A, PERSON_B), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(Collections.emptySet(), (Object)this.oldSelectionCapture.getValue());
        this.selectionModel.deselect((Object)PERSON_A);
        Assert.assertEquals(this.asSet(PERSON_C, PERSON_B), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(this.asSet(PERSON_C, PERSON_A, PERSON_B), (Object)this.oldSelectionCapture.getValue());
        this.selectionModel.deselectItems((Object[])new Person[]{PERSON_A, PERSON_B, PERSON_C});
        Assert.assertEquals(Collections.emptySet(), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(this.asSet(PERSON_C, PERSON_B), (Object)this.oldSelectionCapture.getValue());
        this.selectionModel.selectItems((Object[])new Person[]{PERSON_A});
        Assert.assertEquals(this.asSet(PERSON_A), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(Collections.emptySet(), (Object)this.oldSelectionCapture.getValue());
        this.selectionModel.updateSelection(new LinkedHashSet<Person>(Arrays.asList(PERSON_B, PERSON_C)), new LinkedHashSet<Person>(Arrays.asList(PERSON_A)));
        Assert.assertEquals(this.asSet(PERSON_B, PERSON_C), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(this.asSet(PERSON_A), (Object)this.oldSelectionCapture.getValue());
        this.selectionModel.deselectAll();
        Assert.assertEquals(this.asSet(new Object[0]), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(this.asSet(PERSON_B, PERSON_C), (Object)this.oldSelectionCapture.getValue());
        this.selectionModel.select((Object)PERSON_C);
        Assert.assertEquals(this.asSet(PERSON_C), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(Collections.emptySet(), (Object)this.oldSelectionCapture.getValue());
        this.selectionModel.deselect((Object)PERSON_C);
        Assert.assertEquals(Collections.emptySet(), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(this.asSet(PERSON_C), (Object)this.oldSelectionCapture.getValue());
    }

    @Test
    public void deselectAll() {
        this.selectionModel.selectItems((Object[])new Person[]{PERSON_A, PERSON_C, PERSON_B});
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(this.asSet(PERSON_A, PERSON_C, PERSON_B), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals((long)1L, (long)this.events.get());
        this.selectionModel.deselectAll();
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(Collections.emptySet(), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(this.asSet(PERSON_A, PERSON_C, PERSON_B), (Object)this.oldSelectionCapture.getValue());
        Assert.assertEquals((long)2L, (long)this.events.get());
        this.selectionModel.select((Object)PERSON_C);
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(this.asSet(PERSON_C), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(Collections.emptySet(), (Object)this.oldSelectionCapture.getValue());
        Assert.assertEquals((long)3L, (long)this.events.get());
        this.selectionModel.deselectAll();
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(Collections.emptySet(), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(this.asSet(PERSON_C), (Object)this.oldSelectionCapture.getValue());
        Assert.assertEquals((long)4L, (long)this.events.get());
        this.selectionModel.deselectAll();
        Assert.assertEquals((long)4L, (long)this.events.get());
    }

    @Test
    public void selectAll() {
        this.selectionModel.selectAll();
        Assert.assertTrue((boolean)this.selectionModel.isAllSelected());
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(this.asSet(PERSON_A, PERSON_B, PERSON_C), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals((long)1L, (long)this.events.get());
        this.selectionModel.deselectItems((Object[])new Person[]{PERSON_A, PERSON_C});
        Assert.assertFalse((boolean)this.selectionModel.isAllSelected());
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(this.asSet(PERSON_A, PERSON_B, PERSON_C), (Object)this.oldSelectionCapture.getValue());
        this.selectionModel.selectAll();
        Assert.assertTrue((boolean)this.selectionModel.isAllSelected());
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(this.asSet(PERSON_B, PERSON_A, PERSON_C), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(this.asSet(PERSON_B), (Object)this.oldSelectionCapture.getValue());
        Assert.assertEquals((long)3L, (long)this.events.get());
    }

    @Test
    public void updateSelection() {
        this.selectionModel.updateSelection(this.asSet(PERSON_A), Collections.emptySet());
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(this.asSet(PERSON_A), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals((long)1L, (long)this.events.get());
        this.selectionModel.updateSelection(this.asSet(PERSON_B), this.asSet(PERSON_A));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(this.asSet(PERSON_B), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(this.asSet(PERSON_A), (Object)this.oldSelectionCapture.getValue());
        Assert.assertEquals((long)2L, (long)this.events.get());
        this.selectionModel.updateSelection(this.asSet(PERSON_B), this.asSet(PERSON_A));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(this.asSet(PERSON_B), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(this.asSet(PERSON_A), (Object)this.oldSelectionCapture.getValue());
        Assert.assertEquals((long)2L, (long)this.events.get());
        this.selectionModel.updateSelection(this.asSet(PERSON_A, PERSON_C), this.asSet(PERSON_A));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(this.asSet(PERSON_B, PERSON_C), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(this.asSet(PERSON_B), (Object)this.oldSelectionCapture.getValue());
        Assert.assertEquals((long)3L, (long)this.events.get());
        this.selectionModel.updateSelection(this.asSet(PERSON_B, PERSON_A), this.asSet(PERSON_B));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(this.asSet(PERSON_B, PERSON_C, PERSON_A), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(this.asSet(PERSON_B, PERSON_C), (Object)this.oldSelectionCapture.getValue());
        Assert.assertEquals((long)4L, (long)this.events.get());
        this.selectionModel.updateSelection(this.asSet(new Person[0]), this.asSet(PERSON_B, PERSON_A, PERSON_C));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(Collections.emptySet(), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals(this.asSet(PERSON_B, PERSON_C, PERSON_A), (Object)this.oldSelectionCapture.getValue());
        Assert.assertEquals((long)5L, (long)this.events.get());
    }

    private <T> Set<T> asSet(T ... people) {
        return new LinkedHashSet<T>(Arrays.asList(people));
    }

    @Test
    public void selectTwice() {
        this.selectionModel.select((Object)PERSON_C);
        this.selectionModel.select((Object)PERSON_C);
        Assert.assertEquals((Object)PERSON_C, this.selectionModel.getFirstSelectedItem().orElse(null));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(Optional.of(PERSON_C), (Object)this.selectionModel.getFirstSelectedItem());
        Assert.assertEquals(this.asSet(PERSON_C), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals((long)1L, (long)this.events.get());
    }

    @Test
    public void deselectTwice() {
        this.selectionModel.select((Object)PERSON_C);
        Assert.assertEquals(this.asSet(PERSON_C), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals((long)1L, (long)this.events.get());
        this.selectionModel.deselect((Object)PERSON_C);
        Assert.assertFalse((boolean)this.selectionModel.getFirstSelectedItem().isPresent());
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(Collections.emptySet(), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals((long)2L, (long)this.events.get());
        this.selectionModel.deselect((Object)PERSON_C);
        Assert.assertFalse((boolean)this.selectionModel.getFirstSelectedItem().isPresent());
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(Collections.emptySet(), (Object)this.currentSelectionCapture.getValue());
        Assert.assertEquals((long)2L, (long)this.events.get());
    }

    @Test
    public void addValueChangeListener() {
        final String value = "foo";
        final AtomicReference selectionListener = new AtomicReference();
        final Registration registration = (Registration)Mockito.mock(Registration.class);
        MultiSelectionModelImpl<String> model = new MultiSelectionModelImpl<String>(){

            public Registration addMultiSelectionListener(MultiSelectionListener<String> listener) {
                selectionListener.set(listener);
                return registration;
            }

            public Set<String> getSelectedItems() {
                return new LinkedHashSet<String>(Arrays.asList(value));
            }
        };
        CustomSelectionModelGrid grid = new CustomSelectionModelGrid((GridSelectionModel<String>)model);
        grid.setItems(new String[]{"foo", "bar"});
        AtomicReference event = new AtomicReference();
        Registration actualRegistration = model.addMultiSelectionListener((MultiSelectionListener & Serializable)evt -> {
            Assert.assertNull(event.get());
            event.set(evt);
        });
        Assert.assertSame((Object)registration, (Object)actualRegistration);
        ((MultiSelectionListener)selectionListener.get()).selectionChange(new MultiSelectionEvent((Component)grid, model.asMultiSelect(), Collections.emptySet(), true));
        Assert.assertEquals((Object)((Object)grid), (Object)((MultiSelectionEvent)event.get()).getComponent());
        Assert.assertEquals(new LinkedHashSet<String>(Arrays.asList(value)), (Object)((MultiSelectionEvent)event.get()).getValue());
        Assert.assertTrue((boolean)((MultiSelectionEvent)event.get()).isUserOriginated());
    }

    @Test
    public void selectAllCheckboxVisible__inMemoryDataProvider() {
        MockUI ui = new MockUI();
        Grid grid = new Grid();
        MultiSelectionModel model = (MultiSelectionModel)grid.setSelectionMode(Grid.SelectionMode.MULTI);
        ui.setContent((Component)grid);
        Assert.assertFalse((boolean)model.isSelectAllCheckBoxVisible());
        Assert.assertEquals((Object)MultiSelectionModel.SelectAllCheckBoxVisibility.DEFAULT, (Object)model.getSelectAllCheckBoxVisibility());
        grid.setItems((Object[])new String[]{"Foo", "Bar", "Baz"});
        Assert.assertTrue((boolean)model.isSelectAllCheckBoxVisible());
        Assert.assertEquals((Object)MultiSelectionModel.SelectAllCheckBoxVisibility.DEFAULT, (Object)model.getSelectAllCheckBoxVisibility());
        model.setSelectAllCheckBoxVisibility(MultiSelectionModel.SelectAllCheckBoxVisibility.HIDDEN);
        Assert.assertEquals((Object)MultiSelectionModel.SelectAllCheckBoxVisibility.HIDDEN, (Object)model.getSelectAllCheckBoxVisibility());
        Assert.assertFalse((boolean)model.isSelectAllCheckBoxVisible());
        model.setSelectAllCheckBoxVisibility(MultiSelectionModel.SelectAllCheckBoxVisibility.VISIBLE);
        Assert.assertEquals((Object)MultiSelectionModel.SelectAllCheckBoxVisibility.VISIBLE, (Object)model.getSelectAllCheckBoxVisibility());
        Assert.assertTrue((boolean)model.isSelectAllCheckBoxVisible());
    }

    @Test
    public void selectAllCheckboxVisible__lazyDataProvider() {
        Grid grid = new Grid();
        MockUI ui = new MockUI();
        ui.setContent((Component)grid);
        MultiSelectionModel model = (MultiSelectionModel)grid.setSelectionMode(Grid.SelectionMode.MULTI);
        Assert.assertFalse((boolean)model.isSelectAllCheckBoxVisible());
        Assert.assertEquals((Object)MultiSelectionModel.SelectAllCheckBoxVisibility.DEFAULT, (Object)model.getSelectAllCheckBoxVisibility());
        grid.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> IntStream.range(query.getOffset(), Math.max(query.getOffset() + query.getLimit() + 1, 1000)).mapToObj(i -> "Item " + i), (CallbackDataProvider.CountCallback & Serializable)query -> 1000));
        Assert.assertFalse((boolean)model.isSelectAllCheckBoxVisible());
        Assert.assertEquals((Object)MultiSelectionModel.SelectAllCheckBoxVisibility.DEFAULT, (Object)model.getSelectAllCheckBoxVisibility());
        model.setSelectAllCheckBoxVisibility(MultiSelectionModel.SelectAllCheckBoxVisibility.VISIBLE);
        Assert.assertEquals((Object)MultiSelectionModel.SelectAllCheckBoxVisibility.VISIBLE, (Object)model.getSelectAllCheckBoxVisibility());
        Assert.assertTrue((boolean)model.isSelectAllCheckBoxVisible());
        model.setSelectAllCheckBoxVisibility(MultiSelectionModel.SelectAllCheckBoxVisibility.HIDDEN);
        Assert.assertEquals((Object)MultiSelectionModel.SelectAllCheckBoxVisibility.HIDDEN, (Object)model.getSelectAllCheckBoxVisibility());
        Assert.assertFalse((boolean)model.isSelectAllCheckBoxVisible());
        model.setSelectAllCheckBoxVisibility(MultiSelectionModel.SelectAllCheckBoxVisibility.DEFAULT);
        Assert.assertFalse((boolean)model.isSelectAllCheckBoxVisible());
        Assert.assertEquals((Object)MultiSelectionModel.SelectAllCheckBoxVisibility.DEFAULT, (Object)model.getSelectAllCheckBoxVisibility());
    }

    @Test
    public void refreshItem_doesNotSelect() throws ServiceException {
        Grid customGrid = new Grid();
        MockVaadinSession session = new MockVaadinSession();
        session.lock();
        MockUI ui = new MockUI(session);
        ui.setContent((Component)customGrid);
        MultiSelectionModel model = (MultiSelectionModel)customGrid.setSelectionMode(Grid.SelectionMode.MULTI);
        customGrid.setItems((Object[])new String[]{"Foo", "Bar", "Baz"});
        customGrid.getDataProvider().refreshItem((Object)"Foo");
        Assert.assertFalse((boolean)model.isSelected((Object)"Foo"));
    }

    private static class TestMultiSelectionModel
    extends MultiSelectionModelImpl<Object> {
        public TestMultiSelectionModel() {
            this.getState((boolean)false).selectionAllowed = false;
        }

        protected void updateSelection(Set<Object> addedItems, Set<Object> removedItems, boolean userOriginated) {
            super.updateSelection(addedItems, removedItems, userOriginated);
        }
    }

    public static class CustomSelectionModelGrid
    extends Grid<String> {
        public CustomSelectionModelGrid() {
            this((GridSelectionModel<String>)new CustomMultiSelectionModel());
        }

        public CustomSelectionModelGrid(GridSelectionModel<String> selectionModel) {
            this.setSelectionModel(selectionModel);
        }
    }

    public static class CustomMultiSelectionModel
    extends MultiSelectionModelImpl<String> {
        public final Map<String, Boolean> generatedData = new LinkedHashMap<String, Boolean>();

        public void generateData(String item, JsonObject jsonObject) {
            super.generateData((Object)item, jsonObject);
            this.generatedData.put(item, this.isSelected(item));
        }
    }
}

