/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.components.draganddropwrapper;

import com.vaadin.tests.design.DeclarativeTestBase;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.DragAndDropWrapper;
import com.vaadin.ui.declarative.DesignContext;
import org.junit.Test;

public class DragAndDropWrapperDeclarativeTest
extends DeclarativeTestBase<DragAndDropWrapper> {
    @Test
    public void testDefaultDnDWrapper() {
        Button okButton = new Button("OK");
        String input = "<vaadin-drag-and-drop-wrapper>" + new DesignContext().createElement((Component)okButton) + "</vaadin-drag-and-drop-wrapper>";
        DragAndDropWrapper wrapper = new DragAndDropWrapper((Component)okButton);
        this.testWrite(input, wrapper);
        this.testRead(input, wrapper);
    }

    @Test
    public void testNoDragImage() {
        Button okButton = new Button("OK");
        String input = "<vaadin-drag-and-drop-wrapper drag-start-mode='wrapper'>" + new DesignContext().createElement((Component)okButton) + "</vaadin-drag-and-drop-wrapper>";
        DragAndDropWrapper wrapper = new DragAndDropWrapper((Component)okButton);
        wrapper.setDragStartMode(DragAndDropWrapper.DragStartMode.WRAPPER);
        this.testWrite(input, wrapper);
        this.testRead(input, wrapper);
    }

    @Test
    public void testWithDragImage() {
        Button dragImage = new Button("Cancel");
        Button okButton = new Button("OK");
        String input = "<vaadin-drag-and-drop-wrapper drag-start-mode='component_other'>" + new DesignContext().createElement((Component)okButton) + new DesignContext().createElement((Component)dragImage).attr(":drag-image", true) + "</vaadin-drag-and-drop-wrapper>";
        DragAndDropWrapper wrapper = new DragAndDropWrapper((Component)okButton);
        wrapper.setDragStartMode(DragAndDropWrapper.DragStartMode.COMPONENT_OTHER);
        wrapper.setDragImageComponent((Component)dragImage);
        this.testWrite(input, wrapper);
        this.testRead(input, wrapper);
    }
}

