/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests;

import com.vaadin.sass.internal.ScssStylesheet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;

public class CompileTransitionPropertyTest {
    @Test
    public void testCompilation() throws Exception {
        String file = this.getClass().getResource("styles.scss").getFile();
        if (file.contains("%20")) {
            Assert.fail((String)"path contains spaces, please move the project");
        }
        ScssStylesheet ss = ScssStylesheet.get((String)file);
        ss.compile();
        String compiled = ss.printState();
        Pattern pattern = Pattern.compile("(.my-label)(\\s)+(\\{)[^\\}]*");
        Matcher matcher = pattern.matcher(compiled);
        Assert.assertTrue((String)"Could not find style rules for .my-label.", (boolean)matcher.find());
        String elementStyle = matcher.group();
        elementStyle = elementStyle.replaceFirst("(.my-label)(\\s)+(\\{)(\\s)*", "");
        Pattern p1 = Pattern.compile("transition-property(\\s*):(\\s*)transform(\\s*);");
        Pattern p2 = Pattern.compile("-moz-transition-property(\\s*):(\\s*)-moz-transform(\\s*);");
        Pattern p3 = Pattern.compile("-webkit-transition-property(\\s*):(\\s*)-webkit-transform(\\s*);");
        Assert.assertTrue((String)"The style 'transition-property: transform' is missing.", (boolean)p1.matcher(elementStyle).find());
        Assert.assertTrue((String)"The style '-moz-transition-property: -moz-transform' is missing.", (boolean)p2.matcher(elementStyle).find());
        Assert.assertTrue((String)"The style '-webkit-transition-property: -webkit-transform' is missing.", (boolean)p3.matcher(elementStyle).find());
        String modifiedStyle = p1.matcher(elementStyle).replaceFirst("");
        modifiedStyle = p2.matcher(modifiedStyle).replaceFirst("");
        modifiedStyle = p3.matcher(modifiedStyle).replaceFirst("");
        modifiedStyle = modifiedStyle.replaceAll("(\\s)", "");
        Assert.assertTrue((String)("Unexpected style rules for .my-label: " + modifiedStyle), (boolean)modifiedStyle.isEmpty());
    }
}

