/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.Permission;

public class WarURLStreamHandlerFactory
implements URLStreamHandlerFactory,
Serializable {
    private static final String WAR_PROTOCOL = "war";
    private static volatile WarURLStreamHandlerFactory instance = null;
    private final boolean registered;

    public static WarURLStreamHandlerFactory getInstance() {
        WarURLStreamHandlerFactory.getInstanceInternal(true);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static WarURLStreamHandlerFactory getInstanceInternal(boolean register) {
        if (instance != null) return instance;
        Class<WarURLStreamHandlerFactory> clazz = WarURLStreamHandlerFactory.class;
        synchronized (WarURLStreamHandlerFactory.class) {
            if (instance != null) return instance;
            instance = new WarURLStreamHandlerFactory(register);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private WarURLStreamHandlerFactory(boolean register) {
        this.registered = register;
        if (register) {
            URL.setURLStreamHandlerFactory(this);
        }
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public static boolean register() {
        return WarURLStreamHandlerFactory.getInstanceInternal(true).isRegistered();
    }

    public static boolean disable() {
        return !WarURLStreamHandlerFactory.getInstanceInternal(false).isRegistered();
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (WAR_PROTOCOL.equals(protocol)) {
            return new WarHandler();
        }
        return null;
    }

    public static class WarURLConnection
    extends URLConnection
    implements Serializable {
        private final URLConnection wrappedJarUrlConnection;
        private boolean connected;

        protected WarURLConnection(URL url) throws IOException {
            super(url);
            URL innerJarUrl = WarURLConnection.warToJar(url);
            this.wrappedJarUrlConnection = innerJarUrl.openConnection();
        }

        @Override
        public void connect() throws IOException {
            if (!this.connected) {
                this.wrappedJarUrlConnection.connect();
                this.connected = true;
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.wrappedJarUrlConnection.getInputStream();
        }

        @Override
        public Permission getPermission() throws IOException {
            return this.wrappedJarUrlConnection.getPermission();
        }

        @Override
        public long getLastModified() {
            return this.wrappedJarUrlConnection.getLastModified();
        }

        @Override
        public int getContentLength() {
            return this.wrappedJarUrlConnection.getContentLength();
        }

        @Override
        public long getContentLengthLong() {
            return this.wrappedJarUrlConnection.getContentLengthLong();
        }

        public static URL warToJar(URL warUrl) throws MalformedURLException {
            String file = warUrl.getFile();
            if (file.contains("*/")) {
                file = file.replaceFirst("\\*/", "!/");
            } else if (file.contains("^/")) {
                file = file.replaceFirst("\\^/", "!/");
            }
            return new URL("jar", warUrl.getHost(), warUrl.getPort(), file);
        }
    }

    public static class WarHandler
    extends URLStreamHandler
    implements Serializable {
        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new WarURLConnection(u);
        }

        @Override
        protected void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
            if (path.startsWith("file:") && !path.startsWith("file:/")) {
                path = "file:/" + path.substring(5);
            }
            super.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
        }
    }
}

