/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.ClientConnector;
import com.vaadin.server.MockVaadinServletService;
import com.vaadin.server.ServiceException;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinSession;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MockVaadinSession
extends VaadinSession {
    private static final ThreadLocal<MockVaadinSession> referenceKeeper = new ThreadLocal();
    private int closeCount;
    private final ReentrantLock lock = new ReentrantLock();

    public MockVaadinSession(VaadinService service) {
        super(service);
    }

    public MockVaadinSession() throws ServiceException {
        super((VaadinService)new MockVaadinServletService());
    }

    public void close() {
        super.close();
        ++this.closeCount;
    }

    public int getCloseCount() {
        return this.closeCount;
    }

    public Lock getLockInstance() {
        return this.lock;
    }

    public void lock() {
        super.lock();
        referenceKeeper.set(this);
    }

    public void unlock() {
        super.unlock();
        referenceKeeper.remove();
    }

    public String createConnectorId(ClientConnector connector) {
        return this.getNextConnectorId();
    }
}

