/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.ClientConnector;
import com.vaadin.server.ConnectorResource;
import com.vaadin.server.DownloadStream;
import com.vaadin.server.GlobalResourceHandler;
import com.vaadin.server.Resource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinSession;
import com.vaadin.tests.util.MockUI;
import com.vaadin.ui.LegacyComponent;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class GlobalResourceHandlerTest {
    @Test
    public void globalResourceHandlerShouldWorkWithEncodedFilename() throws IOException {
        this.assertEncodedFilenameIsHandled("simple.txt", "simple.txt");
        this.assertEncodedFilenameIsHandled("with spaces.txt", "with+spaces.txt");
        this.assertEncodedFilenameIsHandled("with # hash.txt", "with+%23+hash.txt");
        this.assertEncodedFilenameIsHandled("with ; semicolon.txt", "with+%3B+semicolon.txt");
        this.assertEncodedFilenameIsHandled("with , comma.txt", "with+%2C+comma.txt");
        this.assertEncodedFilenameIsHandled("with \\ backslash.txt", "with+\\+backslash.txt");
        this.assertEncodedFilenameIsHandled("with / slash.txt", "with+/+slash.txt");
    }

    private void assertEncodedFilenameIsHandled(String filename, String expectedFilename) throws IOException {
        DownloadStream stream = (DownloadStream)Mockito.mock(DownloadStream.class);
        ConnectorResource resource = (ConnectorResource)Mockito.mock(ConnectorResource.class);
        Mockito.when((Object)resource.getFilename()).thenReturn((Object)filename);
        Mockito.when((Object)resource.getStream()).thenReturn((Object)stream);
        MockUI ui = new MockUI(){

            public int getUIId() {
                return 0;
            }
        };
        ClientConnector connector = (ClientConnector)Mockito.mock(LegacyComponent.class);
        Mockito.when((Object)connector.getUI()).thenReturn((Object)ui);
        GlobalResourceHandler handler = new GlobalResourceHandler();
        handler.register((Resource)resource, connector);
        String uri = handler.getUri(connector, resource);
        Assert.assertThat((Object)uri, (Matcher)CoreMatchers.endsWith((String)("/" + expectedFilename)));
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)("APP/global/0/legacy/0/" + filename.replace(" ", "+")));
        Mockito.when((Object)session.getUIById(Matchers.anyInt())).thenReturn((Object)ui);
        Assert.assertTrue((String)"Request not handled", (boolean)handler.handleRequest(session, request, response));
        ((DownloadStream)Mockito.verify((Object)stream)).writeResponse(request, response);
    }
}

