/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.ConnectorResourceHandler;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ErrorEvent;
import com.vaadin.server.ErrorHandler;
import com.vaadin.server.LegacyCommunicationManager;
import com.vaadin.server.MockVaadinSession;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import java.io.IOException;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConnectorResourceHandlerTest {
    VaadinRequest request;
    VaadinResponse response;
    VaadinSession session;
    UI ui;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() {
        IMocksControl control = EasyMock.createNiceControl();
        this.request = (VaadinRequest)control.createMock(VaadinRequest.class);
        this.response = (VaadinResponse)control.createMock(VaadinResponse.class);
        DeploymentConfiguration dc = (DeploymentConfiguration)control.createMock(DeploymentConfiguration.class);
        VaadinService service = (VaadinService)control.createMock(VaadinService.class);
        EasyMock.expect((Object)this.request.getPathInfo()).andReturn((Object)"/APP/connector/0/1/2");
        EasyMock.expect((Object)this.request.getParameter("v-loc")).andReturn((Object)"http://localhost/");
        control.replay();
        this.session = new MockVaadinSession(service);
        this.ui = new UI(){

            protected void init(VaadinRequest request) {
            }
        };
        this.session.lock();
        try {
            this.session.setConfiguration(dc);
            this.session.setCommunicationManager(new LegacyCommunicationManager(this.session));
            this.ui.setSession(this.session);
            this.ui.doInit(this.request, 0, "");
            this.session.addUI(this.ui);
        }
        finally {
            this.session.unlock();
        }
    }

    @Test
    public void testErrorHandling() throws IOException {
        ErrorHandler errorHandler = (ErrorHandler)EasyMock.createMock(ErrorHandler.class);
        errorHandler.error((ErrorEvent)EasyMock.anyObject(ErrorEvent.class));
        EasyMock.replay((Object[])new Object[]{errorHandler});
        Button button = new Button(){

            public boolean handleConnectorRequest(VaadinRequest request, VaadinResponse response, String path) {
                throw new RuntimeException();
            }
        };
        button.setErrorHandler(errorHandler);
        this.session.lock();
        try {
            this.ui.setContent((Component)button);
        }
        finally {
            this.session.unlock();
        }
        ConnectorResourceHandler handler = new ConnectorResourceHandler();
        Assert.assertTrue((boolean)handler.handleRequest(this.session, this.request, this.response));
        EasyMock.verify((Object[])new Object[]{errorHandler});
    }
}

