/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.AbstractDeploymentConfiguration;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.shared.communication.PushMode;
import java.util.Properties;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class AbstractDeploymentConfigurationTest {
    @Test
    public void getUIClass_returnsUIParameterPropertyValue() {
        String ui = UUID.randomUUID().toString();
        DeploymentConfiguration config = this.getConfig("UI", ui);
        Assert.assertEquals((String)"Unexpected UI class configuration option value", (Object)ui, (Object)config.getUIClassName());
    }

    @Test
    public void getUIProviderClass_returnsUIProviderPropertyValue() {
        String uiProvider = UUID.randomUUID().toString();
        DeploymentConfiguration config = this.getConfig("UIProvider", uiProvider);
        Assert.assertEquals((String)"Unexpected UI providerclass configuration option value", (Object)uiProvider, (Object)config.getUIProviderClassName());
    }

    @Test
    public void getWidgetset_returnsWidgetsetProviderPropertyValue() {
        String widgetset = UUID.randomUUID().toString();
        DeploymentConfiguration config = this.getConfig("widgetset", widgetset);
        Assert.assertEquals((String)"Unexpected widgetset configuration option value", (Object)widgetset, (Object)config.getWidgetset(null));
    }

    @Test
    public void getWidgetset_noWidgetsetPropertyValue_returnsProvidedDefaultValue() {
        DeploymentConfiguration config = this.getConfig(null, null);
        String widgetset = UUID.randomUUID().toString();
        Assert.assertEquals((String)"Unexpected widgetset configuration option value", (Object)widgetset, (Object)config.getWidgetset(widgetset));
    }

    @Test
    public void getResourcesPath_returnsResourcesPathPropertyValue() {
        String resources = UUID.randomUUID().toString();
        DeploymentConfiguration config = this.getConfig("Resources", resources);
        Assert.assertEquals((String)"Unexpected resources path configuration option value", (Object)resources, (Object)config.getResourcesPath());
    }

    @Test
    public void getClassLoader_returnsClassloaderPropertyValue() {
        String classLoader = UUID.randomUUID().toString();
        DeploymentConfiguration config = this.getConfig("ClassLoader", classLoader);
        Assert.assertEquals((String)"Unexpected classLoader configuration option value", (Object)classLoader, (Object)config.getClassLoaderName());
    }

    private DeploymentConfiguration getConfig(String property, String value) {
        Properties props = new Properties();
        if (property != null) {
            props.put(property, value);
        }
        return new DeploymentConfigImpl(props);
    }

    private static class DeploymentConfigImpl
    extends AbstractDeploymentConfiguration {
        private final Properties properties;

        DeploymentConfigImpl(Properties props) {
            this.properties = props;
        }

        public boolean isProductionMode() {
            return false;
        }

        public boolean isXsrfProtectionEnabled() {
            return false;
        }

        public boolean isSyncIdCheckEnabled() {
            return false;
        }

        public int getResourceCacheTime() {
            return 0;
        }

        public int getHeartbeatInterval() {
            return 0;
        }

        public boolean isCloseIdleSessions() {
            return false;
        }

        public PushMode getPushMode() {
            return null;
        }

        public Properties getInitParameters() {
            return null;
        }

        public String getApplicationOrSystemProperty(String propertyName, String defaultValue) {
            return this.properties.getProperty(propertyName, defaultValue);
        }

        public boolean isSendUrlsAsParameters() {
            return true;
        }
    }
}

