/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data.validator;

import com.vaadin.data.ValidationResult;
import com.vaadin.data.ValueContext;
import com.vaadin.data.validator.NotEmptyValidator;
import org.junit.Assert;
import org.junit.Test;

public class NotEmptyValidatorTest {
    @Test
    public void nullValueIsDisallowed() {
        NotEmptyValidator<Object> validator = new NotEmptyValidator<Object>("foo");
        ValidationResult result = validator.apply((Object)null, new ValueContext());
        Assert.assertTrue((boolean)result.isError());
        Assert.assertEquals((Object)"foo", (Object)result.getErrorMessage());
    }

    @Test
    public void emptyValueIsDisallowed() {
        NotEmptyValidator<String> validator = new NotEmptyValidator<String>("foo");
        ValidationResult result = validator.apply("", new ValueContext());
        Assert.assertTrue((boolean)result.isError());
        Assert.assertEquals((Object)"foo", (Object)result.getErrorMessage());
    }

    @Test
    public void nonNullValueIsAllowed() {
        NotEmptyValidator<Object> validator = new NotEmptyValidator<Object>("foo");
        Object value = new Object();
        ValidationResult result = validator.apply(value, new ValueContext());
        Assert.assertFalse((boolean)result.isError());
        Assert.assertFalse((boolean)result.isError());
    }
}

