/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data.provider;

import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.GridSortOrder;
import com.vaadin.data.provider.QuerySortOrder;
import com.vaadin.data.provider.SortOrder;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.ui.Grid;
import com.vaadin.ui.renderers.AbstractRenderer;
import com.vaadin.ui.renderers.NumberRenderer;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SortOrderBuildersTest {
    @Test
    public void gridSortOrderBuilder() {
        Grid grid = new Grid();
        Grid.Column col1 = grid.addColumn((ValueProvider & Serializable)string -> string);
        Grid.Column col2 = grid.addColumn((ValueProvider & Serializable)string -> 1, (AbstractRenderer)new NumberRenderer());
        Grid.Column col3 = grid.addColumn((ValueProvider & Serializable)string -> LocalDate.of(0, 0, 0));
        this.verifySortOrders(Arrays.asList(new GridSortOrder(col1, SortDirection.ASCENDING), new GridSortOrder(col2, SortDirection.DESCENDING), new GridSortOrder(col3, SortDirection.ASCENDING)), GridSortOrder.asc((Grid.Column)col1).thenDesc(col2).thenAsc(col3).build());
        this.verifySortOrders(Arrays.asList(new GridSortOrder(col1, SortDirection.DESCENDING), new GridSortOrder(col2, SortDirection.DESCENDING), new GridSortOrder(col3, SortDirection.ASCENDING)), GridSortOrder.desc((Grid.Column)col1).thenDesc(col2).thenAsc(col3).build());
    }

    @Test
    public void querySortOrderBuilder() {
        this.verifySortOrders(Arrays.asList(new QuerySortOrder("a", SortDirection.ASCENDING), new QuerySortOrder("b", SortDirection.DESCENDING), new QuerySortOrder("c", SortDirection.ASCENDING)), QuerySortOrder.asc((String)"a").thenDesc("b").thenAsc("c").build());
        this.verifySortOrders(Arrays.asList(new QuerySortOrder("a", SortDirection.DESCENDING), new QuerySortOrder("b", SortDirection.DESCENDING), new QuerySortOrder("c", SortDirection.ASCENDING)), QuerySortOrder.desc((String)"a").thenDesc("b").thenAsc("c").build());
    }

    private <T extends SortOrder<?>> void verifySortOrders(List<T> order1, List<T> order2) {
        Assert.assertEquals((long)order1.size(), (long)order2.size());
        for (int i = 0; i < order1.size(); ++i) {
            Assert.assertEquals((Object)((SortOrder)order1.get(i)).getDirection(), (Object)((SortOrder)order2.get(i)).getDirection());
            Assert.assertEquals((Object)((SortOrder)order1.get(i)).getSorted(), (Object)((SortOrder)order1.get(i)).getSorted());
        }
    }
}

