/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data.converter;

import com.vaadin.data.Converter;
import com.vaadin.data.converter.DefaultConverterFactory;
import com.vaadin.server.ClassFinder;
import com.vaadin.util.ReflectTools;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class DefaultConverterFactoryTest {
    private final DefaultConverterFactory factory = DefaultConverterFactory.INSTANCE;

    @Test
    public void newInstance_unknownConversion_converterNotFound() {
        this.assertThatConversionIsNotSupported(Integer.class, Float.class);
        this.assertThatConversionIsNotSupported(String.class, ZonedDateTime.class);
        this.assertThatConversionIsNotSupported(String.class, Timestamp.class);
    }

    @Test
    public void newInstance_knownConversion_converterCreated() throws IOException {
        Map<Class<Converter<?, ?>>, List<Class<?>>> converters = new ConverterClassFinder().knownConverters();
        Assert.assertFalse((String)"Expecting standard converters to exist, but none found", (boolean)converters.isEmpty());
        converters.forEach((converterType, types) -> this.assertThatConversionIsSupported((Class)types.get(0), (Class)types.get(1), (Class<? extends Converter>)converterType));
    }

    @Test
    public void newInstance_knownConversionPrimitiveTypes_converterCreated() throws IOException {
        Map<Class<Converter<?, ?>>, List<Class<?>>> converters = new ConverterClassFinder().knownConverters();
        converters.replaceAll((converterType, genericTypes) -> genericTypes.stream().map(this::toPrimitiveTypeIfExist).collect(Collectors.toList()));
        Assert.assertFalse((String)"Expecting standard converters to exist, but none found", (boolean)converters.isEmpty());
        converters.forEach((converterType, types) -> this.assertThatConversionIsSupported((Class)types.get(0), (Class)types.get(1), (Class<? extends Converter>)converterType));
    }

    @Test(expected=IllegalArgumentException.class)
    public void newInstance_nullArguments_invocationFails1() {
        this.factory.newInstance(String.class, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newInstance_nullArguments_invocationFails2() {
        this.factory.newInstance(null, String.class);
    }

    private void assertThatConversionIsSupported(Class presentationType, Class modelType, Class<? extends Converter> expectedConverter) {
        Optional maybeConverter = this.factory.newInstance(presentationType, modelType);
        Assert.assertTrue((String)("Expected conversion (" + presentationType + " -> " + modelType + ") to be handled in " + DefaultConverterFactory.class.getName() + " by " + expectedConverter.getName() + ", but was not"), (boolean)maybeConverter.isPresent());
        Converter instance = (Converter)maybeConverter.get();
        Assert.assertEquals((String)("Expecting converter (" + presentationType + " -> " + modelType + ") to be of type " + expectedConverter.getName() + ", but was " + instance.getClass().getName()), expectedConverter, instance.getClass());
    }

    private <P, M> void assertThatConversionIsNotSupported(Class<P> presentationType, Class<M> modelType) {
        Assert.assertFalse((String)("Converter (" + presentationType + " -> " + modelType + ") should not be supported"), (boolean)this.factory.newInstance(presentationType, modelType).isPresent());
    }

    private Class<?> toPrimitiveTypeIfExist(Class<?> type) {
        if (!type.isPrimitive()) {
            if (type.equals(Boolean.class)) {
                type = Boolean.TYPE;
            } else if (type.equals(Integer.class)) {
                type = Integer.TYPE;
            } else if (type.equals(Float.class)) {
                type = Float.TYPE;
            } else if (type.equals(Double.class)) {
                type = Double.TYPE;
            } else if (type.equals(Byte.class)) {
                type = Byte.TYPE;
            } else if (type.equals(Character.class)) {
                type = Character.TYPE;
            } else if (type.equals(Short.class)) {
                type = Short.TYPE;
            } else if (type.equals(Long.class)) {
                type = Long.TYPE;
            }
        }
        return type;
    }

    private static class ConverterClassFinder
    extends ClassFinder {
        private ConverterClassFinder() {
        }

        @Override
        protected Stream<String> getBasePackages() {
            return Stream.of(Converter.class.getPackage().getName());
        }

        Map<Class<? extends Converter<?, ?>>, List<Class<?>>> knownConverters() throws IOException {
            List<String> rawClasspathEntries = ConverterClassFinder.getRawClasspathEntries();
            ArrayList<String> classes = new ArrayList<String>();
            for (String location : rawClasspathEntries) {
                if (this.isTestClassPath(location)) continue;
                classes.addAll(this.findServerClasses(location, Collections.emptyList()));
            }
            HashMap result = new HashMap();
            for (String className : classes) {
                try {
                    List types;
                    Class<?> clazz = Class.forName(className);
                    if (!Converter.class.isAssignableFrom(clazz) || !(types = ReflectTools.getGenericInterfaceTypes(clazz, Converter.class)).stream().allMatch(Objects::nonNull) || !Modifier.isPublic(clazz.getModifiers()) || Modifier.isAbstract(clazz.getModifiers()) || clazz.isSynthetic() || clazz.isInterface() || clazz.isAnonymousClass() || clazz.isMemberClass() || clazz.isLocalClass()) continue;
                    result.put(clazz, types);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            return result;
        }
    }
}

