/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.data.Binder;
import com.vaadin.data.BinderTestBase;
import com.vaadin.data.HasValue;
import com.vaadin.tests.data.bean.Person;
import com.vaadin.tests.data.bean.Sex;
import com.vaadin.ui.Grid;
import com.vaadin.ui.SingleSelect;
import com.vaadin.ui.components.grid.GridSelectionModel;
import com.vaadin.ui.components.grid.SingleSelectionModelImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridAsSingleSelectInBinderTest
extends BinderTestBase<Binder<Person>, Person> {
    private Grid<Sex> grid;
    private SingleSelect<Sex> select;

    @Before
    public void setup() {
        this.binder = new Binder();
        this.item = new Person();
        this.grid = new Grid();
        this.grid.setItems((Object[])Sex.values());
        this.select = this.grid.asSingleSelect();
    }

    @Test(expected=IllegalStateException.class)
    public void boundGridInBinder_selectionModelChanged_throws() {
        this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.select.setValue((Object)Sex.MALE);
    }

    @Test
    public void personBound_bindSelectByShortcut_selectionUpdated() {
        ((Person)this.item).setSex(Sex.FEMALE);
        this.binder.setBean((Object)((Person)this.item));
        this.binder.bind(this.select, Person::getSex, Person::setSex);
        Assert.assertSame((Object)((Object)Sex.FEMALE), (Object)this.select.getValue());
    }

    @Test
    public void personBound_bindSelect_selectionUpdated() {
        ((Person)this.item).setSex(Sex.MALE);
        this.binder.setBean((Object)((Person)this.item));
        this.binder.forField(this.select).bind(Person::getSex, Person::setSex);
        Assert.assertSame((Object)((Object)Sex.MALE), (Object)this.select.getValue());
    }

    @Test
    public void selectBound_bindPersonWithNullSex_selectedItemNotPresent() {
        this.bindSex();
        Assert.assertFalse((this.select.getValue() != null ? 1 : 0) != 0);
    }

    @Test
    public void selectBound_bindPerson_selectionUpdated() {
        ((Person)this.item).setSex(Sex.FEMALE);
        this.bindSex();
        Assert.assertSame((Object)((Object)Sex.FEMALE), (Object)this.select.getValue());
    }

    @Test
    public void bound_setSelection_beanValueUpdated() {
        this.bindSex();
        this.select.setValue((Object)Sex.MALE);
        Assert.assertSame((Object)((Object)Sex.MALE), (Object)((Object)((Person)this.item).getSex()));
    }

    @Test
    public void bound_deselect_beanValueUpdatedToNull() {
        ((Person)this.item).setSex(Sex.MALE);
        this.bindSex();
        this.select.setValue(null);
        Assert.assertNull((Object)((Object)((Person)this.item).getSex()));
    }

    @Test
    public void unbound_changeSelection_beanValueNotUpdated() {
        ((Person)this.item).setSex(Sex.UNKNOWN);
        this.bindSex();
        this.binder.removeBean();
        this.select.setValue((Object)Sex.FEMALE);
        Assert.assertSame((Object)((Object)Sex.UNKNOWN), (Object)((Object)((Person)this.item).getSex()));
    }

    @Test
    public void addValueChangeListener_selectionUpdated_eventTriggeredForSelect() {
        GridWithCustomSingleSelectionModel grid = new GridWithCustomSingleSelectionModel();
        CustomSingleSelectModel model = new CustomSingleSelectModel();
        grid.setSelectionModel((GridSelectionModel<Sex>)model);
        grid.setItems((Object[])Sex.values());
        this.select = grid.asSingleSelect();
        ArrayList selected = new ArrayList();
        ArrayList oldSelected = new ArrayList();
        ArrayList userOriginated = new ArrayList();
        this.select.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            selected.add((Sex)((Object)((Object)event.getValue())));
            oldSelected.add((Sex)((Object)((Object)event.getOldValue())));
            userOriginated.add(event.isUserOriginated());
            Assert.assertSame((Object)((Object)grid), (Object)event.getComponent());
            Assert.assertSame((Object)this.select.getValue(), (Object)event.getValue());
        });
        grid.getSelectionModel().select((Object)Sex.UNKNOWN);
        model.setSelectedFromClient(Sex.MALE);
        grid.getSelectionModel().select((Object)Sex.MALE);
        grid.getSelectionModel().deselect((Object)Sex.UNKNOWN);
        model.setSelectedFromClient(null);
        grid.getSelectionModel().select((Object)Sex.FEMALE);
        Assert.assertEquals(Arrays.asList(Sex.UNKNOWN, Sex.MALE, null, Sex.FEMALE), selected);
        Assert.assertEquals(Arrays.asList(null, Sex.UNKNOWN, Sex.MALE, null), oldSelected);
        Assert.assertEquals(Arrays.asList(false, true, true, false), userOriginated);
    }

    protected void bindSex() {
        this.binder.forField(this.select).bind(Person::getSex, Person::setSex);
        this.binder.setBean((Object)((Person)this.item));
    }

    private class CustomSingleSelectModel
    extends SingleSelectionModelImpl<Sex> {
        private CustomSingleSelectModel() {
        }

        public void setSelectedFromClient(Sex item) {
            this.setSelectedFromClient(this.getGrid().getDataCommunicator().getKeyMapper().key((Object)item));
        }
    }

    private class GridWithCustomSingleSelectionModel
    extends Grid<Sex> {
        private GridWithCustomSingleSelectionModel() {
        }

        public void setSelectionModel(GridSelectionModel<Sex> model) {
            super.setSelectionModel(model);
        }
    }
}

