/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.data.Binder;
import com.vaadin.data.BinderTestBase;
import com.vaadin.data.BinderValidationStatusHandler;
import com.vaadin.data.BindingValidationStatus;
import com.vaadin.data.BindingValidationStatusHandler;
import com.vaadin.data.Converter;
import com.vaadin.data.ErrorMessageProvider;
import com.vaadin.data.HasValue;
import com.vaadin.data.Result;
import com.vaadin.data.StatusChangeListener;
import com.vaadin.data.ValidationException;
import com.vaadin.data.ValidationResult;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.converter.StringToBigDecimalConverter;
import com.vaadin.data.converter.StringToDoubleConverter;
import com.vaadin.data.converter.StringToIntegerConverter;
import com.vaadin.data.validator.IntegerRangeValidator;
import com.vaadin.data.validator.NotEmptyValidator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.SerializableBiPredicate;
import com.vaadin.server.SerializableFunction;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.server.Setter;
import com.vaadin.shared.ui.ErrorLevel;
import com.vaadin.tests.data.bean.Person;
import com.vaadin.tests.data.bean.Sex;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.TextField;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BinderTest
extends BinderTestBase<Binder<Person>, Person> {
    private int count;
    @Rule
    public transient ExpectedException exceptionRule = ExpectedException.none();

    @Before
    public void setUp() {
        this.binder = new Binder();
        this.item = new Person();
        ((Person)this.item).setFirstName("Johannes");
        ((Person)this.item).setAge(32);
    }

    @Test
    public void bindNullBean_noBeanPresent() {
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNotNull((Object)this.binder.getBean());
        this.binder.setBean(null);
        Assert.assertNull((Object)this.binder.getBean());
    }

    @Test
    public void bindNullBean_FieldsAreCleared() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((String)"No name field value", (Object)"Johannes", (Object)this.nameField.getValue());
        Assert.assertEquals((String)"No age field value", (Object)"32", (Object)this.ageField.getValue());
        this.binder.setBean(null);
        Assert.assertEquals((String)"Name field not empty", (Object)"", (Object)this.nameField.getValue());
        Assert.assertEquals((String)"Age field not empty", (Object)"", (Object)this.ageField.getValue());
    }

    @Test
    public void removeInvalidBinding_validateDoesNotThrow() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        Binder.Binding ageBinding = this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.withValidator((SerializablePredicate & Serializable)bean -> true, "");
        this.binder.setBean((Object)((Person)this.item));
        this.ageField.setValue("foo");
        this.binder.removeBinding(ageBinding);
        this.binder.validate();
    }

    @Test
    public void clearForReadBean_boundFieldsAreCleared() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertEquals((String)"No name field value", (Object)"Johannes", (Object)this.nameField.getValue());
        Assert.assertEquals((String)"No age field value", (Object)"32", (Object)this.ageField.getValue());
        this.binder.readBean(null);
        Assert.assertEquals((String)"Name field not empty", (Object)"", (Object)this.nameField.getValue());
        Assert.assertEquals((String)"Age field not empty", (Object)"", (Object)this.ageField.getValue());
    }

    @Test
    public void bindingHasChanges_trueWhenFieldValueChanges() {
        Binder.Binding binding = this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertEquals((String)"No name field value", (Object)"Johannes", (Object)this.nameField.getValue());
        Assert.assertFalse((String)"Field marked as changed after reading bean", (boolean)this.binder.hasChanges(binding));
        this.ageField.setValue("99");
        Assert.assertFalse((String)"Age field caused name field change", (boolean)this.binder.hasChanges(binding));
        this.nameField.setValue("James");
        Assert.assertTrue((String)"Binder did not have value changes", (boolean)this.binder.hasChanges(binding));
        this.binder.readBean(null);
        Assert.assertFalse((String)"Binder has changes after clearing all fields", (boolean)this.binder.hasChanges(binding));
    }

    @Test
    public void bindingInstanceHasChanges_trueWhenFieldValueChanges() {
        Binder.Binding binding = this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertEquals((String)"No name field value", (Object)"Johannes", (Object)this.nameField.getValue());
        Assert.assertFalse((String)"Field marked as changed after reading bean", (boolean)binding.hasChanges());
        this.ageField.setValue("99");
        Assert.assertFalse((String)"Age field caused name field change", (boolean)binding.hasChanges());
        this.nameField.setValue("James");
        Assert.assertTrue((String)"Binder did not have value changes", (boolean)binding.hasChanges());
        this.binder.readBean(null);
        Assert.assertFalse((String)"Binder has changes after clearing all fields", (boolean)binding.hasChanges());
    }

    @Test
    public void bindingInstanceHasChanges_throwsWhenBinderNotAttached() {
        Binder.Binding binding = this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertFalse((String)"Field marked as changed after reading bean", (boolean)binding.hasChanges());
        this.nameField.setValue("James");
        Assert.assertTrue((String)"Binder did not have value changes", (boolean)binding.hasChanges());
        binding.unbind();
        Assert.assertThrows((String)"Expect unbound binding to throw exception", IllegalStateException.class, () -> binding.hasChanges());
    }

    @Test
    public void clearReadOnlyField_shouldClearField() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.nameField.setReadOnly(true);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((String)"No name field value", (Object)"Johannes", (Object)this.nameField.getValue());
        this.binder.setBean(null);
        Assert.assertEquals((String)"ReadOnly field not empty", (Object)"", (Object)this.nameField.getValue());
    }

    @Test
    public void clearBean_setsHasChangesToFalse() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.nameField.setReadOnly(true);
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertEquals((String)"No name field value", (Object)"Johannes", (Object)this.nameField.getValue());
        this.nameField.setValue("James");
        Assert.assertTrue((String)"Binder did not have value changes", (boolean)this.binder.hasChanges());
        this.binder.readBean(null);
        Assert.assertFalse((String)"Binder has changes after clearing all fields", (boolean)this.binder.hasChanges());
    }

    @Test
    public void clearReadOnlyBinder_shouldClearFields() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setReadOnly(true);
        this.binder.setBean((Object)((Person)this.item));
        this.binder.setBean(null);
        Assert.assertEquals((String)"ReadOnly name field not empty", (Object)"", (Object)this.nameField.getValue());
        Assert.assertEquals((String)"ReadOnly age field not empty", (Object)"", (Object)this.ageField.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void bindNullField_throws() {
        this.binder.forField(null);
    }

    @Test(expected=NullPointerException.class)
    public void bindNullGetter_throws() {
        this.binder.bind((HasValue)this.nameField, null, Person::setFirstName);
    }

    @Test
    public void fieldBound_bindItem_fieldValueUpdated() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((Object)"Johannes", (Object)this.nameField.getValue());
    }

    @Test
    public void fieldBoundWithShortcut_bindBean_fieldValueUpdated() {
        this.bindName();
        Assert.assertEquals((Object)"Johannes", (Object)this.nameField.getValue());
    }

    @Test
    public void beanBound_updateFieldValue_beanValueUpdated() {
        this.binder.setBean((Object)((Person)this.item));
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        Assert.assertEquals((Object)"Johannes", (Object)this.nameField.getValue());
        this.nameField.setValue("Artur");
        Assert.assertEquals((Object)"Artur", (Object)((Person)this.item).getFirstName());
    }

    @Test
    public void bound_getBean_returnsBoundBean() {
        Assert.assertNull((Object)this.binder.getBean());
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertSame((Object)this.item, (Object)this.binder.getBean());
    }

    @Test
    public void unbound_getBean_returnsNothing() {
        this.binder.setBean((Object)((Person)this.item));
        this.binder.removeBean();
        Assert.assertNull((Object)this.binder.getBean());
    }

    @Test
    public void bound_changeFieldValue_beanValueUpdated() {
        this.bindName();
        this.nameField.setValue("Henri");
        Assert.assertEquals((Object)"Henri", (Object)((Person)this.item).getFirstName());
    }

    @Test
    public void unbound_changeFieldValue_beanValueNotUpdated() {
        this.bindName();
        this.nameField.setValue("Henri");
        this.binder.removeBean();
        this.nameField.setValue("Aleksi");
        Assert.assertEquals((Object)"Henri", (Object)((Person)this.item).getFirstName());
    }

    @Test
    public void bindNullSetter_valueChangesIgnored() {
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, null);
        this.binder.setBean((Object)((Person)this.item));
        this.nameField.setValue("Artur");
        Assert.assertEquals((Object)((Person)this.item).getFirstName(), (Object)"Johannes");
    }

    @Test
    public void bound_bindToAnotherBean_stopsUpdatingOriginal() {
        this.bindName();
        this.nameField.setValue("Leif");
        Person p2 = new Person();
        p2.setFirstName("Marlon");
        this.binder.setBean((Object)p2);
        Assert.assertEquals((Object)"Marlon", (Object)this.nameField.getValue());
        Assert.assertEquals((Object)"Leif", (Object)((Person)this.item).getFirstName());
        Assert.assertSame((Object)p2, (Object)this.binder.getBean());
        this.nameField.setValue("Ilia");
        Assert.assertEquals((Object)"Ilia", (Object)p2.getFirstName());
        Assert.assertEquals((Object)"Leif", (Object)((Person)this.item).getFirstName());
    }

    @Test
    public void save_unbound_noChanges() throws ValidationException {
        Binder binder = new Binder();
        Person person = new Person();
        int age = 10;
        person.setAge(age);
        binder.writeBean((Object)person);
        Assert.assertEquals((long)age, (long)person.getAge());
    }

    @Test
    public void save_bound_beanIsUpdated() throws ValidationException {
        Binder binder = new Binder();
        binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        Person person = new Person();
        String fieldValue = "bar";
        this.nameField.setValue(fieldValue);
        person.setFirstName("foo");
        binder.writeBean((Object)person);
        Assert.assertEquals((Object)fieldValue, (Object)person.getFirstName());
    }

    @Test
    public void write_binding_bound_propertyIsUpdated() throws ValidationException {
        Binder binder = new Binder();
        Binder.Binding binding = binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        Person person = new Person();
        String nameValue = "bar";
        this.nameField.setValue(nameValue);
        String ageValue = "10";
        this.ageField.setValue(ageValue);
        person.setFirstName("foo");
        person.setAge(20);
        binder.writeBean((Object)person, Collections.singletonList(binding));
        Assert.assertEquals((long)1L, (long)person.getAgeSetterCallCount());
        Assert.assertEquals((Object)nameValue, (Object)person.getFirstName());
        Assert.assertNotEquals((long)Integer.valueOf(ageValue).intValue(), (long)person.getAge());
    }

    @Test
    public void write_changedBindings_bound_propertyIsUpdated() throws ValidationException {
        Binder binder = new Binder();
        binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        Person person = new Person();
        Person updatedPerson = new Person();
        String nameValue = "bar";
        this.nameField.setValue(nameValue);
        person.setFirstName("foo");
        person.setAge(20);
        Assert.assertEquals((long)1L, (long)binder.getChangedBindings().size());
        binder.writeBean((Object)updatedPerson, (Collection)binder.getChangedBindings());
        Assert.assertEquals((long)0L, (long)updatedPerson.getAgeSetterCallCount());
        Assert.assertEquals((Object)nameValue, (Object)updatedPerson.getFirstName());
        Assert.assertEquals((long)0L, (long)updatedPerson.getAge());
    }

    @Test
    public void update_bound_propertyIsUpdated() throws ValidationException {
        Binder binder = new Binder();
        binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        Person person = new Person();
        Person updatedPerson = new Person();
        String nameValue = "bar";
        this.nameField.setValue(nameValue);
        person.setFirstName("foo");
        person.setAge(20);
        Assert.assertEquals((long)1L, (long)binder.getChangedBindings().size());
        binder.writeChangedBindingsToBean((Object)updatedPerson);
        Assert.assertEquals((long)0L, (long)updatedPerson.getAgeSetterCallCount());
        Assert.assertEquals((Object)nameValue, (Object)updatedPerson.getFirstName());
        Assert.assertEquals((long)0L, (long)updatedPerson.getAge());
    }

    @Test
    public void update_to_initial_value_removes_binding_from_changedBindings_with_set_predicates() throws ValidationException {
        Person person = new Person();
        String initialName = "Foo";
        person.setFirstName(initialName);
        person.setAge(20);
        Binder binder = new Binder();
        Binder.Binding nameBinding = binder.forField((HasValue)this.nameField).withEqualityPredicate((SerializableBiPredicate & Serializable)(oldVal, newVal) -> Objects.equals(oldVal, newVal)).bind(Person::getFirstName, Person::setFirstName);
        Binder.Binding ageBinding = binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).withEqualityPredicate((SerializableBiPredicate & Serializable)(oldVal, newVal) -> Objects.equals(oldVal, newVal)).bind(Person::getAge, Person::setAge);
        binder.readBean((Object)person);
        this.nameField.setValue("Bar");
        Assert.assertEquals((long)1L, (long)binder.getChangedBindings().size());
        Assert.assertTrue((boolean)binder.getChangedBindings().contains(nameBinding));
        this.ageField.setValue("21");
        Assert.assertEquals((long)2L, (long)binder.getChangedBindings().size());
        this.nameField.setValue(initialName);
        Assert.assertEquals((long)1L, (long)binder.getChangedBindings().size());
        Assert.assertTrue((boolean)binder.getChangedBindings().contains(ageBinding));
        this.ageField.setValue("20");
        Assert.assertTrue((boolean)binder.getChangedBindings().isEmpty());
    }

    @Test
    public void update_to_initial_value_removes_binding_from_changedBindings_with_default_predicates() throws ValidationException {
        Person person = new Person();
        String initialName = "Foo";
        person.setFirstName(initialName);
        person.setAge(20);
        Binder binder = new Binder();
        binder.setChangeDetectionEnabled(true);
        Binder.Binding nameBinding = binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        Binder.Binding ageBinding = binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        binder.readBean((Object)person);
        this.nameField.setValue("Bar");
        Assert.assertEquals((long)1L, (long)binder.getChangedBindings().size());
        Assert.assertTrue((boolean)binder.getChangedBindings().contains(nameBinding));
        this.ageField.setValue("21");
        Assert.assertEquals((long)2L, (long)binder.getChangedBindings().size());
        this.nameField.setValue(initialName);
        Assert.assertEquals((long)1L, (long)binder.getChangedBindings().size());
        Assert.assertTrue((boolean)binder.getChangedBindings().contains(ageBinding));
        this.ageField.setValue("20");
        Assert.assertTrue((boolean)binder.getChangedBindings().isEmpty());
    }

    @Test
    public void update_to_initial_value_does_not_remove_binding_from_changedBindings_by_default() throws ValidationException {
        Person person = new Person();
        String initialName = "Foo";
        person.setFirstName(initialName);
        person.setAge(20);
        Binder binder = new Binder();
        Binder.Binding nameBinding = binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        Binder.Binding ageBinding = binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        binder.readBean((Object)person);
        this.nameField.setValue("Bar");
        Assert.assertEquals((long)1L, (long)binder.getChangedBindings().size());
        Assert.assertTrue((boolean)binder.getChangedBindings().contains(nameBinding));
        this.ageField.setValue("21");
        Assert.assertEquals((long)2L, (long)binder.getChangedBindings().size());
        Assert.assertTrue((boolean)binder.getChangedBindings().contains(ageBinding));
        this.nameField.setValue(initialName);
        Assert.assertEquals((long)2L, (long)binder.getChangedBindings().size());
        this.ageField.setValue("20");
        Assert.assertEquals((long)2L, (long)binder.getChangedBindings().size());
    }

    @Test
    public void save_bound_beanAsDraft() {
        Binder binder = new Binder();
        binder.forField((HasValue)this.nameField).withValidator((Validator & Serializable)(value, context) -> {
            if (value.equals("Mike")) {
                return ValidationResult.ok();
            }
            return ValidationResult.error((String)"value must be Mike");
        }).bind(Person::getFirstName, Person::setFirstName);
        binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        Person person = new Person();
        String fieldValue = "John";
        this.nameField.setValue(fieldValue);
        int age = 10;
        this.ageField.setValue("10");
        person.setFirstName("Mark");
        binder.writeBeanAsDraft((Object)person);
        Assert.assertNotEquals((Object)fieldValue, (Object)person.getFirstName());
        Assert.assertEquals((long)age, (long)person.getAge());
        binder.writeBeanAsDraft((Object)person, true);
        Assert.assertEquals((Object)fieldValue, (Object)person.getFirstName());
    }

    @Test
    public void save_bound_bean_disable_validation_binding() throws ValidationException {
        Binder binder = new Binder();
        Binder.Binding nameBinding = binder.forField((HasValue)this.nameField).withValidator((Validator & Serializable)(value, context) -> {
            if (value.equals("Mike")) {
                return ValidationResult.ok();
            }
            return ValidationResult.error((String)"value must be Mike");
        }).bind(Person::getFirstName, Person::setFirstName);
        binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        Person person = new Person();
        String fieldValue = "John";
        this.nameField.setValue(fieldValue);
        int age = 10;
        this.ageField.setValue("10");
        person.setFirstName("Mark");
        nameBinding.setValidatorsDisabled(true);
        binder.writeBean((Object)person);
        Assert.assertEquals((Object)fieldValue, (Object)person.getFirstName());
        Assert.assertEquals((long)age, (long)person.getAge());
    }

    @Test
    public void save_bound_bean_disable_validation_binder() throws ValidationException {
        Binder binder = new Binder();
        binder.forField((HasValue)this.nameField).withValidator((Validator & Serializable)(value, context) -> {
            if (value.equals("Mike")) {
                return ValidationResult.ok();
            }
            return ValidationResult.error((String)"value must be Mike");
        }).bind(Person::getFirstName, Person::setFirstName);
        binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        Person person = new Person();
        String fieldValue = "John";
        this.nameField.setValue(fieldValue);
        int age = 10;
        this.ageField.setValue("10");
        person.setFirstName("Mark");
        binder.setValidatorsDisabled(true);
        binder.writeBean((Object)person);
        Assert.assertEquals((Object)fieldValue, (Object)person.getFirstName());
        Assert.assertEquals((long)age, (long)person.getAge());
    }

    @Test
    public void load_bound_fieldValueIsUpdated() {
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        Person person = new Person();
        String name = "bar";
        person.setFirstName(name);
        this.binder.readBean((Object)person);
        Assert.assertEquals((Object)name, (Object)this.nameField.getValue());
    }

    @Test
    public void load_unbound_noChanges() {
        this.nameField.setValue("");
        Person person = new Person();
        String name = "bar";
        person.setFirstName(name);
        this.binder.readBean((Object)person);
        Assert.assertEquals((Object)"", (Object)this.nameField.getValue());
    }

    protected void bindName() {
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)((Person)this.item));
    }

    @Test
    public void binding_with_null_representation() {
        String nullRepresentation = "Some arbitrary text";
        String realName = "John";
        Person namelessPerson = new Person(null, "Doe", "", 25, Sex.UNKNOWN, null);
        this.binder.forField((HasValue)this.nameField).withNullRepresentation((Object)nullRepresentation).bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)namelessPerson);
        Assert.assertEquals((String)"Null value from bean was not converted to explicit null representation", (Object)nullRepresentation, (Object)this.nameField.getValue());
        this.nameField.setValue(realName);
        Assert.assertEquals((String)"Bean was not correctly updated from a change in the field", (Object)realName, (Object)namelessPerson.getFirstName());
        this.nameField.setValue(nullRepresentation);
        Assert.assertEquals((String)"Two-way null representation did not change value back to null", null, (Object)namelessPerson.getFirstName());
    }

    @Test
    public void binding_with_default_null_representation() {
        TextField nullTextField = new TextField(){

            public String getEmptyValue() {
                return "null";
            }
        };
        Person namelessPerson = new Person(null, "Doe", "", 25, Sex.UNKNOWN, null);
        this.binder.bind((HasValue)nullTextField, Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)namelessPerson);
        Assert.assertTrue((boolean)nullTextField.isEmpty());
        Assert.assertEquals((Object)"null", (Object)namelessPerson.getFirstName());
        nullTextField.setValue("");
        Assert.assertFalse((boolean)nullTextField.isEmpty());
        Assert.assertEquals((String)"First name of person was not properly updated", (Object)"", (Object)namelessPerson.getFirstName());
        nullTextField.setValue("null");
        Assert.assertTrue((boolean)nullTextField.isEmpty());
        Assert.assertEquals((String)"Default one-way null representation failed.", (Object)"null", (Object)namelessPerson.getFirstName());
    }

    @Test
    public void binding_with_null_representation_value_not_null() {
        String nullRepresentation = "Some arbitrary text";
        this.binder.forField((HasValue)this.nameField).withNullRepresentation((Object)nullRepresentation).bind(Person::getFirstName, Person::setFirstName);
        Assert.assertFalse((String)"First name in item should not be null", (boolean)Objects.isNull(((Person)this.item).getFirstName()));
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((String)"Field value was not set correctly", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
    }

    @Test
    public void withConverter_disablesDefaulNullRepresentation() {
        Integer customNullConverter = 0;
        this.binder.forField((HasValue)this.ageField).withNullRepresentation((Object)"foo").withConverter((Converter)new StringToIntegerConverter("")).withConverter((SerializableFunction & Serializable)age -> age, (SerializableFunction & Serializable)age -> age == null ? customNullConverter : age).bind(Person::getSalary, Person::setSalary);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((Object)customNullConverter.toString(), (Object)this.ageField.getValue());
        Integer salary = 11;
        this.ageField.setValue(salary.toString());
        Assert.assertEquals((long)11L, (long)salary.intValue());
    }

    @Test
    public void withConverter_writeBackValue() {
        TextField rentField = new TextField();
        rentField.setValue("");
        this.binder.forField((HasValue)rentField).withConverter((Converter)new EuroConverter("")).withNullRepresentation((Object)BigDecimal.valueOf(0.0)).bind(Person::getRent, Person::setRent);
        this.binder.setBean((Object)((Person)this.item));
        rentField.setValue("10");
        Assert.assertEquals((Object)"\u20ac 10.00", (Object)rentField.getValue());
    }

    @Test
    public void withConverter_writeBackValueDisabled() {
        TextField rentField = new TextField();
        rentField.setValue("");
        Binder.Binding binding = this.binder.forField((HasValue)rentField).withConverter((Converter)new EuroConverter("")).withNullRepresentation((Object)BigDecimal.valueOf(0.0)).bind(Person::getRent, Person::setRent);
        this.binder.setBean((Object)((Person)this.item));
        binding.setConvertBackToPresentation(false);
        rentField.setValue("10");
        Assert.assertNotEquals((Object)"\u20ac 10.00", (Object)rentField.getValue());
    }

    @Test
    public void beanBinder_nullRepresentationIsNotDisabled() {
        Binder binder = new Binder(Person.class);
        binder.forField((HasValue)this.nameField).bind("firstName");
        Person person = new Person();
        binder.setBean((Object)person);
        Assert.assertEquals((Object)"", (Object)this.nameField.getValue());
    }

    @Test
    public void beanBinder_withConverter_nullRepresentationIsNotDisabled() {
        String customNullPointerRepresentation = "foo";
        Binder binder = new Binder(Person.class);
        binder.forField((HasValue)this.nameField).withConverter((SerializableFunction & Serializable)value -> value, (SerializableFunction & Serializable)value -> value == null ? customNullPointerRepresentation : value).bind("firstName");
        Person person = new Person();
        binder.setBean((Object)person);
        Assert.assertEquals((Object)customNullPointerRepresentation, (Object)this.nameField.getValue());
    }

    @Test
    public void withValidator_doesNotDisablesDefaulNullRepresentation() {
        String nullRepresentation = "foo";
        this.binder.forField((HasValue)this.nameField).withNullRepresentation((Object)nullRepresentation).withValidator(new NotEmptyValidator("")).bind(Person::getFirstName, Person::setFirstName);
        ((Person)this.item).setFirstName(null);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((Object)nullRepresentation, (Object)this.nameField.getValue());
        String newValue = "bar";
        this.nameField.setValue(newValue);
        Assert.assertEquals((Object)newValue, (Object)((Person)this.item).getFirstName());
    }

    @Test
    public void setRequired_withErrorMessage_fieldGetsRequiredIndicatorAndValidator() {
        TextField textField = new TextField();
        Assert.assertFalse((boolean)textField.isRequiredIndicatorVisible());
        Binder.BindingBuilder bindingBuilder = this.binder.forField((HasValue)textField);
        Assert.assertFalse((boolean)textField.isRequiredIndicatorVisible());
        bindingBuilder.asRequired("foobar");
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
        Binder.Binding binding = bindingBuilder.bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNull((Object)textField.getErrorMessage());
        textField.setValue(textField.getEmptyValue());
        ErrorMessage errorMessage = textField.getErrorMessage();
        Assert.assertNotNull((Object)errorMessage);
        Assert.assertEquals((Object)"foobar", (Object)errorMessage.getFormattedHtmlMessage());
        textField.setValue("value");
        Assert.assertNull((Object)textField.getErrorMessage());
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
        binding.setAsRequiredEnabled(false);
        Assert.assertFalse((boolean)textField.isRequiredIndicatorVisible());
    }

    @Test
    public void readNullBeanRemovesError() {
        TextField textField = new TextField();
        this.binder.forField((HasValue)textField).asRequired("foobar").bind(Person::getFirstName, Person::setFirstName);
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
        Assert.assertNull((Object)textField.getErrorMessage());
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertNull((Object)textField.getErrorMessage());
        textField.setValue(textField.getEmptyValue());
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
        Assert.assertNotNull((Object)textField.getErrorMessage());
        this.binder.readBean(null);
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
        Assert.assertNull((Object)textField.getErrorMessage());
    }

    @Test
    public void setRequired_withErrorMessageProvider_fieldGetsRequiredIndicatorAndValidator() {
        TextField textField = new TextField();
        textField.setLocale(Locale.CANADA);
        Assert.assertFalse((boolean)textField.isRequiredIndicatorVisible());
        Binder.BindingBuilder binding = this.binder.forField((HasValue)textField);
        Assert.assertFalse((boolean)textField.isRequiredIndicatorVisible());
        AtomicInteger invokes = new AtomicInteger();
        binding.asRequired((ErrorMessageProvider & Serializable)context -> {
            invokes.incrementAndGet();
            Assert.assertSame((Object)Locale.CANADA, context.getLocale().get());
            return "foobar";
        });
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
        binding.bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNull((Object)textField.getErrorMessage());
        Assert.assertEquals((long)0L, (long)invokes.get());
        textField.setValue(textField.getEmptyValue());
        ErrorMessage errorMessage = textField.getErrorMessage();
        Assert.assertNotNull((Object)errorMessage);
        Assert.assertEquals((Object)"foobar", (Object)errorMessage.getFormattedHtmlMessage());
        Assert.assertEquals((long)1L, (long)invokes.get());
        textField.setValue("value");
        Assert.assertNull((Object)textField.getErrorMessage());
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
    }

    @Test
    public void setRequired_withCustomValidator_fieldGetsRequiredIndicatorAndValidator() {
        TextField textField = new TextField();
        textField.setLocale(Locale.CANADA);
        Assert.assertFalse((boolean)textField.isRequiredIndicatorVisible());
        Binder.BindingBuilder binding = this.binder.forField((HasValue)textField);
        Assert.assertFalse((boolean)textField.isRequiredIndicatorVisible());
        AtomicInteger invokes = new AtomicInteger();
        Validator & Serializable customRequiredValidator = (Validator & Serializable)(value, context) -> {
            invokes.incrementAndGet();
            if (StringUtils.isBlank((CharSequence)value)) {
                return ValidationResult.error((String)"Input is required.");
            }
            return ValidationResult.ok();
        };
        binding.asRequired((Validator)customRequiredValidator);
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
        binding.bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNull((Object)textField.getErrorMessage());
        Assert.assertEquals((long)1L, (long)invokes.get());
        textField.setValue("        ");
        ErrorMessage errorMessage = textField.getErrorMessage();
        Assert.assertNotNull((Object)errorMessage);
        Assert.assertEquals((Object)"Input&#32;is&#32;required&#46;", (Object)errorMessage.getFormattedHtmlMessage());
        Assert.assertEquals((long)2L, (long)invokes.get());
        textField.setValue("value");
        Assert.assertNull((Object)textField.getErrorMessage());
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
    }

    @Test
    public void setRequired_withCustomValidator_modelConverterBeforeValidator() {
        TextField textField = new TextField();
        textField.setLocale(Locale.CANADA);
        Assert.assertFalse((boolean)textField.isRequiredIndicatorVisible());
        Converter<String, String> stringBasicPreProcessingConverter = new Converter<String, String>(){

            public Result<String> convertToModel(String value, ValueContext context) {
                if (StringUtils.isBlank((CharSequence)value)) {
                    return Result.ok(null);
                }
                return Result.ok((Object)StringUtils.trim((String)value));
            }

            public String convertToPresentation(String value, ValueContext context) {
                if (value == null) {
                    return "";
                }
                return value;
            }
        };
        AtomicInteger invokes = new AtomicInteger();
        Validator & Serializable customRequiredValidator = (Validator & Serializable)(value, context) -> {
            invokes.incrementAndGet();
            if (value == null) {
                return ValidationResult.error((String)"Input required.");
            }
            return ValidationResult.ok();
        };
        this.binder.forField((HasValue)textField).withConverter((Converter)stringBasicPreProcessingConverter).asRequired((Validator)customRequiredValidator).bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNull((Object)textField.getErrorMessage());
        Assert.assertEquals((long)1L, (long)invokes.get());
        textField.setValue("        ");
        ErrorMessage errorMessage = textField.getErrorMessage();
        Assert.assertNotNull((Object)errorMessage);
        Assert.assertEquals((Object)"Input&#32;required&#46;", (Object)errorMessage.getFormattedHtmlMessage());
        Assert.assertEquals((long)2L, (long)invokes.get());
        textField.setValue("value");
        Assert.assertNull((Object)textField.getErrorMessage());
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
    }

    @Test
    public void setRequiredAsEnabled_shouldNotTriggerValidation() {
        AtomicBoolean hasErrors = new AtomicBoolean();
        Binder.Binding nameBinding = this.binder.forField((HasValue)this.nameField).asRequired("Name is required").bind(Person::getFirstName, Person::setFirstName);
        this.binder.addStatusChangeListener((StatusChangeListener & Serializable)status -> hasErrors.getAndSet(status.hasValidationErrors()));
        this.binder.setBean((Object)new Person());
        Assert.assertFalse((String)"binder should not have errors", (boolean)hasErrors.get());
        Assert.assertNull((String)"Name field should not be in error.", (Object)this.nameField.getErrorMessage());
        nameBinding.setAsRequiredEnabled(false);
        Assert.assertFalse((String)"binder should not have errors", (boolean)hasErrors.get());
        Assert.assertNull((String)"Name field should not be in error.", (Object)this.nameField.getErrorMessage());
        nameBinding.setAsRequiredEnabled(true);
        Assert.assertFalse((String)"binder should not have errors", (boolean)hasErrors.get());
        Assert.assertNull((String)"Name field should not be in error.", (Object)this.nameField.getErrorMessage());
    }

    @Test
    public void validationStatusHandler_onlyRunForChangedField() {
        TextField firstNameField = new TextField();
        TextField lastNameField = new TextField();
        AtomicInteger invokes = new AtomicInteger();
        this.binder.forField((HasValue)firstNameField).withValidator(new NotEmptyValidator("")).withValidationStatusHandler((BindingValidationStatusHandler & Serializable)validationStatus -> invokes.addAndGet(1)).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)lastNameField).withValidator(new NotEmptyValidator("")).bind(Person::getLastName, Person::setLastName);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((long)2L, (long)invokes.get());
        lastNameField.setValue("");
        Assert.assertEquals((long)2L, (long)invokes.get());
        firstNameField.setValue("");
        Assert.assertEquals((long)3L, (long)invokes.get());
        this.binder.removeBean();
        Person person = new Person();
        person.setFirstName("a");
        person.setLastName("a");
        this.binder.readBean((Object)person);
        Assert.assertEquals((long)5L, (long)invokes.get());
        lastNameField.setValue("");
        Assert.assertEquals((long)5L, (long)invokes.get());
        firstNameField.setValue("");
        Assert.assertEquals((long)6L, (long)invokes.get());
    }

    @Test
    public void refreshFields_beforeSettingBean_clearsTheFields() {
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        Assert.assertEquals((String)"Name field should be empty", (Object)"", (Object)this.nameField.getValue());
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertEquals((String)"Name should be read from the item", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
        ((Person)this.item).setFirstName("bar");
        this.binder.refreshFields();
        Assert.assertEquals((String)"Name field should be cleared since bean is not set", (Object)"", (Object)this.nameField.getValue());
    }

    @Test
    public void refreshFields_afterSettingBean_readValuesfromBeanAgain() {
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        Assert.assertEquals((String)"Name field should be empty", (Object)"", (Object)this.nameField.getValue());
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertEquals((String)"Name should be read from the item", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
        this.binder.setBean((Object)((Person)this.item));
        ((Person)this.item).setFirstName("bar");
        this.binder.refreshFields();
        Assert.assertEquals((String)"Name should be read again from the item", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
    }

    @Test(expected=IllegalStateException.class)
    public void noArgsConstructor_stringBind_throws() {
        this.binder.bind((HasValue)new TextField(), "firstName");
    }

    @Test
    public void setReadOnly_unboundBinder() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField);
        this.binder.setReadOnly(true);
        Assert.assertTrue((boolean)this.nameField.isReadOnly());
        Assert.assertFalse((boolean)this.ageField.isReadOnly());
        this.binder.setReadOnly(false);
        Assert.assertFalse((boolean)this.nameField.isReadOnly());
        Assert.assertFalse((boolean)this.ageField.isReadOnly());
    }

    @Test
    public void setReadOnly_boundBinder() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setBean((Object)new Person());
        this.binder.setReadOnly(true);
        Assert.assertTrue((boolean)this.nameField.isReadOnly());
        Assert.assertTrue((boolean)this.ageField.isReadOnly());
        this.binder.setReadOnly(false);
        Assert.assertFalse((boolean)this.nameField.isReadOnly());
        Assert.assertFalse((boolean)this.ageField.isReadOnly());
    }

    @Test
    public void setReadOnly_binderLoadedByReadBean() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.readBean((Object)new Person());
        this.binder.setReadOnly(true);
        Assert.assertTrue((boolean)this.nameField.isReadOnly());
        Assert.assertTrue((boolean)this.ageField.isReadOnly());
        this.binder.setReadOnly(false);
        Assert.assertFalse((boolean)this.nameField.isReadOnly());
        Assert.assertFalse((boolean)this.ageField.isReadOnly());
    }

    @Test
    public void setReadonlyShouldIgnoreBindingsWithNullSetter() {
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, null);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setReadOnly(true);
        Assert.assertTrue((String)"Name field should be ignored but should be readonly", (boolean)this.nameField.isReadOnly());
        Assert.assertTrue((String)"Age field should be readonly", (boolean)this.ageField.isReadOnly());
        this.binder.setReadOnly(false);
        Assert.assertTrue((String)"Name field should be ignored and should remain readonly", (boolean)this.nameField.isReadOnly());
        Assert.assertFalse((String)"Age field should not be readonly", (boolean)this.ageField.isReadOnly());
        this.nameField.setReadOnly(false);
        this.binder.setReadOnly(false);
        Assert.assertFalse((String)"Name field should be ignored and remain not readonly", (boolean)this.nameField.isReadOnly());
        Assert.assertFalse((String)"Age field should not be readonly", (boolean)this.ageField.isReadOnly());
        this.binder.setReadOnly(true);
        Assert.assertFalse((String)"Name field should be ignored and remain not readonly", (boolean)this.nameField.isReadOnly());
        Assert.assertTrue((String)"Age field should be readonly", (boolean)this.ageField.isReadOnly());
    }

    @Test
    public void isValidTest_bound_binder() {
        this.binder.forField((HasValue)this.nameField).withValidator(Validator.from((SerializablePredicate & Serializable)name -> !name.equals("fail field validation"), (String)"")).bind(Person::getFirstName, Person::setFirstName);
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)person -> !person.getFirstName().equals("fail bean validation"), (String)""));
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertTrue((boolean)this.binder.isValid());
        this.nameField.setValue("fail field validation");
        Assert.assertFalse((boolean)this.binder.isValid());
        this.nameField.setValue("");
        Assert.assertTrue((boolean)this.binder.isValid());
        this.nameField.setValue("fail bean validation");
        Assert.assertFalse((boolean)this.binder.isValid());
    }

    @Test
    public void isValidTest_unbound_binder() {
        this.binder.forField((HasValue)this.nameField).withValidator(Validator.from((SerializablePredicate & Serializable)name -> !name.equals("fail field validation"), (String)"")).bind(Person::getFirstName, Person::setFirstName);
        Assert.assertTrue((boolean)this.binder.isValid());
        this.nameField.setValue("fail field validation");
        Assert.assertFalse((boolean)this.binder.isValid());
        this.nameField.setValue("");
        Assert.assertTrue((boolean)this.binder.isValid());
    }

    @Test(expected=IllegalStateException.class)
    public void isValidTest_unbound_binder_throws_with_bean_level_validation() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)person -> !person.getFirstName().equals("fail bean validation"), (String)""));
        this.binder.isValid();
    }

    @Test
    public void getFields_returnsFields() {
        Assert.assertEquals((long)0L, (long)this.binder.getFields().count());
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.assertStreamEquals(Stream.of(this.nameField), this.binder.getFields());
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.assertStreamEquals(Stream.of(this.nameField, this.ageField), this.binder.getFields());
    }

    private void assertStreamEquals(Stream<?> s1, Stream<?> s2) {
        Assert.assertArrayEquals((Object[])s1.toArray(), (Object[])s2.toArray());
    }

    @Test
    public void multiple_calls_to_same_binding_builder() {
        String stringLength = "String length failure";
        String conversion = "Conversion failed";
        String ageLimit = "Age not in valid range";
        this.binder = new Binder(Person.class);
        Binder.BindingBuilder builder = this.binder.forField((HasValue)this.ageField);
        builder.withValidator((Validator)new StringLengthValidator(stringLength, Integer.valueOf(0), Integer.valueOf(3)));
        builder.withConverter((Converter)new StringToIntegerConverter(conversion));
        builder.withValidator((Validator)new IntegerRangeValidator(ageLimit, Integer.valueOf(3), Integer.valueOf(150)));
        Binder.Binding bind = builder.bind("age");
        this.binder.setBean((Object)((Person)this.item));
        this.ageField.setValue("123123");
        BindingValidationStatus validation = bind.validate();
        Assert.assertTrue((boolean)validation.isError());
        Assert.assertEquals((Object)stringLength, validation.getMessage().get());
        this.ageField.setValue("age");
        validation = bind.validate();
        Assert.assertTrue((boolean)validation.isError());
        Assert.assertEquals((Object)conversion, validation.getMessage().get());
        this.ageField.setValue("256");
        validation = bind.validate();
        Assert.assertTrue((boolean)validation.isError());
        Assert.assertEquals((Object)ageLimit, validation.getMessage().get());
        this.ageField.setValue("30");
        validation = bind.validate();
        Assert.assertFalse((boolean)validation.isError());
        Assert.assertEquals((long)30L, (long)((Person)this.item).getAge());
    }

    @Test
    public void remove_field_binding() {
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("Can't convert")).bind(Person::getAge, Person::setAge);
        Assert.assertTrue((String)"Field not initially empty", (boolean)this.ageField.isEmpty());
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((String)"Binding did not work", (Object)String.valueOf(((Person)this.item).getAge()), (Object)this.ageField.getValue());
        this.binder.setBean(null);
        Assert.assertTrue((String)"Field not cleared", (boolean)this.ageField.isEmpty());
        this.binder.removeBinding((HasValue)this.ageField);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNotEquals((String)"Binding was not removed", (Object)String.valueOf(((Person)this.item).getAge()), (Object)this.ageField.getValue());
    }

    @Test
    public void remove_propertyname_binding() {
        Binder binder = new Binder(Person.class);
        binder.bind((HasValue)this.nameField, "firstName");
        Assert.assertTrue((String)"Field not initially empty", (boolean)this.nameField.isEmpty());
        binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((String)"Binding did not work", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
        binder.setBean(null);
        Assert.assertTrue((String)"Field not cleared", (boolean)this.nameField.isEmpty());
        binder.removeBinding("firstName");
        binder.setBean((Object)((Person)this.item));
        Assert.assertNotEquals((String)"Binding was not removed", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
    }

    @Test
    public void remove_binding() {
        Binder.Binding binding = this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("Can't convert")).bind(Person::getAge, Person::setAge);
        Assert.assertTrue((String)"Field not initially empty", (boolean)this.ageField.isEmpty());
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((String)"Binding did not work", (Object)String.valueOf(((Person)this.item).getAge()), (Object)this.ageField.getValue());
        this.binder.setBean(null);
        Assert.assertTrue((String)"Field not cleared", (boolean)this.ageField.isEmpty());
        this.binder.removeBinding(binding);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNotEquals((String)"Binding was not removed", (Object)String.valueOf(((Person)this.item).getAge()), (Object)this.ageField.getValue());
    }

    @Test
    public void remove_binding_fromFieldValueChangeListener() {
        this.nameField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.getValue() == "REMOVE") {
                this.binder.removeBinding((HasValue)this.nameField);
            }
        });
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)((Person)this.item));
        this.nameField.setValue("REMOVE");
        Assert.assertNotEquals((Object)"REMOVE", (Object)((Person)this.item).getFirstName());
    }

    @Test
    public void beanvalidation_two_fields_not_equal() {
        TextField lastNameField = new TextField();
        this.setBeanValidationFirstNameNotEqualsLastName(this.nameField, lastNameField);
        ((Person)this.item).setLastName("Valid");
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertFalse((String)"Should not have changes initially", (boolean)this.binder.hasChanges());
        Assert.assertTrue((String)"Should be ok initially", (boolean)this.binder.validate().isOk());
        Assert.assertNotEquals((String)"First name and last name are not same initially", (Object)((Person)this.item).getFirstName(), (Object)((Person)this.item).getLastName());
        this.nameField.setValue("Invalid");
        Assert.assertFalse((String)"First name change not handled", (boolean)this.binder.hasChanges());
        Assert.assertTrue((String)"Changing first name to something else than last name should be ok", (boolean)this.binder.validate().isOk());
        lastNameField.setValue("Invalid");
        Assert.assertTrue((String)"Last name should not be saved yet", (boolean)this.binder.hasChanges());
        Assert.assertFalse((String)"Binder validation should fail with pending illegal value", (boolean)this.binder.validate().isOk());
        Assert.assertNotEquals((String)"Illegal last name should not be stored to bean", (Object)((Person)this.item).getFirstName(), (Object)((Person)this.item).getLastName());
        this.nameField.setValue("Valid");
        Assert.assertFalse((String)"With new first name both changes should be saved", (boolean)this.binder.hasChanges());
        Assert.assertTrue((String)"Everything should be ok for 'Valid Invalid'", (boolean)this.binder.validate().isOk());
        Assert.assertNotEquals((String)"First name and last name should never match.", (Object)((Person)this.item).getFirstName(), (Object)((Person)this.item).getLastName());
    }

    @Test
    public void beanvalidation_initially_broken_bean() {
        TextField lastNameField = new TextField();
        this.setBeanValidationFirstNameNotEqualsLastName(this.nameField, lastNameField);
        ((Person)this.item).setLastName(((Person)this.item).getFirstName());
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertFalse((boolean)this.binder.isValid());
        Assert.assertFalse((boolean)this.binder.validate().isOk());
    }

    @Test(expected=IllegalStateException.class)
    public void beanvalidation_isValid_throws_with_readBean() {
        TextField lastNameField = new TextField();
        this.setBeanValidationFirstNameNotEqualsLastName(this.nameField, lastNameField);
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertTrue((boolean)this.binder.isValid());
    }

    @Test(expected=IllegalStateException.class)
    public void beanvalidation_validate_throws_with_readBean() {
        TextField lastNameField = new TextField();
        this.setBeanValidationFirstNameNotEqualsLastName(this.nameField, lastNameField);
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertTrue((boolean)this.binder.validate().isOk());
    }

    protected void setBeanValidationFirstNameNotEqualsLastName(TextField firstNameField, TextField lastNameField) {
        this.binder.bind((HasValue)firstNameField, Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)lastNameField).withValidator((SerializablePredicate & Serializable)t -> !"foo".equals(t), "Last name cannot be 'foo'").bind(Person::getLastName, Person::setLastName);
        this.binder.withValidator((SerializablePredicate & Serializable)p -> !p.getFirstName().equals(p.getLastName()), "First name and last name can't be the same");
    }

    @Test
    public void execute_binding_status_handler_from_binder_status_handler() {
        MyBindingHandler bindingHandler = new MyBindingHandler();
        this.binder.forField((HasValue)this.nameField).withValidator((SerializablePredicate & Serializable)t -> !t.isEmpty(), "No empty values.").withValidationStatusHandler((BindingValidationStatusHandler)bindingHandler).bind(Person::getFirstName, Person::setFirstName);
        String ageError = "CONVERSIONERROR";
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter(ageError)).bind(Person::getAge, Person::setAge);
        this.binder.setValidationStatusHandler((BinderValidationStatusHandler & Serializable)status -> status.notifyBindingValidationStatusHandlers());
        String initialName = ((Person)this.item).getFirstName();
        int initialAge = ((Person)this.item).getAge();
        this.binder.setBean((Object)((Person)this.item));
        bindingHandler.expectingError = true;
        this.nameField.setValue("");
        this.ageField.setValue("foo");
        Assert.assertTrue((String)"Component error does not contain error message", (boolean)this.ageField.getComponentError().getFormattedHtmlMessage().contains(ageError));
        this.ageField.setValue(String.valueOf(initialAge));
        Assert.assertNull((String)"There should be no component error", (Object)this.ageField.getComponentError());
        bindingHandler.expectingError = false;
        this.nameField.setValue(initialName);
        Assert.assertEquals((String)"Unexpected callCount to binding validation status handler", (long)6L, (long)bindingHandler.callCount);
    }

    @Test
    public void removed_binding_not_updates_value() {
        Binder.Binding binding = this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("Can't convert")).bind(Person::getAge, Person::setAge);
        this.binder.setBean((Object)((Person)this.item));
        String modifiedAge = String.valueOf(((Person)this.item).getAge() + 10);
        String ageBeforeUnbind = String.valueOf(((Person)this.item).getAge());
        this.binder.removeBinding(binding);
        this.ageField.setValue(modifiedAge);
        Assert.assertEquals((String)"Binding still affects bean even after unbind", (Object)ageBeforeUnbind, (Object)String.valueOf(((Person)this.item).getAge()));
    }

    @Test
    public void replace_binding_previousBindingUnbound() {
        ArrayList bindingCalls = new ArrayList();
        Binder.Binding binding1 = this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("Can't convert")).bind((ValueProvider & Serializable)p -> {
            bindingCalls.add("READ FIRST");
            return p.getAge();
        }, (Setter & Serializable)(p, v) -> {
            bindingCalls.add("WRITE FIRST");
            p.setAge((int)v);
        });
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals(Collections.singletonList("READ FIRST"), bindingCalls);
        bindingCalls.clear();
        this.ageField.setValue("99");
        Assert.assertEquals(Arrays.asList("READ FIRST", "WRITE FIRST"), bindingCalls);
        Binder.Binding binding2 = this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("Can't convert")).bind((ValueProvider & Serializable)p -> {
            bindingCalls.add("READ SECOND");
            return p.getAge();
        }, (Setter & Serializable)(p, v) -> {
            bindingCalls.add("WRITE SECOND");
            p.setAge((int)v);
        });
        bindingCalls.clear();
        this.ageField.setValue("33");
        Assert.assertEquals(Arrays.asList("READ SECOND", "WRITE SECOND"), bindingCalls);
        Assert.assertNull((String)"Expecting first binding to be unbound", (Object)binding1.getField());
        Assert.assertSame((String)"Expecting second binding to be bound", (Object)this.ageField, (Object)binding2.getField());
    }

    @Test
    public void info_validator_not_considered_error() {
        String infoMessage = "Young";
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("Can't convert")).withValidator((SerializablePredicate & Serializable)i -> i > 5, infoMessage, ErrorLevel.INFO).bind(Person::getAge, Person::setAge);
        this.binder.setBean((Object)((Person)this.item));
        this.ageField.setValue("3");
        Assert.assertEquals((Object)infoMessage, (Object)this.ageField.getComponentError().getFormattedHtmlMessage());
        Assert.assertEquals((Object)ErrorLevel.INFO, (Object)this.ageField.getComponentError().getErrorLevel());
        Assert.assertEquals((long)3L, (long)((Person)this.item).getAge());
    }

    @Test
    public void two_asRequired_fields_without_initial_values_setBean() {
        this.binder.forField((HasValue)this.nameField).asRequired("Empty name").bind((ValueProvider & Serializable)p -> "", (Setter & Serializable)(p, s) -> {});
        this.binder.forField((HasValue)this.ageField).asRequired("Empty age").bind((ValueProvider & Serializable)p -> "", (Setter & Serializable)(p, s) -> {});
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNull((String)"Initially there should be no errors", (Object)this.nameField.getComponentError());
        Assert.assertNull((String)"Initially there should be no errors", (Object)this.ageField.getComponentError());
        this.nameField.setValue("Foo");
        Assert.assertNull((String)"Name with a value should not be an error", (Object)this.nameField.getComponentError());
        Assert.assertNull((String)"Age field should not be in error, since it was not modified.", (Object)this.ageField.getErrorMessage());
        this.nameField.setValue("");
        Assert.assertNotNull((String)"Empty name should now be in error.", (Object)this.nameField.getErrorMessage());
        Assert.assertNull((String)"Age field should still not be in error, since it was not modified.", (Object)this.ageField.getErrorMessage());
    }

    @Test
    public void two_asRequired_fields_without_initial_values_readBean() {
        this.binder.forField((HasValue)this.nameField).asRequired("Empty name").bind((ValueProvider & Serializable)p -> "", (Setter & Serializable)(p, s) -> {});
        this.binder.forField((HasValue)this.ageField).asRequired("Empty age").bind((ValueProvider & Serializable)p -> "", (Setter & Serializable)(p, s) -> {});
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertNull((String)"Initially there should be no errors", (Object)this.nameField.getComponentError());
        Assert.assertNull((String)"Initially there should be no errors", (Object)this.ageField.getComponentError());
        this.nameField.setValue("Foo");
        Assert.assertNull((String)"Name with a value should not be an error", (Object)this.nameField.getComponentError());
        Assert.assertNull((String)"Age field should not be in error, since it was not modified.", (Object)this.ageField.getErrorMessage());
        this.nameField.setValue("");
        Assert.assertNotNull((String)"Empty name should now be in error.", (Object)this.nameField.getErrorMessage());
        Assert.assertNull((String)"Age field should still not be in error, since it was not modified.", (Object)this.ageField.getErrorMessage());
    }

    @Test
    public void validated_and_asRequired_fields_without_initial_values_setBean() {
        this.binder.forField((HasValue)this.nameField).asRequired("Empty name").bind(Person::getFirstName, Person::setFirstName);
        TextField lastNameField = new TextField();
        this.binder.forField((HasValue)lastNameField).withValidator((Validator & Serializable)(v, c) -> StringUtils.isEmpty((CharSequence)v) ? ValidationResult.error((String)"Empty last name") : ValidationResult.ok()).bind(Person::getLastName, Person::setLastName);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNull((String)"Initially there should be no errors", (Object)this.nameField.getErrorMessage());
        Assert.assertNull((String)"Initially there should be no errors", (Object)lastNameField.getErrorMessage());
        this.nameField.setValue("Foo");
        Assert.assertNull((String)"Name with a value should not be an error", (Object)this.nameField.getErrorMessage());
        Assert.assertNull((String)"Last name field should not be in error, since it was not modified.", (Object)lastNameField.getErrorMessage());
        this.nameField.setValue("");
        Assert.assertNotNull((String)"Empty name should now be in error.", (Object)this.nameField.getErrorMessage());
        Assert.assertNull((String)"Last name field should not be in error, since it was not modified.", (Object)lastNameField.getErrorMessage());
        this.nameField.setValue("Bar");
        lastNameField.setValue("Bar");
        lastNameField.setValue("");
        Assert.assertNull((String)"Name with a value should not be an error", (Object)this.nameField.getErrorMessage());
        Assert.assertNotNull((String)"Empty last name field should now be in error.", (Object)lastNameField.getErrorMessage());
    }

    @Test
    public void validated_and_asRequired_fields_without_initial_values_readBean() {
        this.binder.forField((HasValue)this.nameField).asRequired("Empty name").bind(Person::getFirstName, Person::setFirstName);
        TextField lastNameField = new TextField();
        this.binder.forField((HasValue)lastNameField).withValidator((Validator & Serializable)(v, c) -> StringUtils.isEmpty((CharSequence)v) ? ValidationResult.error((String)"Empty last name") : ValidationResult.ok()).bind(Person::getLastName, Person::setLastName);
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertNull((String)"Initially there should be no errors", (Object)this.nameField.getErrorMessage());
        Assert.assertNull((String)"Initially there should be no errors", (Object)lastNameField.getErrorMessage());
        this.nameField.setValue("Foo");
        Assert.assertNull((String)"Name with a value should not be an error", (Object)this.nameField.getErrorMessage());
        Assert.assertNull((String)"Last name field should not be in error, since it was not modified.", (Object)lastNameField.getErrorMessage());
        this.nameField.setValue("");
        Assert.assertNotNull((String)"Empty name should now be in error.", (Object)this.nameField.getErrorMessage());
        Assert.assertNull((String)"Last name field should not be in error, since it was not modified.", (Object)lastNameField.getErrorMessage());
        this.nameField.setValue("Bar");
        lastNameField.setValue("Bar");
        lastNameField.setValue("");
        Assert.assertNull((String)"Name with a value should not be an error", (Object)this.nameField.getErrorMessage());
        Assert.assertNotNull((String)"Empty last name field should now be in error.", (Object)lastNameField.getErrorMessage());
    }

    @Test
    public void refreshValueFromBean() {
        Binder.Binding binding = this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertEquals((String)"Name should be read from the item", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
        this.nameField.setValue("foo");
        Assert.assertNotEquals((String)"Name should be different from the item", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
        binding.read((Object)((Person)this.item));
        Assert.assertEquals((String)"Name should be read again from the item", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void remove_binding_from_different_binder() {
        Binder anotherBinder = new Binder();
        Binder.Binding binding = anotherBinder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        this.binder.removeBinding(binding);
    }

    @Test(expected=IllegalStateException.class)
    public void bindWithNullSetterSetReadWrite() {
        Binder.Binding binding = this.binder.bind((HasValue)this.nameField, Person::getFirstName, null);
        binding.setReadOnly(false);
    }

    @Test
    public void bindWithNullSetterShouldMarkFieldAsReadonly() {
        Binder.Binding nameBinding = this.binder.bind((HasValue)this.nameField, Person::getFirstName, null);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        Assert.assertTrue((String)"Name field should be readonly", (boolean)this.nameField.isReadOnly());
        Assert.assertFalse((String)"Age field should not be readonly", (boolean)this.ageField.isReadOnly());
        Assert.assertTrue((String)"Binding should be marked readonly", (boolean)nameBinding.isReadOnly());
    }

    @Test
    public void setReadOnly_binding() {
        Binder.Binding binding = this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        Assert.assertFalse((String)"Binding should not be readonly", (boolean)binding.isReadOnly());
        Assert.assertFalse((String)"Name field should not be readonly", (boolean)this.nameField.isReadOnly());
        binding.setReadOnly(true);
        Assert.assertTrue((String)"Binding should be readonly", (boolean)binding.isReadOnly());
        Assert.assertTrue((String)"Name field should be readonly", (boolean)this.nameField.isReadOnly());
    }

    @Test
    public void conversionWithLocaleBasedErrorMessage() {
        String fiError = "VIRHE";
        String otherError = "ERROR";
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter((ErrorMessageProvider & Serializable)context -> context.getLocale().map(Locale::getLanguage).orElse("en").equals("fi") ? fiError : otherError)).bind(Person::getAge, Person::setAge);
        this.binder.setBean((Object)((Person)this.item));
        this.ageField.setValue("not a number");
        Assert.assertEquals((Object)otherError, (Object)this.ageField.getErrorMessage().getFormattedHtmlMessage());
        this.ageField.setLocale(new Locale("fi"));
        this.binder.validate();
        Assert.assertEquals((Object)fiError, (Object)this.ageField.getErrorMessage().getFormattedHtmlMessage());
    }

    @Test
    public void valueChangeListenerOrder() {
        AtomicBoolean beanSet = new AtomicBoolean();
        this.nameField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (!beanSet.get()) {
                Assert.assertEquals((String)"Value in bean updated earlier than expected", (Object)e.getOldValue(), (Object)((Person)this.item).getFirstName());
            }
        });
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        this.nameField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (!beanSet.get()) {
                Assert.assertEquals((String)"Value in bean not updated when expected", (Object)e.getValue(), (Object)((Person)this.item).getFirstName());
            }
        });
        beanSet.set(true);
        this.binder.setBean((Object)((Person)this.item));
        beanSet.set(false);
        this.nameField.setValue("Foo");
    }

    @Test
    public void nonSymetricValue_setBean_writtenToBean() {
        this.binder.bind((HasValue)this.nameField, Person::getLastName, Person::setLastName);
        Assert.assertNull((Object)((Person)this.item).getLastName());
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((Object)"", (Object)((Person)this.item).getLastName());
    }

    @Test
    public void nonSymmetricValue_readBean_beanNotTouched() {
        this.binder.bind((HasValue)this.nameField, Person::getLastName, Person::setLastName);
        this.binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> Assert.fail((String)"No value change event should be fired"));
        Assert.assertNull((Object)((Person)this.item).getLastName());
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertNull((Object)((Person)this.item).getLastName());
    }

    @Test
    public void symetricValue_setBean_beanNotUpdated() {
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)new Person(){

            @Override
            public String getFirstName() {
                return "First";
            }

            @Override
            public void setFirstName(String firstName) {
                Assert.fail((String)"Setter should not be called");
            }
        });
    }

    @Test
    public void nullRejetingField_nullValue_wrappedExceptionMentionsNullRepresentation() {
        TextField field = this.createNullAnd42RejectingFieldWithEmptyValue("");
        Binder<AtomicReference<Integer>> binder = this.createIntegerConverterBinder(field);
        this.exceptionRule.expect(IllegalStateException.class);
        this.exceptionRule.expectMessage("null representation");
        this.exceptionRule.expectCause(CoreMatchers.isA(NullPointerException.class));
        binder.readBean(new AtomicReference());
    }

    @Test
    public void nullRejetingField_otherRejectedValue_originalExceptionIsThrown() {
        TextField field = this.createNullAnd42RejectingFieldWithEmptyValue("");
        Binder<AtomicReference<Integer>> binder = this.createIntegerConverterBinder(field);
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("42");
        binder.readBean(new AtomicReference<Integer>(42));
    }

    @Test(expected=NullPointerException.class)
    public void nullAcceptingField_nullValue_originalExceptionIsThrown() {
        TextField field = this.createNullAnd42RejectingFieldWithEmptyValue(null);
        Binder<AtomicReference<Integer>> binder = this.createIntegerConverterBinder(field);
        binder.readBean(new AtomicReference<Object>(null));
    }

    @Test
    public void validationShouldNotRunTwice() {
        TextField salaryField = new TextField();
        this.count = 0;
        ((Person)this.item).setSalaryDouble(100.0);
        this.binder.forField((HasValue)salaryField).withConverter((Converter)new StringToDoubleConverter("")).bind(Person::getSalaryDouble, Person::setSalaryDouble);
        this.binder.setBean((Object)((Person)this.item));
        this.binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> ++this.count);
        salaryField.setValue("1000");
        Assert.assertTrue((boolean)this.binder.isValid());
        salaryField.setValue("salary");
        Assert.assertFalse((boolean)this.binder.isValid());
        salaryField.setValue("2000");
        Assert.assertEquals((long)3L, (long)this.count);
        Assert.assertEquals((Object)new Double(2000.0), (Object)((Person)this.item).getSalaryDouble());
    }

    @Test
    public void validationShouldNotRunTwiceWhenWriting() {
        TextField nameField = new TextField();
        AtomicInteger count = new AtomicInteger(0);
        this.binder.forField((HasValue)nameField).withValidator((Validator & Serializable)(value, context) -> {
            count.incrementAndGet();
            if (value.equals("Mike")) {
                return ValidationResult.ok();
            }
            return ValidationResult.error((String)"value must be Mike");
        }).bind(Person::getFirstName, Person::setFirstName);
        this.binder.readBean((Object)((Person)this.item));
        nameField.setValue("Mike");
        Assert.assertTrue((String)"Validation should be run only once", (1 == count.get() ? 1 : 0) != 0);
        try {
            this.binder.writeBean((Object)((Person)this.item));
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Validation should be run only once", (2 == count.get() ? 1 : 0) != 0);
    }

    @Test
    public void withConverter_hasChangesFalse() {
        TextField nameField = new TextField();
        nameField.setValue("");
        TextField rentField = new TextField();
        rentField.setValue("");
        rentField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> nameField.setValue("Name"));
        ((Person)this.item).setRent(BigDecimal.valueOf(10L));
        this.binder.forField((HasValue)nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)rentField).withConverter((Converter)new EuroConverter("")).withNullRepresentation((Object)BigDecimal.valueOf(0.0)).bind(Person::getRent, Person::setRent);
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertFalse((boolean)this.binder.hasChanges());
        Assert.assertEquals((Object)"\u20ac 10.00", (Object)rentField.getValue());
        Assert.assertEquals((Object)"Name", (Object)nameField.getValue());
    }

    @Test
    public void invalidUsage_modifyFieldsInsideValidator_binderDoesNotThrow() {
        TextField field = new TextField();
        AtomicBoolean validatorIsExecuted = new AtomicBoolean();
        this.binder.forField((HasValue)field).asRequired().withValidator((Validator & Serializable)(val, context) -> {
            this.nameField.setValue("foo");
            this.ageField.setValue("bar");
            validatorIsExecuted.set(true);
            return ValidationResult.ok();
        }).bind(Person::getEmail, Person::setEmail);
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).bind(Person::getLastName, Person::setLastName);
        this.binder.setBean((Object)new Person());
        field.setValue("baz");
        Assert.assertTrue((boolean)validatorIsExecuted.get());
    }

    public void setBean_readOnlyBinding_propertyBinding_valueIsNotUpdated() {
        Binder binder = new Binder(ExampleBean.class);
        binder.forField((HasValue)this.nameField).withNullRepresentation((Object)"").withConverter((Converter)new TestConverter()).bind("vals").setReadOnly(true);
        ExampleBean bean = new ExampleBean();
        SubPropClass val = new SubPropClass();
        bean.setVals(val);
        binder.setBean((Object)bean);
        Assert.assertSame((Object)val, (Object)bean.getVals());
    }

    @Test
    public void setBean_readOnlyBinding_accessorsBiding_valueIsNotUpdated() {
        Binder binder = new Binder(ExampleBean.class);
        binder.forField((HasValue)this.nameField).withNullRepresentation((Object)"").withConverter((Converter)new TestConverter()).bind(ExampleBean::getVals, ExampleBean::setVals).setReadOnly(true);
        ExampleBean bean = new ExampleBean();
        SubPropClass val = new SubPropClass();
        bean.setVals(val);
        binder.setBean((Object)bean);
        Assert.assertSame((Object)val, (Object)bean.getVals());
    }

    @Test
    public void setBean_oneBindingValidationFails_otherBindingValueShouldBeSet() {
        AtomicBoolean validationStatusErrors = new AtomicBoolean();
        AtomicBoolean statusChangeListenerErrors = new AtomicBoolean();
        AtomicInteger validationStatusCalls = new AtomicInteger();
        AtomicInteger statusChangeListenerCalls = new AtomicInteger();
        this.binder.forField((HasValue)this.nameField).withValidator((Validator & Serializable)(value, context) -> ValidationResult.error((String)"Always fails")).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setBean((Object)((Person)this.item));
        this.binder.setValidationStatusHandler((BinderValidationStatusHandler & Serializable)status -> {
            validationStatusCalls.incrementAndGet();
            validationStatusErrors.set(status.hasErrors());
        });
        this.binder.addStatusChangeListener((StatusChangeListener & Serializable)e -> {
            statusChangeListenerCalls.incrementAndGet();
            statusChangeListenerErrors.set(e.hasValidationErrors());
        });
        this.ageField.setValue("15");
        Assert.assertEquals((String)"Age should have been set regardless of invalid name field.", (long)15L, (long)((Person)this.item).getAge());
        Assert.assertEquals((String)"Validation status should not have errors.", (Object)false, (Object)validationStatusErrors.get());
        Assert.assertEquals((String)"Status change listener should not report errors.", (Object)false, (Object)statusChangeListenerErrors.get());
        Assert.assertEquals((String)"Validation status should get one call.", (long)1L, (long)validationStatusCalls.get());
        Assert.assertEquals((String)"Status change listener should get one call.", (long)1L, (long)statusChangeListenerCalls.get());
    }

    @Test
    public void setBean_oneBindingRequiredButEmpty_otherBindingValueShouldBeSet() {
        AtomicBoolean validationStatusErrors = new AtomicBoolean();
        AtomicBoolean statusChangeListenerErrors = new AtomicBoolean();
        AtomicInteger validationStatusCalls = new AtomicInteger();
        AtomicInteger statusChangeListenerCalls = new AtomicInteger();
        ((Person)this.item).setFirstName(null);
        this.binder.forField((HasValue)this.nameField).asRequired("Name is required").bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setBean((Object)((Person)this.item));
        this.binder.setValidationStatusHandler((BinderValidationStatusHandler & Serializable)status -> {
            validationStatusCalls.incrementAndGet();
            validationStatusErrors.set(status.hasErrors());
        });
        this.binder.addStatusChangeListener((StatusChangeListener & Serializable)e -> {
            statusChangeListenerCalls.incrementAndGet();
            statusChangeListenerErrors.set(e.hasValidationErrors());
        });
        this.ageField.setValue("15");
        Assert.assertEquals((String)"Age should have been set regardless of required but empty name field.", (long)15L, (long)((Person)this.item).getAge());
        Assert.assertEquals((String)"Validation status should not have errors.", (Object)false, (Object)validationStatusErrors.get());
        Assert.assertEquals((String)"Status change listener should not report errors.", (Object)false, (Object)statusChangeListenerErrors.get());
        Assert.assertEquals((String)"Validation status should get one call.", (long)1L, (long)validationStatusCalls.get());
        Assert.assertEquals((String)"Status change listener should get one call.", (long)1L, (long)statusChangeListenerCalls.get());
    }

    @Test
    public void setBean_binderValidationFails_noValueShouldBeSet() {
        AtomicBoolean validationStatusErrors = new AtomicBoolean();
        AtomicBoolean statusChangeListenerErrors = new AtomicBoolean();
        AtomicInteger validationStatusCalls = new AtomicInteger();
        AtomicInteger statusChangeListenerCalls = new AtomicInteger();
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.withValidator((Validator & Serializable)(value, context) -> ValidationResult.error((String)"Always fails"));
        this.binder.setBean((Object)((Person)this.item));
        this.binder.setValidationStatusHandler((BinderValidationStatusHandler & Serializable)status -> {
            validationStatusCalls.incrementAndGet();
            validationStatusErrors.set(status.hasErrors());
        });
        this.binder.addStatusChangeListener((StatusChangeListener & Serializable)e -> {
            statusChangeListenerCalls.incrementAndGet();
            statusChangeListenerErrors.set(e.hasValidationErrors());
        });
        this.ageField.setValue("15");
        Assert.assertEquals((String)"Age should not have been set since binder validation fails.", (long)32L, (long)((Person)this.item).getAge());
        Assert.assertEquals((String)"Validation status should have errors.", (Object)true, (Object)validationStatusErrors.get());
        Assert.assertEquals((String)"Status change listener should report errors.", (Object)true, (Object)statusChangeListenerErrors.get());
        Assert.assertEquals((String)"Validation status should get one call.", (long)1L, (long)validationStatusCalls.get());
        Assert.assertEquals((String)"Status change listener should get one call.", (long)1L, (long)statusChangeListenerCalls.get());
    }

    @Test
    public void bindInstanceFields_customBindingAfterInvoke_automaticBindingOverwritten() {
        BindOnlyOneField form = new BindOnlyOneField();
        form.firstName = new TextField();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Binder.BindingBuilder binding = binder.forField((HasValue)form.firstName).withConverter((SerializableFunction & Serializable)str -> str.substring(str.length() / 2), (SerializableFunction & Serializable)str -> str + str);
        binding.bind(Person::getFirstName, Person::setFirstName);
        Person person = new Person();
        person.setFirstName("Hello!");
        binder.setBean((Object)person);
        Assert.assertEquals((Object)"Hello!Hello!", (Object)form.firstName.getValue());
    }

    @Test
    public void bindInstanceFields_incompleteBindingBoundAfterInvoke_automaticBindingOverwritten() {
        BindOnlyOneField form = new BindOnlyOneField();
        form.firstName = new TextField();
        Binder binder = new Binder(Person.class);
        Binder.BindingBuilder binding = binder.forField((HasValue)form.firstName).withConverter((SerializableFunction & Serializable)str -> str.substring(str.length() / 2), (SerializableFunction & Serializable)str -> str + str);
        binder.bindInstanceFields((Object)form);
        binding.bind(Person::getFirstName, Person::setFirstName);
        Person person = new Person();
        person.setFirstName("Hello!");
        binder.setBean((Object)person);
        Assert.assertEquals((Object)"Hello!Hello!", (Object)form.firstName.getValue());
    }

    @Test
    public void bindInstanceFields_incompleteBinding_fieldIgnored() {
        BindOnlyOneField form = new BindOnlyOneField();
        form.firstName = new TextField();
        Binder binder = new Binder(Person.class);
        binder.forField((HasValue)form.firstName).withConverter((SerializableFunction & Serializable)str -> str.substring(str.length() / 2), (SerializableFunction & Serializable)str -> str + str);
        binder.bindInstanceFields((Object)form);
        Assert.assertFalse((String)"Expecting incomplete binding to be ignored by Binder, but field was bound", (boolean)binder.getBinding("firstName").isPresent());
    }

    private TextField createNullAnd42RejectingFieldWithEmptyValue(final String emptyValue) {
        return new TextField(){

            public void setValue(String value) {
                if (value == null) {
                    throw new NullPointerException("Null value");
                }
                if ("42".equals(value)) {
                    throw new IllegalArgumentException("42 is not allowed");
                }
                super.setValue(value);
            }

            public String getEmptyValue() {
                return emptyValue;
            }
        };
    }

    private Binder<AtomicReference<Integer>> createIntegerConverterBinder(TextField field) {
        Binder binder = new Binder();
        binder.forField((HasValue)field).withConverter((Converter)new StringToIntegerConverter("Must have number")).bind(AtomicReference::get, AtomicReference::set);
        return binder;
    }

    public class EuroConverter
    extends StringToBigDecimalConverter {
        public EuroConverter() {
            super("defaultErrorMessage");
        }

        public EuroConverter(String errorMessage) {
            super(errorMessage);
        }

        public Result<BigDecimal> convertToModel(String value, ValueContext context) {
            if (value.isEmpty()) {
                return Result.ok(null);
            }
            if ((value = value.replaceAll("[\u20ac\\s]", "").trim()).isEmpty()) {
                value = "0";
            }
            return super.convertToModel(value, context);
        }

        public String convertToPresentation(BigDecimal value, ValueContext context) {
            if (value == null) {
                return this.convertToPresentation(BigDecimal.ZERO, context);
            }
            return "\u20ac " + super.convertToPresentation((Number)value, context);
        }

        protected NumberFormat getFormat(Locale locale) {
            NumberFormat format = super.getFormat(locale);
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setMaximumFractionDigits(2);
                ((DecimalFormat)format).setMinimumFractionDigits(2);
            }
            return format;
        }
    }

    public static class TestConverter
    implements Converter<String, SubPropClass> {
        public Result<SubPropClass> convertToModel(String value, ValueContext context) {
            return Result.ok(null);
        }

        public String convertToPresentation(SubPropClass value, ValueContext context) {
            return value != null ? value.toString() : null;
        }
    }

    public static class SubPropClass
    implements Serializable {
        private String val1 = "Val1";

        public String toString() {
            return this.val1;
        }
    }

    public static class ExampleBean
    implements Serializable {
        private SubPropClass vals;

        public SubPropClass getVals() {
            return this.vals;
        }

        public void setVals(SubPropClass vals) {
            this.vals = vals;
        }
    }

    public static class BindOnlyOneField
    extends FormLayout {
        private TextField firstName;
        private TextField noFieldInPerson;
    }

    static class MyBindingHandler
    implements BindingValidationStatusHandler {
        boolean expectingError = false;
        int callCount = 0;

        MyBindingHandler() {
        }

        public void statusChange(BindingValidationStatus<?> statusChange) {
            ++this.callCount;
            if (this.expectingError) {
                Assert.assertTrue((String)"Expecting error", (boolean)statusChange.isError());
            } else {
                Assert.assertFalse((String)"Unexpected error", (boolean)statusChange.isError());
            }
        }
    }
}

