/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.data.Binder;
import com.vaadin.data.BinderTestBase;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.server.Setter;
import com.vaadin.shared.ui.colorpicker.Color;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.CheckBoxGroup;
import com.vaadin.ui.ColorPicker;
import com.vaadin.ui.RichTextArea;
import com.vaadin.ui.Slider;
import java.io.Serializable;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinderComponentTest
extends BinderTestBase<Binder<String>, String> {
    @Before
    public void setUp() {
        this.binder = new Binder();
        this.item = "Foo";
    }

    @Test
    public void slider_bind_null() {
        double minValue = 10.5;
        double initialValue = 28.2;
        Slider slider = new Slider();
        slider.setResolution(1);
        slider.setMin(minValue);
        this.testFieldNullRepresentation(initialValue, (HasValue)slider);
    }

    @Test
    public void colorpicker_bind_null() {
        this.testFieldNullRepresentation((Object)new Color(123, 254, 213), (HasValue)new ColorPicker());
    }

    @Test
    public void richtextarea_bind_null() {
        this.testFieldNullRepresentation((Object)"Test text", (HasValue)new RichTextArea());
    }

    @Test
    public void checkbox_bind_null() {
        this.testFieldNullRepresentation(true, (HasValue)new CheckBox());
    }

    @Test
    public void checkboxgroup_bind_null() {
        CheckBoxGroup checkBoxGroup = new CheckBoxGroup();
        checkBoxGroup.setItems((Object[])TestValues.values());
        this.testFieldNullRepresentation((Object)Collections.singleton(TestValues.FILE_NOT_FOUND), (HasValue)checkBoxGroup);
    }

    private <T> void testFieldNullRepresentation(T initialValue, HasValue<T> field) {
        this.binder.bind(field, (ValueProvider & Serializable)t -> null, (Setter & Serializable)(str, val) -> {});
        field.setValue(initialValue);
        Assert.assertEquals((String)"Initial value of field unexpected", initialValue, (Object)field.getValue());
        this.binder.setBean((Object)((String)this.item));
        Assert.assertEquals((String)"Null representation for field failed", (Object)field.getEmptyValue(), (Object)field.getValue());
    }

    static enum TestValues {
        TRUE,
        FALSE,
        FILE_NOT_FOUND;

    }
}

