/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */

package com.vaadin.server;

/**
 * A resource that is served through the Connector that is using the resource.
 *
 * @see AbstractClientConnector#setResource(String, Resource)
 *
 * @author Vaadin Ltd
 * @since 7.0.0
 */
public interface ConnectorResource extends Resource {
    public static final String CONNECTOR_PATH = "connector";

    /**
     * Gets resource as stream.
     * <p>
     * Note that this method is called while the session is locked to prevent
     * race conditions but the methods in the returned {@link DownloadStream}
     * are assumed to be unrelated to the VaadinSession and are called without
     * holding session locks (to prevent locking the session during long file
     * downloads).
     * </p>
     *
     * @return A download stream which produces the resource content
     */
    public DownloadStream getStream();

    /**
     * Gets the virtual filename for this resource.
     *
     * @return the file name associated to this resource.
     */
    public String getFilename();
}
