/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.data.HasValue;
import com.vaadin.shared.ui.datefield.DateResolution;
import com.vaadin.ui.InlineDateField;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class InlineDateFieldConstructorTest {
    @Test
    public void initiallyEmpty() {
        InlineDateField dateField = new InlineDateField();
        Assert.assertTrue((boolean)dateField.isEmpty());
        Assert.assertEquals((Object)DateResolution.DAY, (Object)dateField.getResolution());
    }

    @Test
    public void testValueConstructor_emptyAfterClear() {
        InlineDateField dateField = new InlineDateField(null, LocalDate.now());
        Assert.assertEquals((Object)DateResolution.DAY, (Object)dateField.getResolution());
        Assert.assertFalse((boolean)dateField.isEmpty());
        dateField.clear();
        Assert.assertTrue((boolean)dateField.isEmpty());
    }

    @Test
    public void testValueChangeListener_eventOnValueChange() {
        HasValue.ValueChangeListener valueChangeListener = (HasValue.ValueChangeListener)Mockito.mock(HasValue.ValueChangeListener.class);
        InlineDateField dateField = new InlineDateField(valueChangeListener);
        Assert.assertEquals((Object)DateResolution.DAY, (Object)dateField.getResolution());
        dateField.setValue((Temporal)LocalDate.now());
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener)).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
    }

    @Test
    public void testCaptionValueListener() {
        HasValue.ValueChangeListener valueChangeListener = (HasValue.ValueChangeListener)Mockito.mock(HasValue.ValueChangeListener.class);
        InlineDateField dateField = new InlineDateField("Caption", LocalDate.now(), valueChangeListener);
        Assert.assertEquals((Object)DateResolution.DAY, (Object)dateField.getResolution());
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener, (VerificationMode)Mockito.never())).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
        dateField.setValue((Temporal)LocalDate.now().plusDays(1L));
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener)).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
    }
}

