/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.server.ClientConnector;
import com.vaadin.server.ErrorHandler;
import com.vaadin.server.ServiceException;
import com.vaadin.server.VaadinSession;
import com.vaadin.tests.util.MockUI;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import java.io.Serializable;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class ComponentDetachExceptionTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDetach_failingListeners_allListenersInvokedAndExceptionHandled() throws ServiceException {
        final HashSet expectedExceptions = new HashSet();
        HashSet handledExceptions = new HashSet();
        MockUI ui = new MockUI();
        VaadinSession session = ui.getSession();
        CssLayout layout = new CssLayout();
        ui.setContent((Component)layout);
        session.setErrorHandler((ErrorHandler & Serializable)event -> handledExceptions.add(event.getThrowable()));
        VaadinSession.setCurrent((VaadinSession)session);
        try {
            TracksAttachDetachComponent parent = new TracksAttachDetachComponent(){

                public void detach() {
                    super.detach();
                    this.getDetachEvents().incrementAndGet();
                    UnsupportedOperationException exception = new UnsupportedOperationException("DETACH-PARENT");
                    expectedExceptions.add(exception);
                    throw exception;
                }
            };
            TracksAttachDetachComponent child = new TracksAttachDetachComponent(){

                public void detach() {
                    super.detach();
                    this.getDetachEvents().incrementAndGet();
                    UnsupportedOperationException exception = new UnsupportedOperationException("DETACH-CHILD");
                    expectedExceptions.add(exception);
                    throw exception;
                }
            };
            child.track();
            parent.track();
            child.addDetachListener((ClientConnector.DetachListener & Serializable)event -> {
                ((TracksAttachDetachComponent)event.getSource()).getDetachEvents().incrementAndGet();
                UnsupportedOperationException exception = new UnsupportedOperationException("DETACH-LISTENER-CHILD");
                expectedExceptions.add(exception);
                throw exception;
            });
            parent.addDetachListener((ClientConnector.DetachListener & Serializable)event -> {
                ((TracksAttachDetachComponent)event.getSource()).getDetachEvents().incrementAndGet();
                UnsupportedOperationException exception = new UnsupportedOperationException("DETACH-LISTENER-PARENT");
                expectedExceptions.add(exception);
                throw exception;
            });
            parent.addComponent((Component)child);
            layout.addComponent((Component)parent);
            child.assertDetachEvents(0);
            parent.assertDetachEvents(0);
            layout.removeComponent((Component)parent);
            Assert.assertEquals(expectedExceptions, handledExceptions);
            parent.assertDetachEvents(3);
            child.assertDetachEvents(3);
        }
        finally {
            VaadinSession.setCurrent(null);
        }
    }

    public static interface TracksAttachDetach {
        default public void track() {
            if (!(this instanceof Component)) {
                throw new IllegalStateException("Cannot track a non-component");
            }
            ((Component)this).addAttachListener((ClientConnector.AttachListener & Serializable)event -> this.getAttachEvents().incrementAndGet());
            ((Component)this).addDetachListener((ClientConnector.DetachListener & Serializable)event -> this.getDetachEvents().incrementAndGet());
        }

        public AtomicInteger getAttachEvents();

        public AtomicInteger getDetachEvents();

        default public void assertAttachEvents(int attachEvents) {
            Assert.assertEquals((long)attachEvents, (long)this.getAttachEvents().get());
        }

        default public void assertDetachEvents(int detachEvents) {
            Assert.assertEquals((long)detachEvents, (long)this.getDetachEvents().get());
        }
    }

    public static class TracksAttachDetachComponent
    extends CssLayout
    implements TracksAttachDetach {
        private AtomicInteger attachEvents = new AtomicInteger();
        private AtomicInteger detachEvents = new AtomicInteger();

        @Override
        public AtomicInteger getAttachEvents() {
            return this.attachEvents;
        }

        @Override
        public AtomicInteger getDetachEvents() {
            return this.detachEvents;
        }
    }
}

