/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.navigator;

import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.ui.Label;
import org.junit.Assert;
import org.junit.Test;

public class ClassBasedViewProviderTest {
    @Test(expected=IllegalArgumentException.class)
    public void testCreateProviderWithNullName() throws Exception {
        new Navigator.ClassBasedViewProvider(null, TestView.class);
        Assert.fail((String)"Should not be able to create view provider with null name");
    }

    @Test
    public void testCreateProviderWithEmptyStringName() throws Exception {
        new Navigator.ClassBasedViewProvider("", TestView.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateProviderNullViewClass() throws Exception {
        new Navigator.ClassBasedViewProvider("test", null);
        Assert.fail((String)"Should not be able to create view provider with null view class");
    }

    @Test
    public void testViewNameGetter() throws Exception {
        Navigator.ClassBasedViewProvider provider1 = new Navigator.ClassBasedViewProvider("", TestView.class);
        Assert.assertEquals((String)"View name should be empty", (Object)"", (Object)provider1.getViewName());
        Navigator.ClassBasedViewProvider provider2 = new Navigator.ClassBasedViewProvider("test", TestView.class);
        Assert.assertEquals((String)"View name does not match", (Object)"test", (Object)provider2.getViewName());
    }

    @Test
    public void testViewClassGetter() throws Exception {
        Navigator.ClassBasedViewProvider provider = new Navigator.ClassBasedViewProvider("test", TestView.class);
        Assert.assertEquals((String)"Incorrect view class returned by getter", TestView.class, (Object)provider.getViewClass());
    }

    @Test
    public void testGetViewNameForNullString() throws Exception {
        Navigator.ClassBasedViewProvider provider = new Navigator.ClassBasedViewProvider("test", TestView.class);
        Assert.assertNull((String)"Received view name for null view string", (Object)provider.getViewName(null));
    }

    @Test
    public void testGetViewNameForEmptyString() throws Exception {
        Navigator.ClassBasedViewProvider provider1 = new Navigator.ClassBasedViewProvider("", TestView.class);
        Assert.assertEquals((String)"Did not find view name for empty view string in a provider with empty string registered", (Object)"", (Object)provider1.getViewName(""));
        Navigator.ClassBasedViewProvider provider2 = new Navigator.ClassBasedViewProvider("test", TestView.class);
        Assert.assertNull((String)"Found view name for empty view string when none registered", (Object)provider2.getViewName(""));
    }

    @Test
    public void testGetViewNameWithParameters() throws Exception {
        Navigator.ClassBasedViewProvider provider = new Navigator.ClassBasedViewProvider("test", TestView.class);
        Assert.assertEquals((String)"Incorrect view name found for view string", (Object)"test", (Object)provider.getViewName("test"));
        Assert.assertEquals((String)"Incorrect view name found for view string ending with slash", (Object)"test", (Object)provider.getViewName("test/"));
        Assert.assertEquals((String)"Incorrect view name found for view string with parameters", (Object)"test", (Object)provider.getViewName("test/params/are/here"));
    }

    @Test
    public void testGetView() throws Exception {
        Navigator.ClassBasedViewProvider provider = new Navigator.ClassBasedViewProvider("test", TestView.class);
        View view = provider.getView("test");
        Assert.assertNotNull((String)"Did not get view from a provider", (Object)view);
        Assert.assertEquals((String)"Incorrect view type", TestView.class, view.getClass());
    }

    @Test
    public void testGetViewIncorrectViewName() throws Exception {
        Navigator.ClassBasedViewProvider provider = new Navigator.ClassBasedViewProvider("test", TestView.class);
        View view = provider.getView("test2");
        Assert.assertNull((String)"Got view from a provider for incorrect view name", (Object)view);
    }

    public static class TestView2
    extends TestView {
    }

    public static class TestView
    extends Label
    implements View {
        public String parameters = null;

        public void enter(ViewChangeListener.ViewChangeEvent event) {
            this.parameters = event.getParameters();
        }
    }
}

