/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.components;

import com.vaadin.shared.Registration;
import com.vaadin.ui.LegacyWindow;
import com.vaadin.ui.Window;
import java.util.HashMap;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class WindowTest {
    private Window window;

    @Before
    public void setUp() {
        this.window = new Window();
        new LegacyWindow().addWindow(this.window);
    }

    @Test
    public void testCloseListener() {
        Window.CloseListener cl = (Window.CloseListener)EasyMock.createMock(Window.CloseListener.class);
        cl.windowClose((Window.CloseEvent)EasyMock.isA(Window.CloseEvent.class));
        EasyMock.replay((Object[])new Object[]{cl});
        Registration windowCloseListenerRegistration = this.window.addCloseListener(cl);
        WindowTest.sendClose(this.window);
        EasyMock.verify((Object[])new Object[]{cl});
        windowCloseListenerRegistration.remove();
        WindowTest.sendClose(this.window);
        EasyMock.verify((Object[])new Object[]{cl});
    }

    @Test
    public void testResizeListener() {
        Window.ResizeListener rl = (Window.ResizeListener)EasyMock.createMock(Window.ResizeListener.class);
        rl.windowResized((Window.ResizeEvent)EasyMock.isA(Window.ResizeEvent.class));
        EasyMock.replay((Object[])new Object[]{rl});
        Registration windowResizeListenerRegistration = this.window.addResizeListener(rl);
        this.sendResize(this.window);
        EasyMock.verify((Object[])new Object[]{rl});
        windowResizeListenerRegistration.remove();
        this.sendResize(this.window);
        EasyMock.verify((Object[])new Object[]{rl});
    }

    private void sendResize(Window window2) {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("height", 1234);
        this.window.changeVariables((Object)this.window, variables);
    }

    private static void sendClose(Window window) {
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("close", true);
        window.changeVariables((Object)window, variables);
    }
}

