/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.orderedlayout;

import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import java.util.Iterator;
import org.junit.Test;

public class OrderedLayoutTest {
    @Test
    public void testVLIteration() {
        this.testIndexing((AbstractOrderedLayout)new VerticalLayout(), 10);
    }

    @Test
    public void testHLIteration() {
        this.testIndexing((AbstractOrderedLayout)new HorizontalLayout(), 12);
    }

    public void testIndexing(AbstractOrderedLayout aol, int nrComponents) {
        Component[] components;
        for (Component c : components = this.generateComponents(nrComponents)) {
            aol.addComponent(c);
        }
        for (int i = 0; i < nrComponents; ++i) {
            assert (aol.getComponent(i) == components[i]);
            assert (aol.getComponentIndex(components[i]) == i);
        }
        int idx = 0;
        Iterator i = aol.getComponentIterator();
        while (i.hasNext()) {
            Component c = (Component)i.next();
            assert (aol.getComponentIndex(c) == idx++);
        }
    }

    private Component[] generateComponents(int nr) {
        Component[] components = new Component[nr];
        for (int i = 0; i < nr; ++i) {
            components[i] = new Label("" + i);
        }
        return components;
    }
}

