/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.menubar;

import com.vaadin.ui.MenuBar;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MenuBarIdsTest
implements MenuBar.Command {
    private MenuBar.MenuItem lastSelectedItem;
    private MenuBar.MenuItem menuFile;
    private MenuBar.MenuItem menuEdit;
    private MenuBar.MenuItem menuEditCopy;
    private MenuBar.MenuItem menuEditCut;
    private MenuBar.MenuItem menuEditPaste;
    private MenuBar.MenuItem menuEditFind;
    private MenuBar.MenuItem menuFileOpen;
    private MenuBar.MenuItem menuFileSave;
    private MenuBar.MenuItem menuFileExit;
    private final Set<MenuBar.MenuItem> menuItems = new HashSet<MenuBar.MenuItem>();
    private MenuBar menuBar;

    @Before
    public void setUp() {
        this.menuBar = new MenuBar();
        this.menuFile = this.menuBar.addItem("File", (MenuBar.Command)this);
        this.menuEdit = this.menuBar.addItem("Edit", (MenuBar.Command)this);
        this.menuEditCopy = this.menuEdit.addItem("Copy", (MenuBar.Command)this);
        this.menuEditCut = this.menuEdit.addItem("Cut", (MenuBar.Command)this);
        this.menuEditPaste = this.menuEdit.addItem("Paste", (MenuBar.Command)this);
        this.menuEdit.addSeparator();
        this.menuEditFind = this.menuEdit.addItem("Find...", (MenuBar.Command)this);
        this.menuFileOpen = this.menuFile.addItem("Open", (MenuBar.Command)this);
        this.menuFileSave = this.menuFile.addItem("Save", (MenuBar.Command)this);
        this.menuFile.addSeparator();
        this.menuFileExit = this.menuFile.addItem("Exit", (MenuBar.Command)this);
        this.menuItems.add(this.menuFile);
        this.menuItems.add(this.menuEdit);
        this.menuItems.add(this.menuEditCopy);
        this.menuItems.add(this.menuEditCut);
        this.menuItems.add(this.menuEditPaste);
        this.menuItems.add(this.menuEditFind);
        this.menuItems.add(this.menuFileOpen);
        this.menuItems.add(this.menuFileSave);
        this.menuItems.add(this.menuFileExit);
    }

    @Test
    public void testMenubarIdUniqueness() {
        MenuBarIdsTest.assertUniqueIds(this.menuBar);
        this.menuBar.removeItem(this.menuFile);
        MenuBar.MenuItem file2 = this.menuBar.addItem("File2", (MenuBar.Command)this);
        MenuBar.MenuItem file3 = this.menuBar.addItem("File3", (MenuBar.Command)this);
        MenuBar.MenuItem file2sub = file2.addItem("File2 sub menu", (MenuBar.Command)this);
        this.menuItems.add(file2);
        this.menuItems.add(file2sub);
        this.menuItems.add(file3);
        MenuBarIdsTest.assertUniqueIds(this.menuBar);
    }

    private static void assertUniqueIds(MenuBar menuBar) {
        HashSet<Object> ids = new HashSet<Object>();
        for (MenuBar.MenuItem item : menuBar.getItems()) {
            MenuBarIdsTest.assertUniqueIds(ids, item);
        }
    }

    private static void assertUniqueIds(Set<Object> ids, MenuBar.MenuItem item) {
        int id = item.getId();
        System.out.println("Item " + item.getText() + ", id: " + id);
        Assert.assertFalse((boolean)ids.contains(id));
        ids.add(id);
        if (item.getChildren() != null) {
            for (MenuBar.MenuItem subItem : item.getChildren()) {
                MenuBarIdsTest.assertUniqueIds(ids, subItem);
            }
        }
    }

    public void menuSelected(MenuBar.MenuItem selectedItem) {
        Assert.assertNull((String)"lastSelectedItem was not cleared before selecting an item", (Object)this.lastSelectedItem);
        this.lastSelectedItem = selectedItem;
    }
}

