/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.grid;

import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.DataProviderListener;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.shared.ui.grid.DropLocation;
import com.vaadin.ui.Grid;
import com.vaadin.ui.components.grid.DropIndexCalculator;
import com.vaadin.ui.components.grid.GridDropEvent;
import com.vaadin.ui.components.grid.GridRowDragger;
import com.vaadin.ui.components.grid.SourceDataProviderUpdater;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridRowDraggerOneGridTest {
    private Grid<String> source;
    private TestGridRowDragger dragger;
    private List<String> draggedItems;

    @Before
    public void setupListCase() {
        this.source = new Grid();
        this.source.addColumn((ValueProvider & Serializable)s -> s).setId("1");
        this.dragger = new TestGridRowDragger(this.source);
    }

    private void drop(String dropIndex, DropLocation dropLocation, String ... items) {
        this.draggedItems = new ArrayList<String>(Arrays.asList(items));
        this.dragger.handleDrop((GridDropEvent<String>)new GridDropEvent(this.source, null, null, null, (Object)dropIndex, dropLocation, null));
    }

    private void verifyDataProvider(String ... items) {
        Collection list = ((ListDataProvider)this.source.getDataProvider()).getItems();
        Assert.assertArrayEquals((String)"Invalid items in target data provider", (Object[])items, (Object[])list.toArray());
    }

    private static void setCustomDataProvider(Grid<String> grid) {
        grid.setDataProvider((Grid.FetchItemsCallback & Serializable)(so, i, l) -> null, null);
    }

    private static void setCustomDataProvider(Grid<String> grid, String ... items) {
        grid.setDataProvider((Grid.FetchItemsCallback & Serializable)(so, i, l) -> Stream.of(items), null);
    }

    @Test
    public void listDataProviders_basicOperation() {
        this.source.setItems((Object[])new String[]{"0", "1", "2"});
        this.drop(null, null, "0");
        this.verifyDataProvider("1", "2", "0");
        this.drop("0", DropLocation.BELOW, "1");
        this.verifyDataProvider("2", "0", "1");
        this.drop("1", DropLocation.ABOVE, "2");
        this.verifyDataProvider("0", "2", "1");
    }

    @Test
    public void listDataProvider_dropAboveFirst() {
        this.source.setItems((Object[])new String[]{"0", "1"});
        this.drop("0", DropLocation.ABOVE, "1");
        this.verifyDataProvider("1", "0");
    }

    @Test
    public void listDataProvider_customCalculator() {
        this.source.setItems((Object[])new String[]{"0", "1"});
        AtomicInteger trigger = new AtomicInteger();
        this.dragger.setDropIndexCalculator((DropIndexCalculator & Serializable)event -> {
            trigger.incrementAndGet();
            return 0;
        });
        this.drop("1", DropLocation.BELOW, "0");
        Assert.assertEquals((String)"Custom calculator should be invoked", (long)1L, (long)trigger.get());
        this.verifyDataProvider("0", "1");
    }

    @Test
    public void listDataProvider_customCalculatorReturnsMax_droppedToEnd() {
        this.source.setItems((Object[])new String[]{"0", "1", "2"});
        this.dragger.setDropIndexCalculator((DropIndexCalculator & Serializable)event -> Integer.MAX_VALUE);
        this.drop("1", DropLocation.ABOVE, "0");
        this.verifyDataProvider("1", "2", "0");
    }

    @Test
    public void listDataProvider_calledOnlyOnce() {
        int[] times = new int[1];
        this.source.setItems((Object[])new String[]{"0", "1", "2"});
        this.source.getDataProvider().addDataProviderListener((DataProviderListener & Serializable)ev -> {
            times[0] = times[0] + 1;
        });
        this.dragger.setDropIndexCalculator((DropIndexCalculator & Serializable)event -> Integer.MAX_VALUE);
        this.drop("1", DropLocation.ABOVE, "0");
        this.verifyDataProvider("1", "2", "0");
        Assert.assertArrayEquals((String)"DataProvider should be invoked only once", (int[])new int[]{1}, (int[])times);
    }

    @Test
    public void noopSourceUpdater() {
        this.source.setItems((Object[])new String[]{"0", "1", "2"});
        this.dragger.setSourceDataProviderUpdater(SourceDataProviderUpdater.NOOP);
        this.drop("2", DropLocation.ABOVE, "0", "1");
        this.verifyDataProvider("0", "1", "0", "1", "2");
    }

    @Test
    public void alwaysDropToEndCalculator() {
        this.source.setItems((Object[])new String[]{"0", "1", "2"});
        this.dragger.setDropIndexCalculator(DropIndexCalculator.alwaysDropToEnd());
        this.drop("1", DropLocation.ABOVE, "0");
        this.verifyDataProvider("1", "2", "0");
    }

    @Test
    public void dropTwoFromEnd_beginning() {
        this.source.setItems((Object[])new String[]{"0", "1", "2", "3"});
        this.drop("0", DropLocation.ABOVE, "2", "3");
        this.verifyDataProvider("2", "3", "0", "1");
    }

    @Test
    public void dropTwoFromEnd_middle() {
        this.source.setItems((Object[])new String[]{"0", "1", "2", "3"});
        this.drop("1", DropLocation.ABOVE, "2", "3");
        this.verifyDataProvider("0", "2", "3", "1");
    }

    @Test
    public void dropTwoFromEnd_aboveOneThatIsDragged_doesntExplode() {
        this.source.setItems((Object[])new String[]{"0", "1", "2", "3"});
        this.drop("2", DropLocation.ABOVE, "2", "3");
        this.verifyDataProvider("0", "1", "2", "3");
    }

    @Test
    public void dragAndAboveFirst_thatIsAlsoDragged_doesntExplode() {
        this.source.setItems((Object[])new String[]{"0", "1", "2", "3"});
        this.drop("2", DropLocation.ABOVE, "2", "3");
        this.verifyDataProvider("0", "1", "2", "3");
    }

    @Test
    public void dropFromBeginning_afterOneDragged_doesntExplode() {
        this.source.setItems((Object[])new String[]{"0", "1", "2", "3", "4"});
        this.drop("3", DropLocation.BELOW, "0", "1", "3");
        this.verifyDataProvider("2", "0", "1", "3", "4");
    }

    @Test
    public void dropMixedSet_onOneOfTheDragged_doesntExplode() {
        this.source.setItems((Object[])new String[]{"0", "1", "2", "3", "4"});
        this.drop("2", DropLocation.BELOW, "0", "2", "4");
        this.verifyDataProvider("1", "0", "2", "4", "3");
    }

    @Test
    public void dropOnSortedGrid_byDefault_dropsToTheEnd() {
        Assert.assertFalse((String)"Default drops on sorted grid rows should not be allowed", (boolean)this.dragger.getGridDropTarget().isDropAllowedOnRowsWhenSorted());
        this.source.setItems((Object[])new String[]{"0", "1", "2", "3", "4"});
        this.drop("3", DropLocation.BELOW, "1");
        this.verifyDataProvider("0", "2", "3", "1", "4");
        this.source.sort("1");
        this.drop(null, DropLocation.EMPTY, "0");
        this.verifyDataProvider("2", "3", "1", "4", "0");
    }

    public class TestGridRowDragger
    extends GridRowDragger<String> {
        public TestGridRowDragger(Grid<String> grid) {
            super(grid);
        }

        public void handleDrop(GridDropEvent<String> event) {
            super.handleDrop(event);
        }

        public List<String> getDraggedItems() {
            return GridRowDraggerOneGridTest.this.draggedItems;
        }
    }
}

