/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.grid;

import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.Label;
import com.vaadin.ui.components.grid.DetailsGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridDetailsTest {
    private TestGrid grid;
    private List<String> data;

    @Before
    public void setUp() {
        this.grid = new TestGrid();
        this.data = new ArrayList<String>(Arrays.asList("Foo", "Bar"));
        this.grid.setItems(this.data);
        this.grid.setDetailsGenerator((DetailsGenerator & Serializable)s -> new DummyLabel((String)s));
        this.data.forEach(s -> this.grid.setDetailsVisible(s, true));
        this.grid.runDataGeneration();
    }

    @Test
    public void testGridComponentIteratorContainsDetailsComponents() {
        Iterator iterator = this.grid.iterator();
        while (iterator.hasNext()) {
            Component c = (Component)iterator.next();
            if (c instanceof Label) {
                String value = ((Label)c).getValue();
                Assert.assertTrue((String)("Unexpected label in component iterator with value " + value), (boolean)this.data.remove(value));
                continue;
            }
            Assert.fail((String)"Iterator contained a component that is not a label.");
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGridComponentIteratorNotModifiable() {
        Iterator iterator = this.grid.iterator();
        iterator.next();
        iterator.remove();
    }

    @Test
    public void testGridComponentIteratorIsEmptyAfterHidingDetails() {
        Assert.assertTrue((String)"Component iterator should have components.", (boolean)this.grid.iterator().hasNext());
        this.data.forEach(s -> this.grid.setDetailsVisible(s, false));
        Assert.assertFalse((String)"Component iterator should not have components.", (boolean)this.grid.iterator().hasNext());
    }

    public static class TestGrid
    extends Grid<String> {
        public void runDataGeneration() {
            super.getDataCommunicator().beforeClientResponse(true);
        }
    }

    private final class DummyLabel
    extends Label {
        private DummyLabel(String content) {
            super(content);
        }

        public String getConnectorId() {
            return "";
        }
    }
}

