/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.grid;

import com.vaadin.data.PropertyDefinition;
import com.vaadin.data.PropertySet;
import com.vaadin.data.ValueProvider;
import com.vaadin.server.Setter;
import com.vaadin.ui.Grid;
import java.io.Serializable;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class GridCustomPropertySetTest {
    @Test
    public void customPropertySet() {
        GridWithCustomPropertySet customGrid = new GridWithCustomPropertySet();
        Assert.assertEquals((long)0L, (long)customGrid.getColumns().size());
        Grid.Column numberColumn = customGrid.addColumn("numbah");
        Assert.assertEquals((long)1L, (long)customGrid.getColumns().size());
        Assert.assertEquals((Object)"The Number", (Object)numberColumn.getCaption());
        Assert.assertEquals((long)24L, (long)((Integer)numberColumn.getValueProvider().apply((Object)new MyBeanWithoutGetters("foo", 24))).intValue());
        Grid.Column stringColumn = customGrid.addColumn("string");
        Assert.assertEquals((long)2L, (long)customGrid.getColumns().size());
        Assert.assertEquals((Object)"The String", (Object)stringColumn.getCaption());
        Assert.assertEquals((Object)"foo", (Object)stringColumn.getValueProvider().apply((Object)new MyBeanWithoutGetters("foo", 24)));
    }

    public static class GridWithCustomPropertySet
    extends Grid<MyBeanWithoutGetters> {
        public GridWithCustomPropertySet() {
            this.setPropertySet(new MyBeanPropertySet());
        }

        private final class NumberDefinition
        implements PropertyDefinition<MyBeanWithoutGetters, Integer> {
            private PropertySet<MyBeanWithoutGetters> propertySet;

            public NumberDefinition(PropertySet<MyBeanWithoutGetters> propertySet) {
                this.propertySet = propertySet;
            }

            public ValueProvider<MyBeanWithoutGetters, Integer> getGetter() {
                return (ValueProvider & Serializable)bean -> bean.number;
            }

            public Optional<Setter<MyBeanWithoutGetters, Integer>> getSetter() {
                return Optional.of((Setter & Serializable)(bean, value) -> {
                    bean.number = value;
                });
            }

            public Class<Integer> getType() {
                return Integer.class;
            }

            public Class<?> getPropertyHolderType() {
                return MyBeanWithoutGetters.class;
            }

            public String getName() {
                return "numbah";
            }

            public String getCaption() {
                return "The Number";
            }

            public PropertySet<MyBeanWithoutGetters> getPropertySet() {
                return this.propertySet;
            }
        }

        private final class StrDefinition
        implements PropertyDefinition<MyBeanWithoutGetters, String> {
            private PropertySet<MyBeanWithoutGetters> propertySet;

            public StrDefinition(PropertySet<MyBeanWithoutGetters> propertySet) {
                this.propertySet = propertySet;
            }

            public ValueProvider<MyBeanWithoutGetters, String> getGetter() {
                return (ValueProvider & Serializable)bean -> bean.str;
            }

            public Optional<Setter<MyBeanWithoutGetters, String>> getSetter() {
                return Optional.of((Setter & Serializable)(bean, value) -> {
                    bean.str = value;
                });
            }

            public Class<String> getType() {
                return String.class;
            }

            public Class<?> getPropertyHolderType() {
                return MyBeanWithoutGetters.class;
            }

            public String getName() {
                return "string";
            }

            public String getCaption() {
                return "The String";
            }

            public PropertySet<MyBeanWithoutGetters> getPropertySet() {
                return this.propertySet;
            }
        }

        private final class MyBeanPropertySet
        implements PropertySet<MyBeanWithoutGetters> {
            private PropertyDefinition<MyBeanWithoutGetters, String> strDef;
            private PropertyDefinition<MyBeanWithoutGetters, Integer> numberDef;

            private MyBeanPropertySet() {
                this.strDef = new StrDefinition(this);
                this.numberDef = new NumberDefinition(this);
            }

            public Stream<PropertyDefinition<MyBeanWithoutGetters, ?>> getProperties() {
                return Stream.of(this.strDef, this.numberDef);
            }

            public Optional<PropertyDefinition<MyBeanWithoutGetters, ?>> getProperty(String name) {
                return this.getProperties().filter(pd -> pd.getName().equals(name)).findFirst();
            }
        }
    }

    public static class MyBeanWithoutGetters {
        public String str;
        public int number;

        public MyBeanWithoutGetters(String str, int number) {
            this.str = str;
            this.number = number;
        }
    }
}

