/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.datefield;

import com.vaadin.shared.ui.datefield.AbstractDateFieldServerRpc;
import com.vaadin.shared.ui.datefield.DateResolution;
import com.vaadin.tests.server.component.abstractdatefield.AbstractLocalDateFieldDeclarativeTest;
import com.vaadin.ui.AbstractDateField;
import com.vaadin.ui.InlineDateField;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class DateFieldErrorMessageTest
extends AbstractLocalDateFieldDeclarativeTest<InlineDateField> {
    @Test
    public void testErrorMessageRemoved() throws Exception {
        InlineDateField field = new InlineDateField("Day is", LocalDate.of(2003, 2, 27));
        this.checkValueAndComponentError(field, "2003-02-27", LocalDate.of(2003, 2, 27), false);
        this.checkValueAndComponentError(field, "", null, false);
        this.checkValueAndComponentError(field, "2003-04-27", LocalDate.of(2003, 4, 27), false);
        this.checkValueAndComponentError(field, "foo", null, true);
        this.checkValueAndComponentError(field, "2013-07-03", LocalDate.of(2013, 7, 3), false);
        this.checkValueAndComponentError(field, "foo", null, true);
        this.checkValueAndComponentError(field, "", null, false);
    }

    @Override
    protected String getComponentTag() {
        return "vaadin-inline-date-field";
    }

    @Override
    protected Class<? extends InlineDateField> getComponentClass() {
        return InlineDateField.class;
    }

    private void checkValueAndComponentError(InlineDateField field, String newInput, LocalDate expectedFieldValue, boolean componentErrorExpected) throws Exception {
        this.setDateByText(field, newInput);
        Assert.assertEquals((Object)expectedFieldValue, (Object)field.getValue());
        Assert.assertEquals((Object)componentErrorExpected, (Object)(field.getComponentError() != null ? 1 : 0));
    }

    private void setDateByText(InlineDateField field, String dateText) throws Exception {
        Field rcpField = AbstractDateField.class.getDeclaredField("rpc");
        rcpField.setAccessible(true);
        AbstractDateFieldServerRpc rcp = (AbstractDateFieldServerRpc)rcpField.get(field);
        HashMap<String, Integer> resolutions = new HashMap<String, Integer>();
        try {
            LocalDate date = LocalDate.parse(dateText);
            resolutions.put(DateResolution.YEAR.name(), date.getYear());
            resolutions.put(DateResolution.MONTH.name(), date.getMonthValue());
            resolutions.put(DateResolution.DAY.name(), date.getDayOfMonth());
        }
        catch (Exception exception) {
            // empty catch block
        }
        rcp.update(dateText, resolutions);
    }
}

