/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.csslayout;

import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;

public class AddComponentsTest {
    private final Component[] children = new Component[]{new Label("A"), new Label("B"), new Label("C"), new Label("D")};

    @Test
    public void moveComponentsBetweenLayouts() {
        CssLayout layout1 = new CssLayout();
        CssLayout layout2 = new CssLayout();
        layout1.addComponent(this.children[0]);
        layout1.addComponent(this.children[1]);
        layout2.addComponent(this.children[2]);
        layout2.addComponent(this.children[3]);
        layout2.addComponent(this.children[1], 1);
        this.assertOrder((Layout)layout1, new int[]{0});
        this.assertOrder((Layout)layout2, new int[]{2, 1, 3});
        layout1.addComponent(this.children[3], 0);
        this.assertOrder((Layout)layout1, new int[]{3, 0});
        this.assertOrder((Layout)layout2, new int[]{2, 1});
        layout2.addComponent(this.children[0]);
        this.assertOrder((Layout)layout1, new int[]{3});
        this.assertOrder((Layout)layout2, new int[]{2, 1, 0});
        layout1.addComponentAsFirst(this.children[1]);
        this.assertOrder((Layout)layout1, new int[]{1, 3});
        this.assertOrder((Layout)layout2, new int[]{2, 0});
    }

    @Test
    public void shuffleChildComponents() {
        CssLayout layout = new CssLayout();
        for (int i = 0; i < this.children.length; ++i) {
            layout.addComponent(this.children[i], i);
        }
        this.assertOrder((Layout)layout, new int[]{0, 1, 2, 3});
        layout.addComponent(this.children[2], 1);
        this.assertOrder((Layout)layout, new int[]{0, 2, 1, 3});
        layout.addComponent(this.children[2], 4);
        this.assertOrder((Layout)layout, new int[]{0, 1, 3, 2});
        layout.addComponent(this.children[1], 1);
        this.assertOrder((Layout)layout, new int[]{0, 1, 3, 2});
        layout.addComponent(this.children[3], 0);
        this.assertOrder((Layout)layout, new int[]{3, 0, 1, 2});
        layout.addComponent(this.children[0]);
        this.assertOrder((Layout)layout, new int[]{3, 1, 2, 0});
        layout.addComponent(this.children[0]);
        this.assertOrder((Layout)layout, new int[]{3, 1, 2, 0});
        layout.addComponentAsFirst(this.children[2]);
        this.assertOrder((Layout)layout, new int[]{2, 3, 1, 0});
        layout.addComponentAsFirst(this.children[2]);
        this.assertOrder((Layout)layout, new int[]{2, 3, 1, 0});
    }

    @Test
    public void testConstructorWithComponents() {
        CssLayout layout = new CssLayout(this.children);
        this.assertOrder((Layout)layout, new int[]{0, 1, 2, 3});
    }

    @Test
    public void testAddComponents() {
        CssLayout layout = new CssLayout();
        layout.addComponents(this.children);
        this.assertOrder((Layout)layout, new int[]{0, 1, 2, 3});
        Label extra = new Label("Extra");
        layout.addComponents(new Component[]{extra});
        Assert.assertSame((Object)extra, (Object)layout.getComponent(4));
        layout.removeAllComponents();
        layout.addComponents(new Component[]{this.children[3], this.children[2], this.children[1], this.children[0]});
        this.assertOrder((Layout)layout, new int[]{3, 2, 1, 0});
    }

    private void assertOrder(Layout layout, int[] indices) {
        Iterator i = layout.getComponentIterator();
        try {
            for (int index : indices) {
                Assert.assertSame((Object)this.children[index], i.next());
            }
            Assert.assertFalse((String)"Too many components in layout", (boolean)i.hasNext());
        }
        catch (NoSuchElementException e) {
            Assert.fail((String)"Too few components in layout");
        }
    }
}

