/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.abstractorderedlayout;

import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import org.junit.Assert;
import org.junit.Test;

public class LayoutSettingsOnReplaceTest {
    @Test
    public void testExpandRatio() {
        AbstractOrderedLayout layout = new AbstractOrderedLayout(){};
        AbstractComponent first = new AbstractComponent(){};
        AbstractComponent second = new AbstractComponent(){};
        layout.addComponent((Component)first);
        layout.addComponent((Component)second);
        int ratio = 2;
        layout.setExpandRatio((Component)first, (float)ratio);
        layout.setExpandRatio((Component)second, 1.0f);
        AbstractComponent replace = new AbstractComponent(){};
        layout.replaceComponent((Component)first, (Component)replace);
        Assert.assertEquals((String)"Expand ratio for replaced component is not the same as for previous one", (double)ratio, (double)layout.getExpandRatio((Component)replace), (double)1.0E-4);
    }

    @Test
    public void testAlignment() {
        AbstractOrderedLayout layout = new AbstractOrderedLayout(){};
        AbstractComponent first = new AbstractComponent(){};
        AbstractComponent second = new AbstractComponent(){};
        layout.addComponent((Component)first);
        layout.addComponent((Component)second);
        Alignment alignment = Alignment.BOTTOM_RIGHT;
        layout.setComponentAlignment((Component)first, alignment);
        layout.setComponentAlignment((Component)second, Alignment.MIDDLE_CENTER);
        AbstractComponent replace = new AbstractComponent(){};
        layout.replaceComponent((Component)first, (Component)replace);
        Assert.assertEquals((String)"Alignment for replaced component is not the same as for previous one", (Object)alignment, (Object)layout.getComponentAlignment((Component)replace));
    }
}

