/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.abstractlisting;

import com.vaadin.data.provider.Query;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.FileResource;
import com.vaadin.server.Resource;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.server.ThemeResource;
import com.vaadin.tests.design.DeclarativeTestBaseBase;
import com.vaadin.tests.server.component.abstractcomponent.AbstractComponentDeclarativeTestBase;
import com.vaadin.ui.AbstractListing;
import com.vaadin.ui.IconGenerator;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.declarative.DesignContext;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractListingDeclarativeTest<T extends AbstractListing>
extends AbstractComponentDeclarativeTestBase<T> {
    private static final String EXTERNAL_URL = "http://example.com/example.gif";
    private static final String FILE_PATH = "img/example.gif";
    private static final String THEME_PATH = "example.gif";

    @Test
    public abstract void dataSerialization() throws InstantiationException, IllegalAccessException, InvocationTargetException;

    @Test
    public abstract void valueSerialization() throws InstantiationException, IllegalAccessException, InvocationTargetException;

    @Test
    public void itemIconsSerialization() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        AbstractListing component = (AbstractListing)this.getComponentClass().newInstance();
        Method setIconGenerator = this.getIconGeneratorMethod(component);
        if (setIconGenerator == null) {
            return;
        }
        List<String> items = Arrays.asList("foo", "bar", "foobar", "barfoo");
        String design = String.format("<%s>\n<option item='foo' icon='%s'>foo</option>\n<option item='bar' icon='%s'>bar</option><option item='foobar' icon='theme://%s'>foobar</option><option item='barfoo'>barfoo</option></%s>", this.getComponentTag(), EXTERNAL_URL, FILE_PATH, THEME_PATH, this.getComponentTag());
        component.setItems(items);
        IconGenerator & Serializable generator = (IconGenerator & Serializable)item -> this.generateIcons(item, items);
        setIconGenerator.invoke((Object)component, generator);
        this.testRead(design, component);
        this.testWrite(design, component, true);
    }

    @Test
    public void enabledItemsSerialization() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        AbstractListing component = (AbstractListing)this.getComponentClass().newInstance();
        Method setEnabledITemsGenerator = this.getEnabledItemsProviderMethod(component);
        if (setEnabledITemsGenerator == null) {
            return;
        }
        List<String> items = Arrays.asList("foo", "bar", "foobar");
        String design = String.format("<%s>\n<option item='foo'>foo</option>\n<option item='bar' disabled>bar</option><option item='foobar'>foobar</option>", this.getComponentTag(), this.getComponentTag());
        component.setItems(items);
        SerializablePredicate & Serializable predicate = (SerializablePredicate & Serializable)item -> !item.equals("bar");
        setEnabledITemsGenerator.invoke((Object)component, predicate);
        this.testRead(design, component);
        this.testWrite(design, component, true);
    }

    @Test
    public abstract void readOnlySelection() throws InstantiationException, IllegalAccessException, InvocationTargetException;

    @Override
    protected boolean acceptProperty(Class<?> clazz, Method readMethod, Method writeMethod) {
        Class<?> returnType;
        if (readMethod != null && (ItemCaptionGenerator.class.equals(returnType = readMethod.getReturnType()) || IconGenerator.class.equals(returnType) || SerializablePredicate.class.equals(returnType))) {
            return false;
        }
        return super.acceptProperty(clazz, readMethod, writeMethod);
    }

    public DesignContext readComponentAndCompare(String design, T expected, Consumer<DesignContext> configureContext) {
        DesignContext context = super.readComponentAndCompare(design, expected);
        configureContext.accept(context);
        AbstractListing read = (AbstractListing)context.getRootComponent();
        this.testReadData(design, expected, read, context);
        return context;
    }

    public T testRead(String design, T expected, boolean testWrite) {
        AbstractListing read = (AbstractListing)this.testRead(design, expected);
        if (testWrite) {
            DesignContext context = new DesignContext();
            context.setShouldWriteDataDelegate(DeclarativeTestBaseBase.ALWAYS_WRITE_DATA);
            this.testReadData(design, expected, read, context);
        }
        return (T)read;
    }

    private void testReadData(String design, T expected, T read, DesignContext context) {
        Assert.assertEquals((long)read.getDataCommunicator().getDataProvider().size(new Query()), (long)expected.getDataCommunicator().getDataProvider().size(new Query()));
        this.testWrite(read, design, context);
    }

    private Method getIconGeneratorMethod(T component) throws IllegalAccessException, InvocationTargetException {
        try {
            return component.getClass().getMethod("setItemIconGenerator", IconGenerator.class);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }

    private Method getEnabledItemsProviderMethod(T component) throws IllegalAccessException, InvocationTargetException {
        try {
            return component.getClass().getMethod("setItemEnabledProvider", SerializablePredicate.class);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }

    private Resource generateIcons(Object item, List<String> items) {
        int index = items.indexOf(item);
        switch (index) {
            case 0: {
                return new ExternalResource(EXTERNAL_URL);
            }
            case 1: {
                return new FileResource(new File(FILE_PATH));
            }
            case 2: {
                return new ThemeResource(THEME_PATH);
            }
        }
        return null;
    }
}

