/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.abstractdatefield;

import com.vaadin.shared.ui.datefield.DateResolution;
import com.vaadin.tests.server.component.abstractfield.AbstractFieldDeclarativeTest;
import com.vaadin.ui.AbstractLocalDateField;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.util.Locale;
import org.junit.Test;

public abstract class AbstractLocalDateFieldDeclarativeTest<T extends AbstractLocalDateField>
extends AbstractFieldDeclarativeTest<T, LocalDate> {
    @Override
    public void valueDeserialization() throws InstantiationException, IllegalAccessException {
        LocalDate value = LocalDate.of(2003, 2, 27);
        String design = String.format("<%s value='%s'/>", this.getComponentTag(), value);
        AbstractLocalDateField component = (AbstractLocalDateField)this.getComponentClass().newInstance();
        component.setValue((Temporal)value);
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Test
    public void abstractDateFieldAttributesDeserialization() throws InstantiationException, IllegalAccessException {
        boolean showIsoWeeks = true;
        LocalDate end = LocalDate.of(2019, 1, 15);
        LocalDate start = LocalDate.of(2001, 2, 11);
        String dateOutOfRange = "test date out of range";
        DateResolution resolution = DateResolution.MONTH;
        String dateFormat = "test format";
        boolean lenient = true;
        String parseErrorMsg = "test parse error";
        String design = String.format("<%s show-iso-week-numbers range-end='%s' range-start='%s' date-out-of-range-message='%s' resolution='%s' date-format='%s' lenient parse-error-message='%s'/>", this.getComponentTag(), end, start, dateOutOfRange, resolution.name().toLowerCase(Locale.ROOT), dateFormat, parseErrorMsg);
        AbstractLocalDateField component = (AbstractLocalDateField)this.getComponentClass().newInstance();
        component.setShowISOWeekNumbers(showIsoWeeks);
        component.setRangeEnd((Temporal)end);
        component.setRangeStart((Temporal)start);
        component.setDateOutOfRangeMessage(dateOutOfRange);
        component.setResolution((Enum)resolution);
        component.setDateFormat(dateFormat);
        component.setLenient(lenient);
        component.setParseErrorMessage(parseErrorMsg);
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Override
    public void readOnlyValue() throws InstantiationException, IllegalAccessException {
        LocalDate value = LocalDate.of(2003, 2, 27);
        String design = String.format("<%s value='%s' readonly/>", this.getComponentTag(), value);
        AbstractLocalDateField component = (AbstractLocalDateField)this.getComponentClass().newInstance();
        component.setValue((Temporal)value);
        component.setReadOnly(true);
        this.testRead(design, component);
        this.testWrite(design, component);
    }
}

