/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server;

import com.vaadin.util.FileTypeResolver;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class FileTypeResolverTest {
    private static final String FLASH_MIME_TYPE = "application/x-shockwave-flash";
    private static final String TEXT_MIME_TYPE = "text/plain";
    private static final String HTML_MIME_TYPE = "text/html";

    @Test
    public void testMimeTypes() {
        File plainFlash = new File("MyFlash.swf");
        File plainText = new File("/a/b/MyFlash.txt");
        File plainHtml = new File("c:\\MyFlash.html");
        Assert.assertEquals((Object)FileTypeResolver.getMIMEType((String)plainFlash.getAbsolutePath()), (Object)FLASH_MIME_TYPE);
        Assert.assertEquals((Object)FileTypeResolver.getMIMEType((String)(plainFlash.getAbsolutePath() + "?param1=value1")), (Object)FLASH_MIME_TYPE);
        Assert.assertEquals((Object)FileTypeResolver.getMIMEType((String)(plainFlash.getAbsolutePath() + "?param1=value1&param2=value2")), (Object)FLASH_MIME_TYPE);
        Assert.assertEquals((Object)FileTypeResolver.getMIMEType((String)plainText.getAbsolutePath()), (Object)TEXT_MIME_TYPE);
        Assert.assertEquals((Object)FileTypeResolver.getMIMEType((String)(plainText.getAbsolutePath() + "?param1=value1")), (Object)TEXT_MIME_TYPE);
        Assert.assertEquals((Object)FileTypeResolver.getMIMEType((String)(plainText.getAbsolutePath() + "?param1=value1&param2=value2")), (Object)TEXT_MIME_TYPE);
        Assert.assertEquals((Object)FileTypeResolver.getMIMEType((String)plainHtml.getAbsolutePath()), (Object)HTML_MIME_TYPE);
        Assert.assertEquals((Object)FileTypeResolver.getMIMEType((String)(plainHtml.getAbsolutePath() + "?param1=value1")), (Object)HTML_MIME_TYPE);
        Assert.assertEquals((Object)FileTypeResolver.getMIMEType((String)(plainHtml.getAbsolutePath() + "?param1=value1&param2=value2")), (Object)HTML_MIME_TYPE);
        Assert.assertEquals((Object)FileTypeResolver.DEFAULT_MIME_TYPE, (Object)FileTypeResolver.getMIMEType((String)""));
        Assert.assertEquals((Object)FileTypeResolver.DEFAULT_MIME_TYPE, (Object)FileTypeResolver.getMIMEType((String)"?param1"));
    }

    @Test
    public void testExtensionCase() {
        Assert.assertEquals((Object)"image/jpeg", (Object)FileTypeResolver.getMIMEType((String)"abc.jpg"));
        Assert.assertEquals((Object)"image/jpeg", (Object)FileTypeResolver.getMIMEType((String)"abc.jPg"));
        Assert.assertEquals((Object)"image/jpeg", (Object)FileTypeResolver.getMIMEType((String)"abc.JPG"));
        Assert.assertEquals((Object)"image/jpeg", (Object)FileTypeResolver.getMIMEType((String)"abc.JPEG"));
        Assert.assertEquals((Object)"image/jpeg", (Object)FileTypeResolver.getMIMEType((String)"abc.Jpeg"));
        Assert.assertEquals((Object)"image/jpeg", (Object)FileTypeResolver.getMIMEType((String)"abc.JPE"));
    }

    @Test
    public void testCustomMimeType() {
        Assert.assertEquals((Object)FileTypeResolver.DEFAULT_MIME_TYPE, (Object)FileTypeResolver.getMIMEType((String)"vaadin.foo"));
        FileTypeResolver.addExtension((String)"foo", (String)"Vaadin Foo/Bar");
        FileTypeResolver.addExtension((String)"FOO2", (String)"Vaadin Foo/Bar2");
        Assert.assertEquals((Object)"Vaadin Foo/Bar", (Object)FileTypeResolver.getMIMEType((String)"vaadin.foo"));
        Assert.assertEquals((Object)"Vaadin Foo/Bar2", (Object)FileTypeResolver.getMIMEType((String)"vaadin.Foo2"));
    }
}

