/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.design;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.declarative.Design;
import com.vaadin.ui.declarative.DesignContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Locale;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocaleTest {
    DesignContext ctx;

    @Before
    public void setUp() {
        this.ctx = new DesignContext();
    }

    @Test
    public void testHtmlGeneration() {
        VerticalLayout vLayout = new VerticalLayout();
        vLayout.setLocale(Locale.US);
        HorizontalLayout hLayout = new HorizontalLayout();
        hLayout.setLocale(Locale.ITALY);
        vLayout.addComponent((Component)hLayout);
        Button b1 = new Button();
        b1.setLocale(Locale.ITALY);
        Button b2 = new Button();
        b2.setLocale(Locale.US);
        hLayout.addComponent((Component)b1);
        hLayout.addComponent((Component)b2);
        HorizontalLayout hlayout2 = new HorizontalLayout();
        hlayout2.setLocale(Locale.US);
        vLayout.addComponent((Component)hlayout2);
        Label l = new Label();
        l.setLocale(Locale.US);
        hlayout2.addComponent((Component)l);
        Label l2 = new Label();
        l2.setLocale(Locale.CANADA);
        hlayout2.addComponent((Component)l2);
        this.ctx.setRootComponent((Component)vLayout);
        Document doc = this.componentToDoc(this.ctx);
        Element body = doc.body();
        Element evLayout = body.child(0);
        Assert.assertEquals((String)"Wrong locale information.", (Object)"en_US", (Object)evLayout.attr("locale"));
        Element ehLayout = evLayout.child(0);
        Assert.assertEquals((String)"Wrong locale information.", (Object)"it_IT", (Object)ehLayout.attr("locale"));
        Element eb1 = ehLayout.child(0);
        Assert.assertTrue((String)("The element should not have a locale specification, found locale " + eb1.attr("locale")), (boolean)eb1.attr("locale").isEmpty());
        Element eb2 = ehLayout.child(1);
        Assert.assertEquals((String)"Wrong locale information.", (Object)"en_US", (Object)eb2.attr("locale"));
        Element ehLayout2 = evLayout.child(1);
        Assert.assertTrue((String)("The element should not have a locale specification, found locale " + ehLayout2.attr("locale")), (boolean)ehLayout2.attr("locale").isEmpty());
        Element el1 = ehLayout2.child(0);
        Assert.assertTrue((String)("The element should not have a locale specification, found locale " + el1.attr("locale")), (boolean)el1.attr("locale").isEmpty());
        Element el2 = ehLayout2.child(1);
        Assert.assertEquals((String)"Wrong locale information.", (Object)"en_CA", (Object)el2.attr("locale"));
    }

    private Document componentToDoc(DesignContext dc) {
        Document doc = new Document("");
        DocumentType docType = new DocumentType("html", "", "");
        doc.appendChild((Node)docType);
        Element html = doc.createElement("html");
        doc.appendChild((Node)html);
        html.appendChild((Node)doc.createElement("head"));
        Element body = doc.createElement("body");
        html.appendChild((Node)body);
        dc.writePackageMappings(doc);
        Component root = dc.getRootComponent();
        Element rootNode = dc.createElement(root);
        body.appendChild((Node)rootNode);
        return doc;
    }

    @Test
    public void testParsing() {
        Document doc = new Document("");
        DocumentType docType = new DocumentType("html", "", "");
        doc.appendChild((Node)docType);
        Element html = doc.createElement("html");
        doc.appendChild((Node)html);
        html.appendChild((Node)doc.createElement("head"));
        Element body = doc.createElement("body");
        html.appendChild((Node)body);
        Element evLayout = doc.createElement("vaadin-vertical-layout");
        evLayout.attr("locale", "en_US");
        body.appendChild((Node)evLayout);
        Element ehLayout = doc.createElement("vaadin-horizontal-layout");
        evLayout.appendChild((Node)ehLayout);
        Element eb1 = doc.createElement("vaadin-button");
        eb1.attr("locale", "en_US");
        ehLayout.appendChild((Node)eb1);
        Element eb2 = doc.createElement("vaadin-button");
        eb2.attr("locale", "en_GB");
        ehLayout.appendChild((Node)eb2);
        Element eb3 = doc.createElement("vaadin-button");
        ehLayout.appendChild((Node)eb3);
        String string = doc.html();
        VerticalLayout vLayout = (VerticalLayout)Design.read((InputStream)new ByteArrayInputStream(string.getBytes()));
        Assert.assertEquals((String)"Wrong locale.", (Object)new Locale("en", "US"), (Object)vLayout.getLocale());
        HorizontalLayout hLayout = (HorizontalLayout)vLayout.getComponent(0);
        Assert.assertEquals((String)"The element should have the same locale as its parent.", (Object)vLayout.getLocale(), (Object)hLayout.getLocale());
        Button b1 = (Button)hLayout.getComponent(0);
        Assert.assertEquals((String)"Wrong locale.", (Object)new Locale("en", "US"), (Object)b1.getLocale());
        Button b2 = (Button)hLayout.getComponent(1);
        Assert.assertEquals((String)"Wrong locale.", (Object)new Locale("en", "GB"), (Object)b2.getLocale());
        Button b3 = (Button)hLayout.getComponent(2);
        Assert.assertEquals((String)"The component should have the same locale as its parent.", (Object)hLayout.getLocale(), (Object)b3.getLocale());
    }
}

