/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.design;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.declarative.Design;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.ui.declarative.DesignException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DesignTest {
    @Test
    public void readStream() throws FileNotFoundException {
        Component root = Design.read((InputStream)this.getClass().getResourceAsStream("verticallayout-two-children.html"));
        VerticalLayout rootLayout = (VerticalLayout)root;
        Assert.assertEquals(VerticalLayout.class, root.getClass());
        Assert.assertEquals((long)2L, (long)rootLayout.getComponentCount());
        Assert.assertEquals(TextField.class, rootLayout.getComponent(0).getClass());
        Assert.assertEquals(Button.class, rootLayout.getComponent(1).getClass());
    }

    @Test(expected=DesignException.class)
    @Ignore(value="Feature needs to be fixed")
    public void readWithIncorrectRoot() throws FileNotFoundException {
        Design.read((InputStream)this.getClass().getResourceAsStream("verticallayout-one-child.html"), (Component)new Panel());
    }

    @Test
    public void readWithSubClassRoot() throws FileNotFoundException {
        Design.read((InputStream)this.getClass().getResourceAsStream("verticallayout-one-child.html"), (Component)new MyVerticalLayout());
    }

    @Test
    public void writeComponentToStream() throws IOException {
        HorizontalLayout root = new HorizontalLayout(new Component[]{new Button("OK"), new Button("Cancel")});
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Design.write((Component)root, (OutputStream)baos);
        Component newRoot = Design.read((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        this.assertHierarchyEquals((Component)root, newRoot);
    }

    @Test
    public void writeDesignContextToStream() throws IOException {
        DesignContext dc = Design.read((InputStream)this.getClass().getResourceAsStream("verticallayout-two-children.html"), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Design.write((DesignContext)dc, (OutputStream)baos);
        Component newRoot = Design.read((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        this.assertHierarchyEquals(dc.getRootComponent(), newRoot);
    }

    @Test(expected=DesignException.class)
    public void testDuplicateIds() throws FileNotFoundException {
        Design.read((InputStream)this.getClass().getResourceAsStream("duplicate-ids.html"));
    }

    @Test(expected=DesignException.class)
    public void testDuplicateLocalIds() throws FileNotFoundException {
        Design.read((InputStream)this.getClass().getResourceAsStream("duplicate-local-ids.html"));
    }

    private void assertHierarchyEquals(Component expected, Component actual) {
        if (expected.getClass() != actual.getClass()) {
            throw new AssertionError((Object)("Component classes do not match. Expected: " + expected.getClass().getName() + ", was: " + actual.getClass().getName()));
        }
        if (expected instanceof HasComponents) {
            HasComponents expectedHC = (HasComponents)expected;
            HasComponents actualHC = (HasComponents)actual;
            Iterator eI = expectedHC.iterator();
            Iterator aI = actualHC.iterator();
            while (eI.hasNext()) {
                this.assertHierarchyEquals((Component)eI.next(), (Component)aI.next());
            }
        }
    }

    public static class MyVerticalLayout
    extends VerticalLayout {
    }
}

