/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.design;

import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.declarative.Design;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.ui.declarative.ShouldWriteDataDelegate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.junit.Assert;

public abstract class DeclarativeTestBaseBase<T extends Component> {
    private static final String[] booleanAttributes = new String[]{"allowfullscreen", "async", "autofocus", "checked", "compact", "declare", "default", "defer", "disabled", "formnovalidate", "hidden", "inert", "ismap", "itemscope", "multiple", "muted", "nohref", "noresize", "noshade", "novalidate", "nowrap", "open", "readonly", "required", "reversed", "seamless", "selected", "sortable", "truespeed", "typemustmatch"};
    public static final ShouldWriteDataDelegate ALWAYS_WRITE_DATA = new AlwaysWriteDelegate();

    protected T read(String design) {
        return (T)Design.read((InputStream)new ByteArrayInputStream(design.getBytes(StandardCharsets.UTF_8)));
    }

    protected DesignContext readAndReturnContext(String design) {
        return Design.read((InputStream)new ByteArrayInputStream(design.getBytes(StandardCharsets.UTF_8)), null);
    }

    protected String write(T object, boolean writeData) {
        DesignContext dc = new DesignContext();
        if (writeData) {
            dc.setShouldWriteDataDelegate(ALWAYS_WRITE_DATA);
        }
        return this.write(object, dc);
    }

    protected String write(T object, DesignContext context) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            context.setRootComponent(object);
            Design.write((DesignContext)context, (OutputStream)outputStream);
            return outputStream.toString(StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void assertEqualsCustom(Object o1, Object o2) {
        this.assertEqualsCustom("", o1, o2);
    }

    protected void assertEqualsCustom(String message, Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            Assert.assertNull((String)message, (Object)o1);
            Assert.assertNull((String)message, (Object)o2);
            return;
        }
        if (!(o1 instanceof Collection) || !(o2 instanceof Collection)) {
            Assert.assertEquals(o1.getClass(), o2.getClass());
        }
        if (o1 instanceof Object[]) {
            Object[] a1 = (Object[])o1;
            Object[] a2 = (Object[])o2;
            Assert.assertEquals((String)(message + ": array length"), (long)a1.length, (long)a2.length);
            for (int i = 0; i < a1.length; ++i) {
                this.assertEqualsCustom(message + ": element " + i, a1[i], a2[i]);
            }
            return;
        }
        List<EqualsAsserter<Object>> comparators = this.getComparators(o1);
        if (!comparators.isEmpty()) {
            for (EqualsAsserter<Object> ec : comparators) {
                ec.assertObjectEquals(o1, o2);
            }
        } else {
            Assert.assertEquals((String)message, (Object)o1, (Object)o2);
        }
    }

    private List<EqualsAsserter<Object>> getComparators(Object o1) {
        ArrayList<EqualsAsserter<Object>> result = new ArrayList<EqualsAsserter<Object>>();
        this.getComparators(o1.getClass(), result);
        return result;
    }

    private void getComparators(Class<?> c, List<EqualsAsserter<Object>> result) {
        if (c == null || !this.isVaadin(c)) {
            return;
        }
        EqualsAsserter<?> comparator = this.getComparator(c);
        if (c.getSuperclass() != Object.class) {
            this.getComparators(c.getSuperclass(), result);
        }
        for (Class<?> i : c.getInterfaces()) {
            this.getComparators(i, result);
        }
        if (!result.contains(comparator)) {
            result.add(comparator);
        }
    }

    protected abstract <TT> EqualsAsserter<TT> getComparator(Class<TT> var1);

    private boolean isVaadin(Class<?> c) {
        return c.getPackage() != null && c.getPackage().getName().startsWith("com.vaadin");
    }

    public T testRead(String design, T expected) {
        TestLogHandler l = new TestLogHandler();
        T read = this.read(design);
        this.assertEqualsCustom(expected, read);
        Assert.assertEquals((Object)"", (Object)l.getMessages());
        return read;
    }

    public DesignContext readComponentAndCompare(String design, T expected) {
        TestLogHandler l = new TestLogHandler();
        DesignContext context = this.readAndReturnContext(design);
        this.assertEqualsCustom(expected, context.getRootComponent());
        Assert.assertEquals((Object)"", (Object)l.getMessages());
        return context;
    }

    public void testWrite(String expected, T component) {
        TestLogHandler l = new TestLogHandler();
        this.testWrite(expected, component, false);
        Assert.assertEquals((Object)"", (Object)l.getMessages());
    }

    public void testWrite(String expectedDesign, T component, boolean writeData) {
        String written = this.write(component, writeData);
        Element producedElem = Jsoup.parse((String)written).body().child(0);
        Element comparableElem = Jsoup.parse((String)expectedDesign).body().child(0);
        String produced = this.elementToHtml(producedElem);
        String comparable = this.elementToHtml(comparableElem);
        Assert.assertEquals((Object)comparable, (Object)produced);
    }

    public void testWrite(T component, String expected, DesignContext context) {
        String written = this.write(component, context);
        Element producedElem = Jsoup.parse((String)written).body().child(0);
        Element comparableElem = Jsoup.parse((String)expected).body().child(0);
        String produced = this.elementToHtml(producedElem);
        String comparable = this.elementToHtml(comparableElem);
        Assert.assertEquals((Object)comparable, (Object)produced);
    }

    protected Element createElement(Component c) {
        return new DesignContext().createElement(c);
    }

    private String elementToHtml(Element producedElem) {
        StringBuilder stringBuilder = new StringBuilder();
        this.elementToHtml(producedElem, stringBuilder);
        return stringBuilder.toString();
    }

    private String elementToHtml(Element producedElem, StringBuilder sb) {
        HashSet<String> booleanAttributes = new HashSet<String>();
        ArrayList<String> names = new ArrayList<String>();
        for (Attribute a : producedElem.attributes().asList()) {
            names.add(a.getKey());
            if (!DeclarativeTestBaseBase.isBooleanAttribute(a.getKey())) continue;
            booleanAttributes.add(a.getKey());
        }
        Collections.sort(names);
        sb.append('<').append(producedElem.tagName());
        for (String attrName : names) {
            sb.append(' ').append(attrName);
            if (booleanAttributes.contains(attrName)) continue;
            sb.append('=').append("'").append(producedElem.attr(attrName)).append("'");
        }
        sb.append('>');
        for (Node child : producedElem.childNodes()) {
            if (child instanceof Element) {
                this.elementToHtml((Element)child, sb);
                continue;
            }
            if (!(child instanceof TextNode)) continue;
            String text = ((TextNode)child).text();
            sb.append(text.trim());
        }
        sb.append("</").append(producedElem.tagName()).append('>');
        return sb.toString();
    }

    protected static boolean isBooleanAttribute(String key) {
        return Arrays.binarySearch(booleanAttributes, key) >= 0;
    }

    protected String stripOptionTags(String design) {
        return design.replaceAll("[ \n]*<option(.*)</option>[ \n]*", "");
    }

    public static class TestLogHandler {
        final List<String> messages = new ArrayList<String>();
        Handler handler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                messages.add(record.getMessage());
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };

        public TestLogHandler() {
            Logger.getLogger(AbstractComponent.class.getName()).getParent().addHandler(this.handler);
        }

        public String getMessages() {
            if (this.messages.isEmpty()) {
                return "";
            }
            String r = "";
            for (String message : this.messages) {
                r = r + message + "\n";
            }
            return r;
        }
    }

    public static interface EqualsAsserter<TT> {
        public void assertObjectEquals(TT var1, TT var2);
    }

    private static final class AlwaysWriteDelegate
    implements ShouldWriteDataDelegate {
        private static final long serialVersionUID = -6345914431997793599L;

        private AlwaysWriteDelegate() {
        }

        public boolean shouldWriteData(Component component) {
            return true;
        }
    }
}

