/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.data.converter;

import com.vaadin.data.ValueContext;
import com.vaadin.data.converter.StringToFloatConverter;
import com.vaadin.tests.data.converter.AbstractStringConverterTest;
import org.junit.Assert;
import org.junit.Test;

public class StringToFloatConverterTest
extends AbstractStringConverterTest {
    protected StringToFloatConverter getConverter() {
        return new StringToFloatConverter(this.getErrorMessage());
    }

    @Override
    @Test
    public void testNullConversion() {
        this.assertValue(null, this.getConverter().convertToModel(null, new ValueContext()));
    }

    @Override
    @Test
    public void testEmptyStringConversion() {
        this.assertValue(null, this.getConverter().convertToModel("", new ValueContext()));
    }

    @Test
    public void testValueConversion() {
        this.assertValue(Float.valueOf(10.0f), this.getConverter().convertToModel("10", new ValueContext()));
    }

    @Test
    public void customEmptyValue() {
        StringToFloatConverter converter = new StringToFloatConverter(Float.valueOf(0.0f), this.getErrorMessage());
        this.assertValue(Float.valueOf(0.0f), converter.convertToModel("", new ValueContext()));
        Assert.assertEquals((Object)"0", (Object)converter.convertToPresentation((Number)Float.valueOf(0.0f), new ValueContext()));
    }
}

